/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.helpers;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.TimeLimitIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.algebra.Add;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Copy;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.Move;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.repository.sail.helpers.RDFSailInserter;
import org.eclipse.rdf4j.repository.sail.helpers.RDFSailRemover;
import org.eclipse.rdf4j.repository.sail.helpers.SPARQLUpdateDataBlockParser;
import org.eclipse.rdf4j.repository.util.RDFLoader;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.TimeLimitRDFHandler;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailUpdateExecutor {
    private final Logger logger = LoggerFactory.getLogger(SailUpdateExecutor.class);
    private final SailConnection con;
    private final ValueFactory vf;
    private final RDFLoader loader;

    public SailUpdateExecutor(SailConnection con, ValueFactory vf, ParserConfig loadConfig) {
        this.con = con;
        this.vf = vf;
        this.loader = new RDFLoader(loadConfig, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindings, boolean includeInferred, int maxExecutionTime) throws SailException, RDFParseException, IOException {
        UpdateContext uc = new UpdateContext(updateExpr, dataset, bindings, includeInferred);
        this.logger.trace("Incoming update expression:\n{}", (Object)uc);
        this.con.startUpdate(uc);
        try {
            if (updateExpr instanceof Load) {
                this.executeLoad((Load)updateExpr, uc);
            } else if (updateExpr instanceof Modify) {
                this.executeModify((Modify)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof InsertData) {
                this.executeInsertData((InsertData)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof DeleteData) {
                this.executeDeleteData((DeleteData)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof Clear) {
                this.executeClear((Clear)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof Create) {
                this.executeCreate((Create)updateExpr, uc);
            } else if (updateExpr instanceof Copy) {
                this.executeCopy((Copy)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof Add) {
                this.executeAdd((Add)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof Move) {
                this.executeMove((Move)updateExpr, uc, maxExecutionTime);
            } else if (updateExpr instanceof Load) {
                throw new SailException("load operations can not be handled directly by the SAIL");
            }
        }
        finally {
            this.con.endUpdate(uc);
        }
    }

    protected void executeLoad(Load load, UpdateContext uc) throws IOException, RDFParseException, SailException {
        Value source = load.getSource().getValue();
        Value graph = load.getGraph() != null ? load.getGraph().getValue() : null;
        URL sourceURL = new URL(source.stringValue());
        RDFSailInserter rdfInserter = new RDFSailInserter(this.con, this.vf, uc);
        if (graph != null) {
            rdfInserter.enforceContext((Resource)graph);
        }
        try {
            this.loader.load(sourceURL, source.stringValue(), null, (RDFHandler)rdfInserter);
        }
        catch (RDFHandlerException e) {
            throw (SailException)e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCreate(Create create, UpdateContext uc) throws SailException {
        Value graphValue = create.getGraph().getValue();
        if (graphValue instanceof Resource) {
            Resource namedGraph = (Resource)graphValue;
            try (CloseableIteration<? extends Resource, SailException> contextIDs = null;){
                contextIDs = this.con.getContextIDs();
                while (contextIDs.hasNext()) {
                    Resource contextID = (Resource)contextIDs.next();
                    if (!namedGraph.equals(contextID)) continue;
                    throw new SailException("Named graph " + namedGraph + " already exists. ");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCopy(Copy copy, UpdateContext uc, int maxExecutionTime) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = copy.getSourceGraph();
        ValueConstant destinationGraph = copy.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        long start = System.currentTimeMillis();
        this.con.clear(destination);
        long clearTime = (System.currentTimeMillis() - start) / 1000L;
        if (maxExecutionTime > 0 && clearTime > (long)maxExecutionTime) {
            throw new SailException("execution took too long");
        }
        try (TimeLimitIteration<Statement, SailException> statements = null;){
            statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
            if (maxExecutionTime > 0) {
                statements = new TimeLimitIteration<Statement, SailException>(statements, 1000L * ((long)maxExecutionTime - clearTime)){

                    @Override
                    protected void throwInterruptedException() throws SailException {
                        throw new SailException("execution took too long");
                    }
                };
            }
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAdd(Add add, UpdateContext uc, int maxExecTime) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = add.getSourceGraph();
        ValueConstant destinationGraph = add.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        try (TimeLimitIteration<Statement, SailException> statements = null;){
            statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
            if (maxExecTime > 0) {
                statements = new TimeLimitIteration<Statement, SailException>(statements, 1000L * (long)maxExecTime){

                    @Override
                    protected void throwInterruptedException() throws SailException {
                        throw new SailException("execution took too long");
                    }
                };
            }
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMove(Move move, UpdateContext uc, int maxExecutionTime) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = move.getSourceGraph();
        ValueConstant destinationGraph = move.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        long start = System.currentTimeMillis();
        this.con.clear(destination);
        long clearTime = (System.currentTimeMillis() - start) / 1000L;
        if (maxExecutionTime > 0 && clearTime > (long)maxExecutionTime) {
            throw new SailException("execution took too long");
        }
        try (TimeLimitIteration<Statement, SailException> statements = null;){
            statements = this.con.getStatements(null, null, null, uc.isIncludeInferred(), source);
            if (maxExecutionTime > 0) {
                statements = new TimeLimitIteration<Statement, SailException>(statements, 1000L * ((long)maxExecutionTime - clearTime)){

                    @Override
                    protected void throwInterruptedException() throws SailException {
                        throw new SailException("execution took too long");
                    }
                };
            }
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), destination);
                this.con.removeStatement(uc, st.getSubject(), st.getPredicate(), st.getObject(), source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeClear(Clear clearExpr, UpdateContext uc, int maxExecutionTime) throws SailException {
        block12: {
            try {
                ValueConstant graph = clearExpr.getGraph();
                if (graph != null) {
                    Resource context = (Resource)graph.getValue();
                    this.con.clear(context);
                    break block12;
                }
                StatementPattern.Scope scope = clearExpr.getScope();
                if (StatementPattern.Scope.NAMED_CONTEXTS.equals((Object)scope)) {
                    try (TimeLimitIteration<Resource, SailException> contextIDs = null;){
                        contextIDs = this.con.getContextIDs();
                        if (maxExecutionTime > 0) {
                            contextIDs = new TimeLimitIteration<Resource, SailException>(contextIDs, 1000L * (long)maxExecutionTime){

                                @Override
                                protected void throwInterruptedException() throws SailException {
                                    throw new SailException("execution took too long");
                                }
                            };
                        }
                        while (contextIDs.hasNext()) {
                            this.con.clear((Resource)contextIDs.next());
                        }
                        break block12;
                    }
                }
                if (StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)scope)) {
                    this.con.clear(new Resource[]{null});
                } else {
                    this.con.clear(new Resource[0]);
                }
            }
            catch (SailException e) {
                if (clearExpr.isSilent()) break block12;
                throw e;
            }
        }
    }

    protected void executeInsertData(InsertData insertDataExpr, UpdateContext uc, int maxExecutionTime) throws SailException {
        SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser(this.vf);
        RDFHandler handler = new RDFSailInserter(this.con, this.vf, uc);
        if (maxExecutionTime > 0) {
            handler = new TimeLimitRDFHandler(handler, 1000L * (long)maxExecutionTime);
        }
        parser.setRDFHandler(handler);
        parser.setLineNumberOffset(insertDataExpr.getLineNumberOffset());
        parser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        parser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        try {
            parser.parse(new StringReader(insertDataExpr.getDataBlock()), "");
        }
        catch (RDFParseException e) {
            throw new SailException(e);
        }
        catch (RDFHandlerException e) {
            throw new SailException(e);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    protected void executeDeleteData(DeleteData deleteDataExpr, UpdateContext uc, int maxExecutionTime) throws SailException {
        SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser(this.vf);
        parser.setLineNumberOffset(deleteDataExpr.getLineNumberOffset());
        parser.setAllowBlankNodes(false);
        RDFHandler handler = new RDFSailRemover(this.con, this.vf, uc);
        if (maxExecutionTime > 0) {
            handler = new TimeLimitRDFHandler(handler, 1000L * (long)maxExecutionTime);
        }
        parser.setRDFHandler(handler);
        try {
            parser.parse(new StringReader(deleteDataExpr.getDataBlock()), "");
        }
        catch (RDFParseException e) {
            throw new SailException(e);
        }
        catch (RDFHandlerException e) {
            throw new SailException(e);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeModify(Modify modify, UpdateContext uc, int maxExecutionTime) throws SailException {
        try {
            TupleExpr whereClause = modify.getWhereExpr();
            if (!(whereClause instanceof QueryRoot)) {
                whereClause = new QueryRoot(whereClause);
            }
            try (CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = null;){
                sourceBindings = this.evaluateWhereClause(whereClause, uc, maxExecutionTime);
                while (sourceBindings.hasNext()) {
                    BindingSet sourceBinding = (BindingSet)sourceBindings.next();
                    this.deleteBoundTriples(sourceBinding, modify.getDeleteExpr(), uc);
                    this.insertBoundTriples(sourceBinding, modify.getInsertExpr(), uc);
                }
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    private IRI[] getDefaultRemoveGraphs(Dataset dataset) {
        if (dataset == null) {
            return new IRI[0];
        }
        HashSet<IRI> set = new HashSet<IRI>(dataset.getDefaultRemoveGraphs());
        if (set.isEmpty()) {
            return new IRI[0];
        }
        if (set.remove(SESAME.NIL)) {
            set.add(null);
        }
        return set.toArray(new IRI[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateWhereClause(final TupleExpr whereClause, final UpdateContext uc, int maxExecutionTime) throws SailException, QueryEvaluationException {
        TimeLimitIteration<BindingSet, QueryEvaluationException> sourceBindings1 = null;
        TimeLimitIteration<BindingSet, QueryEvaluationException> sourceBindings2 = null;
        AbstractCloseableIteration result = null;
        boolean allGood = false;
        try {
            sourceBindings1 = this.con.evaluate(whereClause, uc.getDataset(), uc.getBindingSet(), uc.isIncludeInferred());
            sourceBindings2 = maxExecutionTime > 0 ? new TimeLimitIteration<BindingSet, QueryEvaluationException>(sourceBindings1, 1000L * (long)maxExecutionTime){

                @Override
                protected void throwInterruptedException() throws QueryEvaluationException {
                    throw new QueryInterruptedException("execution took too long");
                }
            } : sourceBindings1;
            result = new ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException>(sourceBindings2){

                @Override
                protected BindingSet convert(BindingSet sourceBinding) throws QueryEvaluationException {
                    if (whereClause instanceof SingletonSet && sourceBinding instanceof EmptyBindingSet && uc.getBindingSet() != null) {
                        return uc.getBindingSet();
                    }
                    HashSet<String> uniqueBindings = new HashSet<String>(uc.getBindingSet().getBindingNames());
                    uniqueBindings.removeAll(sourceBinding.getBindingNames());
                    if (uniqueBindings.size() > 0) {
                        MapBindingSet mergedSet = new MapBindingSet();
                        for (String bindingName : sourceBinding.getBindingNames()) {
                            mergedSet.addBinding(sourceBinding.getBinding(bindingName));
                        }
                        for (String bindingName : uniqueBindings) {
                            mergedSet.addBinding(uc.getBindingSet().getBinding(bindingName));
                        }
                        return mergedSet;
                    }
                    return sourceBinding;
                }
            };
            allGood = true;
            AbstractCloseableIteration abstractCloseableIteration = result;
            return abstractCloseableIteration;
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (sourceBindings2 != null) {
                            sourceBindings2.close();
                        }
                    }
                    finally {
                        if (sourceBindings1 != null) {
                            sourceBindings1.close();
                        }
                    }
                }
            }
        }
    }

    private void deleteBoundTriples(BindingSet whereBinding, TupleExpr deleteClause, UpdateContext uc) throws SailException {
        if (deleteClause != null) {
            List<StatementPattern> deletePatterns = StatementPatternCollector.process(deleteClause);
            for (StatementPattern deletePattern : deletePatterns) {
                Value patternValue = this.getValueForVar(deletePattern.getSubjectVar(), whereBinding);
                Resource subject = patternValue instanceof Resource ? (Resource)patternValue : null;
                patternValue = this.getValueForVar(deletePattern.getPredicateVar(), whereBinding);
                IRI predicate = patternValue instanceof IRI ? (IRI)patternValue : null;
                Value object = this.getValueForVar(deletePattern.getObjectVar(), whereBinding);
                Resource context = null;
                if (deletePattern.getContextVar() != null) {
                    patternValue = this.getValueForVar(deletePattern.getContextVar(), whereBinding);
                    Resource resource = context = patternValue instanceof Resource ? (Resource)patternValue : null;
                }
                if (subject == null || predicate == null || object == null) continue;
                if (context != null) {
                    if (SESAME.NIL.equals(context)) {
                        this.con.removeStatement(uc, subject, predicate, object, new Resource[]{null});
                        continue;
                    }
                    this.con.removeStatement(uc, subject, predicate, object, context);
                    continue;
                }
                Resource[] remove = this.getDefaultRemoveGraphs(uc.getDataset());
                this.con.removeStatement(uc, subject, predicate, object, remove);
            }
        }
    }

    private void insertBoundTriples(BindingSet whereBinding, TupleExpr insertClause, UpdateContext uc) throws SailException {
        if (insertClause != null) {
            List<StatementPattern> insertPatterns = StatementPatternCollector.process(insertClause);
            MapBindingSet bnodeMapping = new MapBindingSet();
            for (StatementPattern insertPattern : insertPatterns) {
                Statement toBeInserted = this.createStatementFromPattern(insertPattern, whereBinding, bnodeMapping);
                if (toBeInserted == null) continue;
                IRI with = uc.getDataset().getDefaultInsertGraph();
                if (with == null && toBeInserted.getContext() == null) {
                    this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), new Resource[0]);
                    continue;
                }
                if (toBeInserted.getContext() == null) {
                    this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), with);
                    continue;
                }
                this.con.addStatement(uc, toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), toBeInserted.getContext());
            }
        }
    }

    private Statement createStatementFromPattern(StatementPattern pattern, BindingSet sourceBinding, MapBindingSet bnodeMapping) throws SailException {
        Value patternValue;
        Resource subject = null;
        IRI predicate = null;
        Value object = null;
        Resource context = null;
        if (pattern.getSubjectVar().hasValue()) {
            patternValue = pattern.getSubjectVar().getValue();
            if (patternValue instanceof Resource) {
                subject = (Resource)patternValue;
            }
        } else {
            patternValue = sourceBinding.getValue(pattern.getSubjectVar().getName());
            if (patternValue instanceof Resource) {
                subject = (Resource)patternValue;
            }
            if (subject == null && pattern.getSubjectVar().isAnonymous()) {
                Binding mappedSubject = bnodeMapping.getBinding(pattern.getSubjectVar().getName());
                if (mappedSubject != null) {
                    patternValue = mappedSubject.getValue();
                    if (patternValue instanceof Resource) {
                        subject = (Resource)patternValue;
                    }
                } else {
                    subject = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getSubjectVar().getName(), subject);
                }
            }
        }
        if (subject == null) {
            return null;
        }
        if (pattern.getPredicateVar().hasValue()) {
            patternValue = pattern.getPredicateVar().getValue();
            if (patternValue instanceof IRI) {
                predicate = (IRI)patternValue;
            }
        } else {
            patternValue = sourceBinding.getValue(pattern.getPredicateVar().getName());
            if (patternValue instanceof IRI) {
                predicate = (IRI)patternValue;
            }
        }
        if (predicate == null) {
            return null;
        }
        if (pattern.getObjectVar().hasValue()) {
            object = pattern.getObjectVar().getValue();
        } else {
            object = sourceBinding.getValue(pattern.getObjectVar().getName());
            if (object == null && pattern.getObjectVar().isAnonymous()) {
                Binding mappedObject = bnodeMapping.getBinding(pattern.getObjectVar().getName());
                if (mappedObject != null) {
                    patternValue = mappedObject.getValue();
                    if (patternValue instanceof Resource) {
                        object = (Resource)patternValue;
                    }
                } else {
                    object = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getObjectVar().getName(), object);
                }
            }
        }
        if (object == null) {
            return null;
        }
        if (pattern.getContextVar() != null) {
            if (pattern.getContextVar().hasValue()) {
                patternValue = pattern.getContextVar().getValue();
                if (patternValue instanceof Resource) {
                    context = (Resource)patternValue;
                }
            } else {
                patternValue = sourceBinding.getValue(pattern.getContextVar().getName());
                if (patternValue instanceof Resource) {
                    context = (Resource)patternValue;
                }
            }
        }
        Statement st = null;
        if (subject != null && predicate != null && object != null) {
            st = context != null ? this.vf.createStatement(subject, predicate, object, context) : this.vf.createStatement(subject, predicate, object);
        }
        return st;
    }

    private Value getValueForVar(Var var, BindingSet bindings) throws SailException {
        Value value = null;
        value = var.hasValue() ? var.getValue() : bindings.getValue(var.getName());
        return value;
    }
}

