/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.impl.AbstractParserUpdate;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.helpers.SailUpdateExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailUpdate
extends AbstractParserUpdate {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SailRepositoryConnection con;

    protected SailUpdate(ParsedUpdate parsedUpdate, SailRepositoryConnection con) {
        super(parsedUpdate);
        this.con = con;
    }

    protected SailRepositoryConnection getConnection() {
        return this.con;
    }

    @Override
    public void execute() throws UpdateExecutionException {
        ParsedUpdate parsedUpdate = this.getParsedUpdate();
        List<UpdateExpr> updateExprs = parsedUpdate.getUpdateExprs();
        Map<UpdateExpr, Dataset> datasetMapping = parsedUpdate.getDatasetMapping();
        SailUpdateExecutor executor = new SailUpdateExecutor(this.con.getSailConnection(), this.con.getValueFactory(), this.con.getParserConfig());
        for (UpdateExpr updateExpr : updateExprs) {
            Dataset activeDataset = this.getMergedDataset(datasetMapping.get(updateExpr));
            try {
                boolean localTransaction = this.isLocalTransaction();
                if (localTransaction) {
                    this.beginLocalTransaction();
                }
                executor.executeUpdate(updateExpr, activeDataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                if (!localTransaction) continue;
                this.commitLocalTransaction();
            }
            catch (RDF4JException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException(e);
            }
            catch (IOException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException(e);
            }
        }
    }

    private boolean isLocalTransaction() throws RepositoryException {
        return !this.getConnection().isActive();
    }

    private void beginLocalTransaction() throws RepositoryException {
        this.getConnection().begin();
    }

    private void commitLocalTransaction() throws RepositoryException {
        this.getConnection().commit();
    }
}

