/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class RemoteRepositoryManager
extends RepositoryManager {
    private volatile SharedHttpClientSessionManager client;
    private final String serverURL;
    private String username;
    private String password;

    public static RemoteRepositoryManager getInstance(String serverURL) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.initialize();
        return manager;
    }

    public static RemoteRepositoryManager getInstance(String serverURL, String username, String password) throws RepositoryException {
        RemoteRepositoryManager manager = new RemoteRepositoryManager(serverURL);
        manager.setUsernameAndPassword(username, password);
        manager.initialize();
        return manager;
    }

    public RemoteRepositoryManager(String serverURL) {
        this.serverURL = serverURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedHttpClientSessionManager getSesameClient() {
        SharedHttpClientSessionManager result = this.client;
        if (result == null) {
            RemoteRepositoryManager remoteRepositoryManager = this;
            synchronized (remoteRepositoryManager) {
                result = this.client;
                if (result == null) {
                    result = this.client = new SharedHttpClientSessionManager();
                }
            }
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient() {
        SharedHttpClientSessionManager nextClient = this.client;
        if (nextClient == null) {
            return null;
        }
        return nextClient.getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.getSesameClient().setHttpClient(httpClient);
    }

    @Override
    public void initialize() throws RepositoryException {
        super.initialize();
    }

    @Override
    public void shutDown() {
        try {
            super.shutDown();
        }
        finally {
            SharedHttpClientSessionManager toCloseClient = this.client;
            this.client = null;
            if (toCloseClient != null) {
                toCloseClient.shutDown();
            }
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    protected Repository createSystemRepository() throws RepositoryException {
        HTTPRepository systemRepository = new HTTPRepository(this.serverURL, "SYSTEM");
        systemRepository.setHttpClientSessionManager(this.getSesameClient());
        systemRepository.setUsernameAndPassword(this.username, this.password);
        systemRepository.initialize();
        return systemRepository;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return new URL(this.serverURL);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        HTTPRepository result = null;
        if (RepositoryConfigUtil.hasRepositoryConfig(this.getSystemRepository(), id)) {
            result = new HTTPRepository(this.serverURL, id);
            result.setHttpClientSessionManager(this.getSesameClient());
            result.setUsernameAndPassword(this.username, this.password);
            result.initialize();
        }
        return result;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        for (RepositoryInfo repInfo : this.getAllRepositoryInfos()) {
            if (!repInfo.getId().equals(id)) continue;
            return repInfo;
        }
        return null;
    }

    @Override
    public Collection<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        try {
            RDF4JProtocolSession httpClient = this.getSesameClient().createRDF4JProtocolSession(this.serverURL);
            httpClient.setUsernameAndPassword(this.username, this.password);
            TupleQueryResult responseFromServer = httpClient.getRepositoryList();
            while (responseFromServer.hasNext()) {
                BindingSet bindingSet = (BindingSet)responseFromServer.next();
                RepositoryInfo repInfo = new RepositoryInfo();
                String id = Literals.getLabel(bindingSet.getValue("id"), null);
                if (skipSystemRepo && id.equals("SYSTEM")) continue;
                Value uri = bindingSet.getValue("uri");
                String description = Literals.getLabel(bindingSet.getValue("title"), null);
                boolean readable = Literals.getBooleanValue(bindingSet.getValue("readable"), false);
                boolean writable = Literals.getBooleanValue(bindingSet.getValue("writable"), false);
                if (uri instanceof IRI) {
                    try {
                        repInfo.setLocation(new URL(uri.toString()));
                    }
                    catch (MalformedURLException e) {
                        this.logger.warn("Server reported malformed repository URL: {}", (Object)uri);
                    }
                }
                repInfo.setId(id);
                repInfo.setDescription(description);
                repInfo.setReadable(readable);
                repInfo.setWritable(writable);
                result.add(repInfo);
            }
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)ioe);
            throw new RepositoryException(ioe);
        }
        catch (QueryEvaluationException qee) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)qee);
            throw new RepositoryException(qee);
        }
        catch (UnauthorizedException ue) {
            this.logger.warn("Not authorized to retrieve list of repositories", (Throwable)ue);
            throw new RepositoryException(ue);
        }
        catch (RepositoryException re) {
            this.logger.warn("Unable to retrieve list of repositories", (Throwable)re);
            throw re;
        }
        return result;
    }

    @Override
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean existingRepo = RepositoryConfigUtil.hasRepositoryConfig(this.getSystemRepository(), repositoryID);
        if (existingRepo) {
            RDF4JProtocolSession httpClient = this.getSesameClient().createRDF4JProtocolSession(this.serverURL);
            httpClient.setUsernameAndPassword(this.username, this.password);
            try {
                httpClient.deleteRepository(repositoryID);
            }
            catch (IOException e) {
                this.logger.warn("error while deleting remote repository", (Throwable)e);
                throw new RepositoryConfigException(e);
            }
        }
        return existingRepo;
    }

    @Override
    protected void cleanUpRepository(String repositoryID) throws IOException {
    }
}

