/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.tsv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsTSVWriter
extends AbstractQueryResultWriter
implements TupleQueryResultWriter {
    private Writer writer;
    private List<String> bindingNames;
    protected boolean tupleVariablesFound = false;

    public SPARQLResultsTSVWriter(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(w, 1024);
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.tupleVariablesFound = true;
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write("?");
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    @Override
    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        this.writer.write("<" + uriString + ">");
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (XMLSchema.INTEGER.equals(datatype) || XMLSchema.DECIMAL.equals(datatype) || XMLSchema.DOUBLE.equals(datatype)) {
            try {
                this.writer.write(XMLDatatypeUtil.normalize(label, datatype));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String encoded = SPARQLResultsTSVWriter.encodeString(label);
        if (Literals.isLanguageLiteral(lit)) {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
            this.writer.write("@");
            this.writer.write(lit.getLanguage().get());
        } else if (!XMLSchema.STRING.equals(datatype) || !this.xsdStringToPlainLiteral()) {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
            this.writer.write("^^");
            this.writeURI(datatype);
        } else if (encoded.equals(label) && label.charAt(0) != '<' && label.charAt(0) != '_' && !label.matches("^[\\+\\-]?[\\d\\.].*")) {
            this.writer.write(encoded);
        } else {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
        }
    }

    private static String encodeString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub("\t", "\\t", s);
        s = StringUtil.gsub("\n", "\\n", s);
        s = StringUtil.gsub("\r", "\\r", s);
        s = StringUtil.gsub("\"", "\\\"", s);
        return s;
    }

    @Override
    public void startDocument() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws TupleQueryResultHandlerException {
    }

    @Override
    public void startHeader() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws TupleQueryResultHandlerException {
    }

    @Override
    public void endHeader() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

