/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.JoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ZeroLengthPathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeDistinctIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeHashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeIntersectIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeOrderIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizePathIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeSPARQLMinusIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeZeroLengthPathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.OrderComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;

public class LimitedSizeEvaluationStrategy
extends StrictEvaluationStrategy {
    private final AtomicLong used = new AtomicLong();
    private long maxSize;

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, long maxSize, FederatedServiceResolver serviceManager) {
        super(tripleSource, serviceManager);
        this.maxSize = maxSize;
    }

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, Dataset dataset, int maxCollectionsSize, FederatedServiceResolver serviceManager) {
        super(tripleSource, dataset, serviceManager);
        this.maxSize = maxCollectionsSize;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new LimitedSizeDistinctIteration(this.evaluate(distinct.getArg(), bindings), this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new LimitedSizeSPARQLMinusIteration((Iteration<BindingSet, QueryEvaluationException>)leftArg, (Iteration<BindingSet, QueryEvaluationException>)rightArg, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new LimitedSizeIntersectIteration((Iteration<? extends BindingSet, ? extends QueryEvaluationException>)leftArg, (Iteration<? extends BindingSet, ? extends QueryEvaluationException>)rightArg, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        if (join.getRightArg() instanceof Service) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(join.getLeftArg(), bindings);
            return new ServiceJoinIterator(leftIter, (Service)join.getRightArg(), bindings, this);
        }
        if (TupleExprs.containsSubquery(join.getRightArg())) {
            return new LimitedSizeHashJoinIteration((EvaluationStrategy)this, join, bindings, this.used, this.maxSize);
        }
        return new JoinIterator(this, join, bindings);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return new LimitedSizePathIterator(this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings, this.used, this.maxSize);
    }

    @Override
    protected ZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj) {
        return new LimitedSizeZeroLengthPathIteration(this, subjectVar, objVar, subj, obj, contextVar, bindings, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        boolean reduced = this.isReducedOrDistinct(node);
        long limit = this.getLimit(node);
        return new LimitedSizeOrderIteration(this.evaluate(node.getArg(), bindings), cmp, limit, reduced, this.used, this.maxSize);
    }
}

