/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import java.util.HashMap;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.DefaultSpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.DefaultWktWriter;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.WktWriter;

abstract class SpatialSupport {
    private static final SpatialContext spatialContext;
    private static final SpatialAlgebra spatialAlgebra;
    private static final WktWriter wktWriter;

    SpatialSupport() {
    }

    static SpatialContext getSpatialContext() {
        return spatialContext;
    }

    static SpatialAlgebra getSpatialAlgebra() {
        return spatialAlgebra;
    }

    static WktWriter getWktWriter() {
        return wktWriter;
    }

    protected abstract SpatialContext createSpatialContext();

    protected abstract SpatialAlgebra createSpatialAlgebra();

    protected abstract WktWriter createWktWriter();

    static {
        SpatialSupport support;
        try {
            Class<?> cls = Class.forName("org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupportInitializer", true, Thread.currentThread().getContextClassLoader());
            support = (SpatialSupport)cls.newInstance();
        }
        catch (Exception e) {
            support = new DefaultSpatialSupport();
        }
        spatialContext = support.createSpatialContext();
        spatialAlgebra = support.createSpatialAlgebra();
        wktWriter = support.createWktWriter();
    }

    private static final class DefaultSpatialSupport
    extends SpatialSupport {
        private static final String SYSTEM_PROPERTY_PREFIX = "spatialSupport.";

        private DefaultSpatialSupport() {
        }

        @Override
        protected SpatialContext createSpatialContext() {
            HashMap<String, String> args = new HashMap<String, String>();
            for (String key : System.getProperties().stringPropertyNames()) {
                if (!key.startsWith(SYSTEM_PROPERTY_PREFIX)) continue;
                args.put(key.substring(SYSTEM_PROPERTY_PREFIX.length()), System.getProperty(key));
            }
            return SpatialContextFactory.makeSpatialContext(args, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }

        @Override
        protected SpatialAlgebra createSpatialAlgebra() {
            return new DefaultSpatialAlgebra();
        }

        @Override
        protected WktWriter createWktWriter() {
            return new DefaultWktWriter();
        }
    }
}

