/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class ServiceJoinConversionIteration
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    protected final List<BindingSet> bindings;

    public ServiceJoinConversionIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, List<BindingSet> bindings) {
        super(iter);
        this.bindings = bindings;
    }

    @Override
    protected BindingSet convert(BindingSet bIn) throws QueryEvaluationException {
        QueryBindingSet res = new QueryBindingSet(bIn.size() + this.bindings.size());
        int bIndex = -1;
        for (Binding b : bIn) {
            String name = b.getName();
            if (name.equals("__rowIdx")) {
                bIndex = Integer.parseInt(b.getValue().stringValue());
                continue;
            }
            res.addBinding(b.getName(), b.getValue());
        }
        if (bIndex == -1) {
            throw new QueryEvaluationException("Invalid join. Probably this is due to non-standard behavior of the SPARQL endpoint. Please report to the developers.");
        }
        res.addAll(this.bindings.get(bIndex));
        return res;
    }
}

