/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelTreePrinter;

public abstract class AbstractQueryModelNode
implements QueryModelNode {
    private static final long serialVersionUID = 3006199552086476178L;
    private QueryModelNode parent;

    @Override
    public QueryModelNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        this.parent = parent;
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        throw new IllegalArgumentException("Node is not a child node: " + current);
    }

    @Override
    public void replaceWith(QueryModelNode replacement) {
        if (this.parent == null) {
            throw new IllegalStateException("Node has no parent");
        }
        this.parent.replaceChildNode(this, replacement);
    }

    @Override
    public String getSignature() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toString() {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        this.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    @Override
    public AbstractQueryModelNode clone() {
        try {
            return (AbstractQueryModelNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Query model nodes are required to be cloneable", e);
        }
    }

    protected <T extends QueryModelNode> boolean replaceNodeInList(List<T> list, QueryModelNode current, QueryModelNode replacement) {
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            if (iter.next() != current) continue;
            iter.set(replacement);
            replacement.setParentNode(this);
            return true;
        }
        return false;
    }

    protected boolean nullEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

