/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryListController
extends AbstractController {
    private static final String REPOSITORY_LIST_QUERY;
    private RepositoryManager repositoryManager;

    public RepositoryListController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD"});
    }

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if ("GET".equals(request.getMethod())) {
            Repository systemRepository = this.repositoryManager.getSystemRepository();
            ValueFactory vf = systemRepository.getValueFactory();
            try (RepositoryConnection con = systemRepository.getConnection();){
                ArrayList<String> bindingNames = new ArrayList<String>();
                ArrayList<QueryBindingSet> bindingSets = new ArrayList<QueryBindingSet>();
                try (TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SERQL, REPOSITORY_LIST_QUERY).evaluate();){
                    StringBuffer requestURL = request.getRequestURL();
                    if (requestURL.charAt(requestURL.length() - 1) != '/') {
                        requestURL.append('/');
                    }
                    String namespace = requestURL.toString();
                    while (queryResult.hasNext()) {
                        QueryBindingSet bindings = new QueryBindingSet((BindingSet)queryResult.next());
                        String id = bindings.getValue("id").stringValue();
                        bindings.addBinding("uri", vf.createIRI(namespace, id));
                        bindingSets.add(bindings);
                    }
                    bindingNames.add("uri");
                    bindingNames.addAll(queryResult.getBindingNames());
                }
                model.put("queryResult", new IteratingTupleQueryResult(bindingNames, bindingSets));
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
        }
        TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        model.put("filenameHint", "repositories");
        model.put("factory", factory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }

    static {
        StringBuilder query = new StringBuilder(256);
        query.append("SELECT id, title, \"true\"^^xsd:boolean as \"readable\", \"true\"^^xsd:boolean as \"writable\"");
        query.append("FROM {} rdf:type {sys:Repository};");
        query.append("        [rdfs:label {title}];");
        query.append("        sys:repositoryID {id} ");
        query.append("USING NAMESPACE sys = <http://www.openrdf.org/config/repository#>");
        REPOSITORY_LIST_QUERY = query.toString();
    }
}

