/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.logging.file.logback;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.eclipse.rdf4j.common.logging.LogLevel;
import org.eclipse.rdf4j.common.logging.LogRecord;
import org.eclipse.rdf4j.common.logging.base.AbstractLogReader;
import org.eclipse.rdf4j.common.logging.base.SimpleLogRecord;
import org.eclipse.rdf4j.common.logging.file.logback.StackTracePatternLayout;

public class FileLogReader
extends AbstractLogReader {
    private File logFile = null;
    private RandomAccessFile log = null;
    private long fileLength;
    private long byteOffset;
    private LogRecord next = null;
    private int count = 0;

    public FileLogReader() {
    }

    public FileLogReader(File logFile) {
        this.logFile = logFile;
    }

    @Override
    public void setAppender(Appender<?> appender) {
        super.setAppender(appender);
        if (!(appender instanceof FileAppender)) {
            throw new RuntimeException("FileLogReader appender must be an instance of FileAppender!");
        }
        this.logFile = new File(((FileAppender)appender).getFile());
        this.next = null;
    }

    @Override
    public void init() throws Exception {
        if (this.logFile == null) {
            throw new RuntimeException("Log file is undefined for this FileLogReader!");
        }
        if (this.log != null) {
            this.log.close();
        }
        this.log = new RandomAccessFile(this.logFile, "r");
        this.fileLength = this.log.length();
        this.byteOffset = this.fileLength - 1L;
        this.count = 0;
        this.next = this.getNext();
        if (this.getOffset() > 0) {
            this.doSkip(this.getOffset());
        }
    }

    private void doSkip(int offset) {
        while (this.hasNext() && this.count < offset) {
            this.next();
        }
    }

    @Override
    public boolean isMoreAvailable() {
        return this.next != null;
    }

    @Override
    public boolean hasNext() {
        if (this.getLimit() == 0) {
            return this.isMoreAvailable();
        }
        return this.isMoreAvailable() && this.count < this.getOffset() + this.getLimit();
    }

    @Override
    public LogRecord next() {
        LogRecord result = this.next;
        try {
            this.next = this.getNext();
            ++this.count;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get next log record.", ioe);
        }
        if (!this.hasNext()) {
            try {
                this.destroy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private LogRecord getNext() throws IOException {
        SimpleLogRecord result = null;
        StringBuilder message = new StringBuilder();
        AbstractList stackTrace = new LinkedList<String>();
        while (result == null && this.byteOffset > 0L) {
            byte currentByte;
            LinkedList<Byte> bytesRead = new LinkedList<Byte>();
            if (this.byteOffset < 0L) {
                System.err.println("Subzero byteOffset with: ");
                System.err.println("\tMessage: " + message);
                System.err.println("\tStacktrace: " + stackTrace.size());
            }
            do {
                this.log.seek(this.byteOffset--);
                currentByte = this.log.readByte();
                if (currentByte == 10 || currentByte == 13) continue;
                bytesRead.add(0, currentByte);
            } while (this.byteOffset > 0L && currentByte != 10 && currentByte != 13);
            if (this.byteOffset < 1L) {
                this.byteOffset = 0L;
                this.log.seek(0L);
            }
            byte[] lineBytes = new byte[bytesRead.size()];
            int index = 0;
            Iterator byteIt = bytesRead.iterator();
            while (byteIt.hasNext()) {
                lineBytes[index] = (Byte)byteIt.next();
                ++index;
            }
            String lastLine = new String(lineBytes, "UTF-8");
            if (lastLine == null) continue;
            Matcher matcher = StackTracePatternLayout.DEFAULT_PARSER_PATTERN.matcher(lastLine);
            if (matcher.matches()) {
                try {
                    LogLevel level = LogLevel.valueOf(matcher.group(1).trim());
                    Date timestamp = LogRecord.ISO8601_TIMESTAMP_FORMAT.parse(matcher.group(2).trim());
                    String threadName = matcher.group(3);
                    message.insert(0, matcher.group(4));
                    result = new SimpleLogRecord();
                    result.setLevel(level);
                    result.setTime(timestamp);
                    result.setThreadName(threadName);
                    result.setMessage(message.toString());
                    result.setStackTrace(stackTrace);
                    message = new StringBuilder();
                    stackTrace = new ArrayList();
                    continue;
                }
                catch (ParseException pe) {
                    throw new IOException("Unable to parse timestamp in log record");
                }
            }
            if (lastLine.trim().equals("")) continue;
            if (lastLine.startsWith("\t")) {
                stackTrace.add(0, lastLine.trim());
                continue;
            }
            message.insert(0, lastLine);
        }
        return result;
    }

    @Override
    public void destroy() throws IOException {
        if (this.log != null) {
            this.log.close();
        }
        this.log = null;
    }
}

