/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app;

import java.util.Locale;
import org.eclipse.rdf4j.common.lang.ObjectUtil;

public class AppVersion
implements Comparable<AppVersion> {
    private int major;
    private int minor;
    private int patch;
    private int milestone;
    private String modifier;

    public AppVersion() {
        this(-1, -1, -1, -1, null);
    }

    public AppVersion(int major, int minor) {
        this(major, minor, -1, -1, null);
    }

    public AppVersion(int major, int minor, int patch) {
        this(major, minor, patch, -1, null);
    }

    public AppVersion(int major, int minor, String modifier) {
        this(major, minor, -1, -1, modifier);
    }

    public AppVersion(int major, int minor, int patch, String modifier) {
        this(major, minor, patch, -1, modifier);
    }

    public AppVersion(int major, int minor, int patch, int milestone, String modifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.milestone = milestone;
        this.modifier = modifier;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int micro) {
        this.patch = micro;
    }

    public void setMilestone(int milestone) {
        this.milestone = milestone;
    }

    public int getMilestone() {
        return this.milestone;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof AppVersion) {
            AppVersion o = (AppVersion)other;
            boolean bl = isEqual = this.major == o.major && this.minor == o.minor && this.patch == o.patch && this.milestone == o.milestone;
            if (isEqual) {
                isEqual = this.modifier == o.modifier || this.modifier != null && this.modifier.equalsIgnoreCase(o.modifier);
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 31 * (31 * this.major + this.minor);
        if (this.patch > 0) {
            hash += this.patch;
        }
        if (this.milestone > 0) {
            hash += this.milestone;
        }
        if (this.modifier != null) {
            hash ^= this.modifier.toLowerCase(Locale.ENGLISH).hashCode();
        }
        return hash;
    }

    public boolean olderThan(AppVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean newerThan(AppVersion other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(AppVersion other) {
        int result = this.major - other.major;
        if (result == 0) {
            result = this.minor - other.minor;
        }
        if (result == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0 && (this.milestone > -1 || other.milestone > -1)) {
            if (this.milestone > -1) {
                result = other.milestone == -1 ? -1 : this.milestone - other.milestone;
            } else if (other.milestone > -1) {
                result = 1;
            }
        }
        if (result == 0 && !ObjectUtil.nullEquals(this.modifier, other.modifier)) {
            result = this.modifier == null ? 1 : (other.modifier == null ? -1 : this.modifier.compareToIgnoreCase(other.modifier));
        }
        return result;
    }

    public static AppVersion parse(String versionString) {
        if (versionString.equals("dev")) {
            return new AppVersion(-1, -1, "dev");
        }
        int minorSeparator = versionString.indexOf(46);
        int patchSeparator = versionString.indexOf(46, minorSeparator + 1);
        int milestoneSeparator = versionString.indexOf(77, Math.max(minorSeparator, patchSeparator));
        int modifierSeparator = versionString.indexOf(45, Math.max(minorSeparator, milestoneSeparator));
        if (minorSeparator == -1) {
            throw new NumberFormatException("Illegal version string: " + versionString);
        }
        boolean hasPatch = patchSeparator > -1;
        boolean hasMilestone = milestoneSeparator > -1;
        boolean hasModifier = modifierSeparator > -1;
        String major = versionString.substring(0, minorSeparator);
        String minor = null;
        String patch = null;
        String milestone = null;
        String modifier = null;
        if (hasModifier) {
            modifier = versionString.substring(modifierSeparator + 1);
        }
        if (hasMilestone) {
            milestone = hasModifier ? versionString.substring(milestoneSeparator + 1, modifierSeparator) : versionString.substring(milestoneSeparator + 1);
        }
        if (hasPatch) {
            patch = hasMilestone ? versionString.substring(patchSeparator + 1, milestoneSeparator) : (hasModifier ? versionString.substring(patchSeparator + 1, modifierSeparator) : versionString.substring(patchSeparator + 1));
            minor = versionString.substring(minorSeparator + 1, patchSeparator);
        } else {
            minor = hasMilestone ? versionString.substring(minorSeparator + 1, milestoneSeparator) : (hasModifier ? versionString.substring(minorSeparator + 1, modifierSeparator) : versionString.substring(minorSeparator + 1));
        }
        int majorInt = Integer.parseInt(major);
        int minorInt = Integer.parseInt(minor);
        int patchInt = patch == null ? -1 : Integer.parseInt(patch);
        int milestoneInt = milestone == null ? -1 : Integer.parseInt(milestone);
        return new AppVersion(majorInt, minorInt, patchInt, milestoneInt, modifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        if (this.major >= 0) {
            sb.append(this.major).append('.').append(this.minor);
        }
        if (this.patch >= 0) {
            sb.append('.').append(this.patch);
        }
        if (this.milestone >= 0) {
            sb.append('M').append(this.milestone);
        }
        if (this.modifier != null) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(this.modifier);
        }
        return sb.toString();
    }
}

