/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.binary.BinaryQueryResultConstants;
import org.eclipse.rdf4j.query.resultio.binary.QueryErrorType;

public class BinaryQueryResultWriter
extends AbstractQueryResultWriter
implements TupleQueryResultWriter {
    private DataOutputStream out;
    private CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
    private Map<String, Integer> namespaceTable = new HashMap<String, Integer>(32);
    private int nextNamespaceID;
    private BindingSet previousBindings;
    private List<String> bindingNames;
    private boolean documentStarted = false;
    protected boolean tupleVariablesFound = false;

    public BinaryQueryResultWriter(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.BINARY;
    }

    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    public void startDocument() throws TupleQueryResultHandlerException {
        this.documentStarted = true;
        try {
            this.out.write(BinaryQueryResultConstants.MAGIC_NUMBER);
            this.out.writeInt(4);
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.tupleVariablesFound = true;
        if (!this.documentStarted) {
            this.startDocument();
        }
        bindingNames = new ArrayList<String>(bindingNames);
        this.bindingNames = Collections.unmodifiableList(bindingNames);
        try {
            this.out.writeInt(this.bindingNames.size());
            for (String bindingName : this.bindingNames) {
                this.writeString(bindingName);
            }
            List<Value> nullTuple = Collections.nCopies(this.bindingNames.size(), null);
            this.previousBindings = new ListBindingSet(this.bindingNames, nullTuple);
            this.nextNamespaceID = 0;
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.out.writeByte(127);
            this.endDocument();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            if (bindingSet.size() == 0) {
                this.writeEmptyRow();
            } else {
                for (String bindingName : this.bindingNames) {
                    Value value = bindingSet.getValue(bindingName);
                    if (value == null) {
                        this.writeNull();
                        continue;
                    }
                    if (value.equals(this.previousBindings.getValue(bindingName))) {
                        this.writeRepeat();
                        continue;
                    }
                    if (value instanceof IRI) {
                        this.writeQName((IRI)value);
                        continue;
                    }
                    if (value instanceof BNode) {
                        this.writeBNode((BNode)value);
                        continue;
                    }
                    if (value instanceof Literal) {
                        this.writeLiteral((Literal)value);
                        continue;
                    }
                    throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
                }
                this.previousBindings = bindingSet;
            }
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    private void writeNull() throws IOException {
        this.out.writeByte(0);
    }

    private void writeRepeat() throws IOException {
        this.out.writeByte(1);
    }

    private void writeEmptyRow() throws IOException {
        this.out.writeByte(9);
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }

    private void writeQName(IRI uri) throws IOException {
        String namespace = uri.getNamespace();
        Integer nsID = this.namespaceTable.get(namespace);
        if (nsID == null) {
            nsID = this.writeNamespace(namespace);
        }
        this.out.writeByte(3);
        this.out.writeInt(nsID);
        this.writeString(uri.getLocalName());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.out.writeByte(5);
        this.writeString(bnode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        IRI datatype = literal.getDatatype();
        int marker = 6;
        if (Literals.isLanguageLiteral((Literal)literal)) {
            marker = 7;
        } else {
            String namespace = datatype.getNamespace();
            if (!this.namespaceTable.containsKey(namespace)) {
                this.writeNamespace(namespace);
            }
            marker = 8;
        }
        this.out.writeByte(marker);
        this.writeString(label);
        if (Literals.isLanguageLiteral((Literal)literal)) {
            this.writeString(literal.getLanguage());
        } else {
            this.writeQName(datatype);
        }
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        this.out.writeByte(126);
        if (errType == QueryErrorType.MALFORMED_QUERY_ERROR) {
            this.out.writeByte(1);
        } else {
            this.out.writeByte(2);
        }
        this.writeString(msg);
    }

    private Integer writeNamespace(String namespace) throws IOException {
        this.out.writeByte(2);
        this.out.writeInt(this.nextNamespaceID);
        this.writeString(namespace);
        Integer result = new Integer(this.nextNamespaceID);
        this.namespaceTable.put(namespace, result);
        ++this.nextNamespaceID;
        return result;
    }

    private void writeString(String s) throws IOException {
        ByteBuffer byteBuf = this.charsetEncoder.encode(CharBuffer.wrap(s));
        this.out.writeInt(byteBuf.remaining());
        this.out.write(byteBuf.array(), 0, byteBuf.remaining());
    }

    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    public void startHeader() throws QueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    public void endHeader() throws QueryResultHandlerException {
    }

    private void endDocument() throws IOException {
        this.out.flush();
        this.documentStarted = false;
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }
}

