/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.List;
import java.util.function.Function;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public final class IRTextPrinter
implements IrPrinter {
    private final StringBuilder out;
    private final Function<Var, String> varFormatter;
    private final TupleExprIRRenderer.Config cfg;
    private int level = 0;
    private boolean inlineActive = false;

    public IRTextPrinter(StringBuilder out, Function<Var, String> varFormatter, TupleExprIRRenderer.Config cfg) {
        this.out = out;
        this.varFormatter = varFormatter;
        this.cfg = cfg;
    }

    public void printWhere(IrBGP w) {
        if (w == null) {
            this.openBlock();
            this.closeBlock();
            return;
        }
        w.print(this);
    }

    @Override
    public void printLines(List<IrNode> lines) {
        if (lines == null) {
            return;
        }
        for (IrNode line : lines) {
            line.print(this);
        }
    }

    private void indent() {
        this.out.append(this.cfg.indent.repeat(Math.max(0, this.level)));
    }

    @Override
    public void startLine() {
        if (!this.inlineActive) {
            this.indent();
            this.inlineActive = true;
        }
    }

    @Override
    public void append(String s) {
        int len;
        if (!(this.inlineActive || (len = this.out.length()) != 0 && this.out.charAt(len - 1) != '\n')) {
            this.indent();
        }
        this.out.append(s);
    }

    @Override
    public void endLine() {
        this.out.append('\n');
        this.inlineActive = false;
    }

    @Override
    public void line(String s) {
        if (this.inlineActive) {
            this.out.append(s).append('\n');
            this.inlineActive = false;
            return;
        }
        this.indent();
        this.out.append(s).append('\n');
    }

    @Override
    public void openBlock() {
        if (!this.inlineActive) {
            this.indent();
        }
        this.out.append('{').append('\n');
        ++this.level;
        this.inlineActive = false;
    }

    @Override
    public void closeBlock() {
        --this.level;
        this.indent();
        this.out.append('}').append('\n');
    }

    @Override
    public void pushIndent() {
        ++this.level;
    }

    @Override
    public void popIndent() {
        --this.level;
    }

    @Override
    public String convertVarToString(Var v) {
        return this.varFormatter.apply(v);
    }
}

