/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.experimental;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Add;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Copy;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Like;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.Move;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedBooleanQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedConstructQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.sparql.experimental.SerializableParsedUpdate;

class ParsedQueryPreprocessor
extends AbstractQueryModelVisitor<RuntimeException> {
    public Map<Projection, SerializableParsedTupleQuery> queriesByProjection = new HashMap<Projection, SerializableParsedTupleQuery>();
    public Stack<SerializableParsedTupleQuery> queryProfilesStack = new Stack();
    public SerializableParsedTupleQuery currentQueryProfile = new SerializableParsedTupleQuery();
    public Slice currentSlice = null;
    public SerializableParsedTupleQuery.QueryModifier currentModifier = null;
    public MultiProjection graphQueryProjection = null;

    public SerializableParsedTupleQuery transformToSerialize(ParsedTupleQuery query) {
        query.getTupleExpr().visit((QueryModelVisitor)this);
        for (SerializableParsedTupleQuery tmp : this.queriesByProjection.values()) {
            this.cleanBindingSetAssignments(tmp);
        }
        this.currentQueryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        if (query.getDataset() != null) {
            this.currentQueryProfile.dataset = query.getDataset();
        }
        return this.currentQueryProfile;
    }

    public SerializableParsedConstructQuery transformToSerialize(ParsedGraphQuery query) {
        query.getTupleExpr().visit((QueryModelVisitor)this);
        for (SerializableParsedTupleQuery tmp : this.queriesByProjection.values()) {
            this.cleanBindingSetAssignments(tmp);
        }
        this.currentQueryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        SerializableParsedConstructQuery queryProfile = new SerializableParsedConstructQuery();
        queryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        queryProfile.whereClause = this.currentQueryProfile.whereClause;
        if (queryProfile.whereClause instanceof Extension) {
            queryProfile.whereClause = ((Extension)queryProfile.whereClause).getArg();
        }
        if (queryProfile.whereClause instanceof Slice) {
            queryProfile.whereClause = ((Slice)queryProfile.whereClause).getArg();
        }
        if (queryProfile.whereClause instanceof Order) {
            queryProfile.whereClause = ((Order)queryProfile.whereClause).getArg();
        }
        queryProfile.bindings = this.currentQueryProfile.bindings;
        queryProfile.limit = this.currentQueryProfile.limit;
        queryProfile.dataset = query.getDataset();
        queryProfile.orderBy = this.currentQueryProfile.orderBy;
        if (this.graphQueryProjection == null) {
            this.graphQueryProjection = new MultiProjection();
            this.graphQueryProjection.setProjections((Iterable)Lists.newArrayList((Object[])new ProjectionElemList[]{this.currentQueryProfile.projection.getProjectionElemList()}));
            this.graphQueryProjection.setArg(this.currentQueryProfile.projection.getArg());
        }
        queryProfile.projection = this.graphQueryProjection;
        queryProfile.extensionElements = this.currentQueryProfile.extensionElements;
        if (query instanceof ParsedDescribeQuery) {
            queryProfile.describe = true;
        }
        return queryProfile;
    }

    public SerializableParsedUpdate transformToSerialize(UpdateExpr update, Dataset dataset) {
        update.visit((QueryModelVisitor)this);
        for (SerializableParsedTupleQuery tmp : this.queriesByProjection.values()) {
            this.cleanBindingSetAssignments(tmp);
        }
        this.currentQueryProfile.dataset = dataset;
        this.currentQueryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        SerializableParsedUpdate queryProfile = new SerializableParsedUpdate();
        queryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        queryProfile.whereClause = this.currentQueryProfile.whereClause instanceof Extension ? ((Extension)this.currentQueryProfile.whereClause).getArg() : this.currentQueryProfile.whereClause;
        queryProfile.bindings = this.currentQueryProfile.bindings;
        queryProfile.limit = this.currentQueryProfile.limit;
        queryProfile.updateExpr = update;
        return queryProfile;
    }

    public SerializableParsedBooleanQuery transformToSerialize(ParsedBooleanQuery query) {
        if (!(query.getTupleExpr() instanceof Slice)) {
            throw new IllegalArgumentException("Unexpected boolean query: Slice expected as a root element, was " + query.getTupleExpr().getSignature());
        }
        Slice queryRoot = (Slice)query.getTupleExpr().clone();
        TupleExpr whereClause = queryRoot.getArg();
        Projection fakeProjection = new Projection(whereClause);
        whereClause.setParentNode((QueryModelNode)fakeProjection);
        queryRoot.setArg((TupleExpr)fakeProjection);
        fakeProjection.setParentNode((QueryModelNode)queryRoot);
        queryRoot.visit((QueryModelVisitor)this);
        for (SerializableParsedTupleQuery tmp : this.queriesByProjection.values()) {
            this.cleanBindingSetAssignments(tmp);
        }
        this.currentQueryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        SerializableParsedBooleanQuery queryProfile = new SerializableParsedBooleanQuery();
        queryProfile.projection = this.currentQueryProfile.projection;
        queryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        queryProfile.whereClause = this.currentQueryProfile.whereClause;
        queryProfile.bindings = this.currentQueryProfile.bindings;
        queryProfile.extensionElements = this.currentQueryProfile.extensionElements;
        queryProfile.dataset = query.getDataset();
        return queryProfile;
    }

    public SerializableParsedTupleQuery transformToSerialize(TupleExpr tupleExpr) {
        tupleExpr.visit((QueryModelVisitor)this);
        for (SerializableParsedTupleQuery query : this.queriesByProjection.values()) {
            this.cleanBindingSetAssignments(query);
        }
        this.cleanBindingSetAssignments(this.currentQueryProfile);
        this.currentQueryProfile.subQueriesByProjection.putAll(this.queriesByProjection);
        return this.currentQueryProfile;
    }

    protected void cleanBindingSetAssignments(SerializableParsedTupleQuery query) {
        if (query.bindings != null && query.whereClause != null && this.isAncestor((QueryModelNode)query.whereClause, (QueryModelNode)query.bindings)) {
            query.bindings = null;
        }
    }

    protected boolean isAncestor(QueryModelNode node1, QueryModelNode node2) {
        if (node2.getParentNode() == null) {
            return false;
        }
        if (node2.getParentNode().equals((Object)node1)) {
            return true;
        }
        return this.isAncestor(node1, node2.getParentNode());
    }

    public void meet(QueryRoot node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Add add) throws RuntimeException {
        super.meet(add);
    }

    public void meet(And node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getLeftArg());
        this.ensureNonAnonymousVar(node.getRightArg());
        super.meet(node);
    }

    public void meet(ArbitraryLengthPath node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(Avg node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(BindingSetAssignment node) throws RuntimeException {
        this.currentQueryProfile.bindings = node;
    }

    public void meet(BNodeGenerator node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Bound node) throws RuntimeException {
        this.ensureNonAnonymousVar((ValueExpr)node.getArg());
        super.meet(node);
    }

    public void meet(Clear clear) throws RuntimeException {
        super.meet(clear);
    }

    public void meet(Coalesce node) throws RuntimeException {
        node.getArguments().stream().forEach(arg -> this.ensureNonAnonymousVar((ValueExpr)arg));
        super.meet(node);
    }

    public void meet(Compare node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getLeftArg());
        this.ensureNonAnonymousVar(node.getRightArg());
        super.meet(node);
    }

    public void meet(CompareAll node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(CompareAny node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(Copy copy) throws RuntimeException {
        super.meet(copy);
    }

    public void meet(Count node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Create create) throws RuntimeException {
        super.meet(create);
    }

    public void meet(Datatype node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(DeleteData deleteData) throws RuntimeException {
        super.meet(deleteData);
    }

    public void meet(Difference node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(Distinct node) throws RuntimeException {
        this.currentModifier = SerializableParsedTupleQuery.QueryModifier.DISTINCT;
        super.meet(node);
    }

    public void meet(EmptySet node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Exists node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Extension node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(ExtensionElem node) throws RuntimeException {
        this.currentQueryProfile.extensionElements.put(node.getName(), node);
        super.meet(node);
    }

    public void meet(Filter node) throws RuntimeException {
        boolean maybeHaving = false;
        if (this.currentQueryProfile.groupBy == null) {
            maybeHaving = true;
        }
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
        if (maybeHaving && this.currentQueryProfile.groupBy != null) {
            this.currentQueryProfile.having = node;
        }
    }

    public void meet(FunctionCall node) throws RuntimeException {
        node.getArgs().stream().forEach(arg -> this.ensureNonAnonymousVar((ValueExpr)arg));
        super.meet(node);
    }

    public void meet(Group node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause != null) {
            this.currentQueryProfile.whereClause = null;
        }
        if (this.currentQueryProfile.groupBy == null) {
            this.currentQueryProfile.groupBy = node;
        }
        super.meet(node);
    }

    public void meet(GroupConcat node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(GroupElem node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(If node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getCondition());
        this.ensureNonAnonymousVar(node.getResult());
        this.ensureNonAnonymousVar(node.getAlternative());
        super.meet(node);
    }

    public void meet(In node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(InsertData insertData) throws RuntimeException {
        super.meet(insertData);
    }

    public void meet(Intersection node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(IRIFunction node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(IsBNode node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(IsLiteral node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(IsNumeric node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(IsResource node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(IsURI node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(Join node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(Label node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(Lang node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getArg());
        super.meet(node);
    }

    public void meet(LangMatches node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getLeftArg());
        this.ensureNonAnonymousVar(node.getRightArg());
        super.meet(node);
    }

    public void meet(LeftJoin node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(Like node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Load load) throws RuntimeException {
        super.meet(load);
    }

    public void meet(LocalName node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(MathExpr node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Max node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Min node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Modify modify) throws RuntimeException {
        this.currentQueryProfile.modifier = this.currentModifier;
        this.currentModifier = null;
        super.meet(modify);
    }

    public void meet(Move move) throws RuntimeException {
        super.meet(move);
    }

    public void meet(MultiProjection node) throws RuntimeException {
        this.graphQueryProjection = node;
        this.currentQueryProfile.modifier = this.currentModifier;
        this.currentModifier = null;
        Projection fakeProjection = new Projection();
        node.getProjections().stream().forEach(projList -> projList.getElements().stream().forEach(elem -> fakeProjection.getProjectionElemList().addElement(elem)));
        fakeProjection.setArg(node.getArg().clone());
        this.currentQueryProfile.projection = fakeProjection;
        this.queriesByProjection.put(fakeProjection, this.currentQueryProfile);
        super.meet(node);
    }

    public void meet(Namespace node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Not node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Or node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Order node) throws RuntimeException {
        if (this.currentQueryProfile.orderBy == null) {
            this.currentQueryProfile.orderBy = node;
        }
        super.meet(node);
    }

    public void meet(OrderElem node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Projection node) throws RuntimeException {
        boolean isSubquery = false;
        if (this.currentQueryProfile.whereClause != null || this.currentQueryProfile.projection != null) {
            isSubquery = true;
            if (this.currentQueryProfile.whereClause == null) {
                this.currentQueryProfile.whereClause = node;
            }
            this.queryProfilesStack.push(this.currentQueryProfile);
            this.currentQueryProfile = new SerializableParsedTupleQuery();
        }
        this.currentQueryProfile.modifier = this.currentModifier;
        this.currentModifier = null;
        this.currentQueryProfile.projection = node;
        this.queriesByProjection.put(node, this.currentQueryProfile);
        super.meet(node);
        if (isSubquery) {
            this.currentQueryProfile = this.queryProfilesStack.pop();
        }
    }

    public void meet(ProjectionElem node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(ProjectionElemList node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Reduced node) throws RuntimeException {
        this.currentModifier = SerializableParsedTupleQuery.QueryModifier.REDUCED;
        super.meet(node);
    }

    public void meet(Regex node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getLeftArg());
        this.ensureNonAnonymousVar(node.getRightArg());
        super.meet(node);
    }

    public void meet(SameTerm node) throws RuntimeException {
        this.ensureNonAnonymousVar(node.getLeftArg());
        this.ensureNonAnonymousVar(node.getRightArg());
        super.meet(node);
    }

    public void meet(Sample node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Service node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(SingletonSet node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Slice node) throws RuntimeException {
        this.currentSlice = node;
        this.currentQueryProfile.limit = node;
        super.meet(node);
    }

    public void meet(StatementPattern node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(Str node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Sum node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Union node) throws RuntimeException {
        if (this.currentQueryProfile.whereClause == null) {
            this.currentQueryProfile.whereClause = node;
        }
        super.meet(node);
    }

    public void meet(ValueConstant node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(Var node) throws RuntimeException {
        super.meet(node);
    }

    public void meet(ZeroLengthPath node) throws RuntimeException {
        super.meet(node);
    }

    protected void ensureNonAnonymousVar(ValueExpr valueExpr) {
        Var var;
        if (valueExpr instanceof Var && (var = (Var)valueExpr).isAnonymous() && !var.isConstant()) {
            this.currentQueryProfile.nonAnonymousVars.put(var.getName(), var);
        }
    }
}

