/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.serql;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.queryrender.BaseTupleExprRenderer;
import org.eclipse.rdf4j.queryrender.serql.SerqlValueExprRenderer;

class SerqlTupleExprRenderer
extends BaseTupleExprRenderer {
    private StringBuffer mBuffer = new StringBuffer();
    private StringBuffer mJoinBuffer = new StringBuffer();
    private ValueExpr mFilter;
    private final SerqlValueExprRenderer mValueExprRenderer = new SerqlValueExprRenderer();

    SerqlTupleExprRenderer() {
    }

    @Override
    public void reset() {
        super.reset();
        this.mFilter = null;
        this.mBuffer = new StringBuffer();
        this.mJoinBuffer = new StringBuffer();
    }

    @Override
    public String render(TupleExpr theExpr) throws Exception {
        theExpr.visit((QueryModelVisitor)this);
        if (this.mBuffer.length() > 0) {
            return this.mBuffer.toString();
        }
        boolean aFirst = true;
        StringBuilder aQuery = new StringBuilder();
        if (!this.mProjection.isEmpty()) {
            if (this.isSelect()) {
                aQuery.append("select ");
            } else {
                aQuery.append("construct ");
            }
            if (this.mDistinct) {
                aQuery.append("distinct ");
            }
            if (this.mReduced && this.isSelect()) {
                aQuery.append("reduced ");
            }
            aFirst = true;
            if (!this.isSelect()) {
                aQuery.append("\n");
            }
            for (ProjectionElemList aList : this.mProjection) {
                if (SerqlTupleExprRenderer.isSPOElemList(aList)) {
                    if (!aFirst) {
                        aQuery.append(",\n");
                    } else {
                        aFirst = false;
                    }
                    aQuery.append(this.renderPattern(this.toStatementPattern(aList)));
                    continue;
                }
                for (ProjectionElem aElem : aList.getElements()) {
                    if (!aFirst) {
                        aQuery.append(", ");
                    } else {
                        aFirst = false;
                    }
                    aQuery.append(this.mExtensions.containsKey(aElem.getSourceName()) ? this.mValueExprRenderer.render((ValueExpr)this.mExtensions.get(aElem.getSourceName())) : aElem.getSourceName());
                    if (aElem.getSourceName().equals(aElem.getTargetName()) && (!this.mExtensions.containsKey(aElem.getTargetName()) || this.mExtensions.containsKey(aElem.getSourceName()))) continue;
                    aQuery.append(" as ").append(this.mExtensions.containsKey(aElem.getTargetName()) ? this.mValueExprRenderer.render((ValueExpr)this.mExtensions.get(aElem.getTargetName())) : aElem.getTargetName());
                }
            }
            aQuery.append("\n");
        }
        if (this.mJoinBuffer.length() > 0) {
            this.mJoinBuffer.setCharAt(this.mJoinBuffer.lastIndexOf(","), ' ');
            aQuery.append("from\n");
            aQuery.append(this.mJoinBuffer);
        }
        if (this.mFilter != null) {
            aQuery.append("where\n");
            aQuery.append(this.mValueExprRenderer.render(this.mFilter));
        }
        if (!this.mOrdering.isEmpty()) {
            aQuery.append("\norder by ");
            aFirst = true;
            for (OrderElem aOrder : this.mOrdering) {
                if (!aFirst) {
                    aQuery.append(", ");
                } else {
                    aFirst = false;
                }
                aQuery.append(aOrder.getExpr());
                aQuery.append(" ");
                if (aOrder.isAscending()) {
                    aQuery.append("asc");
                    continue;
                }
                aQuery.append("desc");
            }
        }
        if (this.mLimit != -1L) {
            aQuery.append("\nlimit ").append(this.mLimit);
        }
        if (this.mOffset != -1L) {
            aQuery.append("\noffset ").append(this.mOffset);
        }
        return aQuery.toString();
    }

    private String renderTupleExpr(TupleExpr theExpr) throws Exception {
        SerqlTupleExprRenderer aRenderer = new SerqlTupleExprRenderer();
        aRenderer.mProjection = new ArrayList(this.mProjection);
        aRenderer.mDistinct = this.mDistinct;
        aRenderer.mReduced = this.mReduced;
        aRenderer.mExtensions = new HashMap(this.mExtensions);
        aRenderer.mOrdering = new ArrayList(this.mOrdering);
        aRenderer.mLimit = this.mLimit;
        aRenderer.mOffset = this.mOffset;
        return aRenderer.render(theExpr);
    }

    public void meet(Union theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mBuffer.append(aLeft).append("\nunion\n").append(aRight);
    }

    public void meet(Difference theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mBuffer.append(aLeft).append("\nminus\n").append(aRight);
    }

    public void meet(Intersection theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mBuffer.append(aLeft).append("\nintersection\n").append(aRight);
    }

    private String renderPattern(StatementPattern thePattern) throws Exception {
        return "{" + this.renderValueExpr((ValueExpr)thePattern.getSubjectVar()) + "} " + this.renderValueExpr((ValueExpr)thePattern.getPredicateVar()) + " {" + this.renderValueExpr((ValueExpr)thePattern.getObjectVar()) + "} ";
    }

    @Override
    protected String renderValueExpr(ValueExpr theExpr) throws Exception {
        return this.mValueExprRenderer.render(theExpr);
    }

    public void meet(Join theJoin) throws Exception {
        theJoin.getLeftArg().visit((QueryModelVisitor)this);
        theJoin.getRightArg().visit((QueryModelVisitor)this);
    }

    public void meet(LeftJoin theJoin) throws Exception {
        theJoin.getLeftArg().visit((QueryModelVisitor)this);
        this.mJoinBuffer.append(" [");
        theJoin.getRightArg().visit((QueryModelVisitor)this);
        if (theJoin.getCondition() != null) {
            this.mJoinBuffer.append(this.renderValueExpr(theJoin.getCondition()));
        }
        this.mJoinBuffer.setCharAt(this.mJoinBuffer.lastIndexOf(","), ' ');
        this.mJoinBuffer.append("], ");
    }

    @Override
    public void meet(StatementPattern thePattern) throws Exception {
        this.mJoinBuffer.append(this.renderPattern(thePattern)).append(",\n");
    }

    public void meet(Filter theFilter) throws Exception {
        this.mFilter = this.mFilter == null ? theFilter.getCondition() : new And(this.mFilter, theFilter.getCondition());
        theFilter.visitChildren((QueryModelVisitor)this);
    }
}

