/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.QueryRenderer;
import org.eclipse.rdf4j.queryrender.sparql.SparqlTupleExprRenderer;

public class SPARQLQueryRenderer
implements QueryRenderer {
    private SparqlTupleExprRenderer mRenderer = new SparqlTupleExprRenderer();

    @Override
    public QueryLanguage getLanguage() {
        return QueryLanguage.SPARQL;
    }

    @Override
    public String render(ParsedQuery theQuery) throws Exception {
        this.mRenderer.reset();
        StringBuffer aBody = new StringBuffer(this.mRenderer.render(theQuery.getTupleExpr()));
        boolean aFirst = true;
        StringBuffer aQuery = new StringBuffer();
        if (theQuery instanceof ParsedTupleQuery) {
            aQuery.append("select ");
        } else if (theQuery instanceof ParsedBooleanQuery) {
            aQuery.append("ask\n");
        } else {
            aQuery.append("construct ");
        }
        if (this.mRenderer.isDistinct()) {
            aQuery.append("distinct ");
        }
        if (this.mRenderer.isReduced() && theQuery instanceof ParsedTupleQuery) {
            aQuery.append("reduced ");
        }
        if (!this.mRenderer.getProjection().isEmpty() && !(theQuery instanceof ParsedBooleanQuery)) {
            aFirst = true;
            if (!(theQuery instanceof ParsedTupleQuery)) {
                aQuery.append(" {\n");
            }
            for (ProjectionElemList aList : this.mRenderer.getProjection()) {
                if (SparqlTupleExprRenderer.isSPOElemList(aList)) {
                    if (!aFirst) {
                        aQuery.append("\n");
                    } else {
                        aFirst = false;
                    }
                    aQuery.append("  ").append(this.mRenderer.renderPattern(this.mRenderer.toStatementPattern(aList)));
                    continue;
                }
                for (ProjectionElem aElem : aList.getElements()) {
                    if (!aFirst) {
                        aQuery.append(" ");
                    } else {
                        aFirst = false;
                    }
                    aQuery.append("?" + aElem.getSourceName());
                }
            }
            if (!(theQuery instanceof ParsedTupleQuery)) {
                aQuery.append("}");
            }
            aQuery.append("\n");
        } else if (this.mRenderer.getProjection().isEmpty()) {
            if (theQuery instanceof ParsedGraphQuery) {
                aQuery.append("{ }\n");
            } else if (theQuery instanceof ParsedTupleQuery) {
                aQuery.append("*\n");
            }
        }
        if (theQuery.getDataset() != null) {
            for (IRI aURI : theQuery.getDataset().getDefaultGraphs()) {
                aQuery.append("from <").append(aURI).append(">\n");
            }
            for (IRI aURI : theQuery.getDataset().getNamedGraphs()) {
                aQuery.append("from named <").append(aURI).append(">\n");
            }
        }
        if (aBody.length() > 0) {
            if (aBody.toString().trim().lastIndexOf(",") == aBody.length() - 1) {
                aBody.setCharAt(aBody.lastIndexOf(","), ' ');
            }
            if (!(theQuery instanceof ParsedBooleanQuery)) {
                aQuery.append("where ");
            }
            aQuery.append("{\n");
            aQuery.append(aBody);
            aQuery.append("}");
        }
        if (!this.mRenderer.getOrdering().isEmpty()) {
            aQuery.append("\norder by ");
            aFirst = true;
            for (OrderElem aOrder : this.mRenderer.getOrdering()) {
                if (!aFirst) {
                    aQuery.append(" ");
                } else {
                    aFirst = false;
                }
                if (aOrder.isAscending()) {
                    aQuery.append(this.mRenderer.renderValueExpr(aOrder.getExpr()));
                    continue;
                }
                aQuery.append("desc(");
                aQuery.append(this.mRenderer.renderValueExpr(aOrder.getExpr()));
                aQuery.append(")");
            }
        }
        if (this.mRenderer.getLimit() != -1L && !(theQuery instanceof ParsedBooleanQuery)) {
            aQuery.append("\nlimit ").append(this.mRenderer.getLimit());
        }
        if (this.mRenderer.getOffset() != -1L) {
            aQuery.append("\noffset ").append(this.mRenderer.getOffset());
        }
        return aQuery.toString();
    }
}

