/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.AbstractIRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;

@InternalUseOnly
class CoreDatatypeHelper {
    private static Map<IRI, CoreDatatype> reverseLookup;

    CoreDatatypeHelper() {
    }

    static Map<IRI, CoreDatatype> getReverseLookup() {
        if (reverseLookup == null) {
            HashMap<IRI, Enum> map = new HashMap<IRI, Enum>();
            for (CoreDatatype.RDF rDF : CoreDatatype.RDF.values()) {
                map.put(rDF.getIri(), rDF);
            }
            for (Enum enum_ : CoreDatatype.GEO.values()) {
                map.put(enum_.getIri(), enum_);
            }
            for (Enum enum_ : CoreDatatype.XSD.values()) {
                map.put(enum_.getIri(), enum_);
            }
            reverseLookup = Collections.unmodifiableMap(map);
        }
        return reverseLookup;
    }

    static class DatatypeIRI
    extends AbstractIRI {
        private static final long serialVersionUID = 169243624049169159L;
        private final String namespace;
        private final String localName;
        private final String stringValue;

        public DatatypeIRI(String namespace, String localName) {
            this.namespace = namespace;
            this.localName = localName;
            this.stringValue = namespace.concat(localName).intern();
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public String toString() {
            return this.stringValue;
        }
    }
}

