/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.ComponentTemporalAmount;
import org.eclipse.rdf4j.model.base.CoreDatatype;

public abstract class AbstractLiteral
implements Literal {
    private static final long serialVersionUID = -1286527360744086451L;

    static boolean reserved(IRI datatype) {
        return CoreDatatype.RDF.LANGSTRING.getIri().equals(datatype);
    }

    static boolean reserved(CoreDatatype datatype) {
        return CoreDatatype.RDF.LANGSTRING == datatype;
    }

    private <V> V value(Function<String, V> mapper) {
        return Optional.of(this.getLabel()).map(Objects.requireNonNull(mapper, "null mapper")).orElseThrow(() -> new IllegalArgumentException("malformed value"));
    }

    @Override
    public String stringValue() {
        return this.getLabel();
    }

    @Override
    public boolean booleanValue() {
        return this.value(BooleanLiteral::parseBoolean);
    }

    @Override
    public byte byteValue() {
        return this.value(Byte::parseByte);
    }

    @Override
    public short shortValue() {
        return this.value(Short::parseShort);
    }

    @Override
    public int intValue() {
        return this.value(Integer::parseInt);
    }

    @Override
    public long longValue() {
        return this.value(Long::parseLong);
    }

    @Override
    public float floatValue() {
        return this.value(NumberLiteral::parseFloat).floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value(NumberLiteral::parseDouble);
    }

    @Override
    public BigInteger integerValue() {
        return this.value(BigInteger::new);
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value(BigDecimal::new);
    }

    @Override
    public TemporalAccessor temporalAccessorValue() throws DateTimeException {
        return this.value(TemporalAccessorLiteral::parseTemporalAccessor);
    }

    @Override
    public TemporalAmount temporalAmountValue() throws DateTimeException {
        return this.value(TemporalAmountLiteral::parseTemporalAmount);
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return this.value(x$0 -> CalendarLiteral.parseCalendar(x$0));
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Literal && this.getLabel().equals(((Literal)o).getLabel()) && this.getDatatype().equals(((Literal)o).getDatatype()) && this.equals(this.getLanguage(), ((Literal)o).getLanguage());
    }

    @Override
    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        String label = "\"" + this.getLabel() + "\"";
        return this.getLanguage().map(language -> label + "@" + language).orElseGet(() -> {
            IRI datatype = this.getDatatype();
            return datatype.equals(CoreDatatype.XSD.STRING) ? label : label + "^^<" + datatype.stringValue() + ">";
        });
    }

    private boolean equals(Optional<String> x, Optional<String> y) {
        boolean px = x.isPresent();
        boolean py = y.isPresent();
        return px && py && x.get().equalsIgnoreCase(y.get()) || !px && !py;
    }

    static class CalendarLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = 9131700079460615839L;
        private static final ThreadLocal<DatatypeFactory> DATATYPE_FACTORY = ThreadLocal.withInitial(() -> {
            try {
                return DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException("unable to create datatype factory", e);
            }
        });
        private static final Map<QName, CoreDatatype.XSD> DATATYPES = CalendarLiteral.datatypes();
        private final XMLGregorianCalendar value;
        private final String label;
        private final CoreDatatype.XSD datatype;

        private static Map<QName, CoreDatatype.XSD> datatypes() {
            HashMap<QName, CoreDatatype.XSD> datatypes = new HashMap<QName, CoreDatatype.XSD>();
            datatypes.put(DatatypeConstants.DATETIME, CoreDatatype.XSD.DATETIME);
            datatypes.put(DatatypeConstants.TIME, CoreDatatype.XSD.TIME);
            datatypes.put(DatatypeConstants.DATE, CoreDatatype.XSD.DATE);
            datatypes.put(DatatypeConstants.GYEARMONTH, CoreDatatype.XSD.GYEARMONTH);
            datatypes.put(DatatypeConstants.GYEAR, CoreDatatype.XSD.GYEAR);
            datatypes.put(DatatypeConstants.GMONTHDAY, CoreDatatype.XSD.GMONTHDAY);
            datatypes.put(DatatypeConstants.GDAY, CoreDatatype.XSD.GDAY);
            datatypes.put(DatatypeConstants.GMONTH, CoreDatatype.XSD.GMONTH);
            datatypes.put(DatatypeConstants.DURATION, CoreDatatype.XSD.DURATION);
            datatypes.put(DatatypeConstants.DURATION_DAYTIME, CoreDatatype.XSD.DAYTIMEDURATION);
            datatypes.put(DatatypeConstants.DURATION_YEARMONTH, CoreDatatype.XSD.YEARMONTHDURATION);
            return datatypes;
        }

        private static XMLGregorianCalendar parseCalendar(String label) {
            return DATATYPE_FACTORY.get().newXMLGregorianCalendar(label);
        }

        CalendarLiteral(GregorianCalendar calendar) {
            this(DATATYPE_FACTORY.get().newXMLGregorianCalendar(calendar));
        }

        CalendarLiteral(XMLGregorianCalendar calendar) {
            this.value = calendar;
            this.label = calendar.toXMLFormat();
            QName qname = calendar.getXMLSchemaType();
            this.datatype = DATATYPES.get(qname);
            if (this.datatype == null) {
                throw new IllegalArgumentException(String.format("QName <%s> cannot be mapped to an XML Schema date/time datatype", qname));
            }
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype.getIri();
        }

        @Override
        public XMLGregorianCalendar calendarValue() {
            return this.value;
        }

        @Override
        public CoreDatatype getCoreDatatype() {
            return this.datatype;
        }
    }

    static class TemporalAmountLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -447302801371093467L;
        private static final Collection<ChronoUnit> UNITS = EnumSet.of(ChronoUnit.YEARS, new ChronoUnit[]{ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.NANOS});
        private static final Pattern PATTERN = Pattern.compile("(?<sign>-)?P(?:(?<" + ChronoUnit.YEARS + ">\\d+)Y)?(?:(?<" + ChronoUnit.MONTHS + ">\\d+)M)?(?:(?<" + ChronoUnit.DAYS + ">\\d+)D)?(?<time>T)?(?:(?<" + ChronoUnit.HOURS + ">\\d+)H)?(?:(?<" + ChronoUnit.MINUTES + ">\\d+)M)?(?:(?<" + ChronoUnit.SECONDS + ">\\d+)(?:\\.(?<" + ChronoUnit.NANOS + ">\\d+))?S)?");
        private final TemporalAmount value;
        private final String label;

        TemporalAmountLiteral(TemporalAmount value) {
            List<TemporalUnit> units = value.getUnits();
            if (units.isEmpty() || !UNITS.containsAll(units)) {
                throw new IllegalArgumentException(String.format("value <%s> cannot be represented by an XML Schema duration datatype", value));
            }
            this.value = value;
            this.label = TemporalAmountLiteral.toString(value);
        }

        static TemporalAmount parseTemporalAmount(CharSequence label) {
            EnumMap<ChronoUnit, Long> components;
            block8: {
                block7: {
                    Matcher matcher = PATTERN.matcher(label);
                    if (!matcher.matches()) {
                        throw new DateTimeException(String.format("label <%s> is not a valid lexical representation of an XML Schema duration datatype", label));
                    }
                    boolean sign = matcher.group("sign") != null;
                    boolean time = matcher.group("time") != null;
                    components = new EnumMap<ChronoUnit, Long>(ChronoUnit.class);
                    for (ChronoUnit unit : UNITS) {
                        String group = matcher.group(unit.toString());
                        if (group == null) continue;
                        try {
                            long value = Long.parseUnsignedLong(unit == ChronoUnit.NANOS ? (group + "000000000").substring(0, 9) : group);
                            components.put(unit, sign ? -value : value);
                        }
                        catch (NumberFormatException e) {
                            throw new DateTimeParseException(e.getMessage(), group, matcher.start(unit.toString()));
                        }
                    }
                    if (components.isEmpty()) break block7;
                    if (!time) break block8;
                    if (!Stream.of(ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS).noneMatch(components::containsKey)) break block8;
                }
                throw new DateTimeException(String.format("label <%s> is not a valid lexical representation of an XML Schema duration datatype", label));
            }
            return new ComponentTemporalAmount(components);
        }

        private static String toString(TemporalAmount value) {
            boolean negative;
            List<TemporalUnit> units = value.getUnits();
            long years = units.contains(ChronoUnit.YEARS) ? value.get(ChronoUnit.YEARS) : 0L;
            long months = units.contains(ChronoUnit.MONTHS) ? value.get(ChronoUnit.MONTHS) : 0L;
            long days = units.contains(ChronoUnit.DAYS) ? value.get(ChronoUnit.DAYS) : 0L;
            long hours = units.contains(ChronoUnit.HOURS) ? value.get(ChronoUnit.HOURS) : 0L;
            long minutes = units.contains(ChronoUnit.MINUTES) ? value.get(ChronoUnit.MINUTES) : 0L;
            long seconds = units.contains(ChronoUnit.SECONDS) ? value.get(ChronoUnit.SECONDS) : 0L;
            long nanos = units.contains(ChronoUnit.NANOS) ? value.get(ChronoUnit.NANOS) : 0L;
            boolean positive = years > 0L || months > 0L || days > 0L || hours > 0L || minutes > 0L || seconds > 0L || nanos > 0L;
            boolean bl = negative = years < 0L || months < 0L || days < 0L || hours < 0L || minutes < 0L || seconds < 0L || nanos < 0L;
            if (positive && negative) {
                throw new IllegalArgumentException(String.format("value <%s> cannot be represented by an XML Schema duration datatype", value));
            }
            StringBuilder builder = new StringBuilder(3 * value.getUnits().size());
            if (negative) {
                builder.append('-');
            }
            builder.append("P");
            if (years != 0L) {
                builder.append(Math.abs(years)).append("Y");
            }
            if (months != 0L) {
                builder.append(Math.abs(months)).append("M");
            }
            if (days != 0L) {
                builder.append(Math.abs(days)).append("D");
            }
            if (hours != 0L || minutes != 0L || seconds != 0L || nanos != 0L) {
                builder.append("T");
            }
            if (hours != 0L) {
                builder.append(Math.abs(hours)).append("H");
            }
            if (minutes != 0L) {
                builder.append(Math.abs(minutes)).append("M");
            }
            if (nanos != 0L) {
                builder.append(Math.abs(seconds) + Math.abs(nanos) / 1000000000L).append('.').append(String.format("%09d", Math.abs(nanos) % 1000000000L)).append("S");
            } else if (seconds != 0L) {
                builder.append(Math.abs(seconds)).append("S");
            }
            return builder.toString();
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return CoreDatatype.XSD.DURATION.getIri();
        }

        @Override
        public TemporalAmount temporalAmountValue() throws DateTimeException {
            return this.value;
        }

        @Override
        public CoreDatatype.XSD getCoreDatatype() {
            return CoreDatatype.XSD.DURATION;
        }
    }

    static class TemporalAccessorLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -6089251668767105663L;
        private static final ChronoField[] FIELDS = new ChronoField[]{ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.NANO_OF_SECOND, ChronoField.OFFSET_SECONDS};
        private static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter();
        private static final DateTimeFormatter OFFSET_TIME_FORMATTER = new DateTimeFormatterBuilder().append(LOCAL_TIME_FORMATTER).optionalStart().appendOffsetId().toFormatter();
        private static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
        private static final DateTimeFormatter OFFSET_DATE_FORMATTER = new DateTimeFormatterBuilder().append(LOCAL_DATE_FORMATTER).optionalStart().appendOffsetId().toFormatter();
        private static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().append(LOCAL_DATE_FORMATTER).optionalStart().appendLiteral('T').append(LOCAL_TIME_FORMATTER).optionalEnd().optionalStart().appendOffsetId().toFormatter();
        private static final DateTimeFormatter DASH_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("--").optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalEnd().optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
        private static final Map<Integer, CoreDatatype.XSD> DATATYPES = TemporalAccessorLiteral.datatypes();
        private static final Map<CoreDatatype.XSD, DateTimeFormatter> FORMATTERS = TemporalAccessorLiteral.formatters();
        private final TemporalAccessor value;
        private final String label;
        private final CoreDatatype.XSD datatype;

        static TemporalAccessor parseTemporalAccessor(String label) throws DateTimeException {
            TemporalAccessor value = TemporalAccessorLiteral.formatter(label).parse(label);
            if (!DATATYPES.containsKey(TemporalAccessorLiteral.key(value))) {
                throw new DateTimeException(String.format("label <%s> is not a valid lexical representation of an XML Schema date/time datatype", label));
            }
            return value;
        }

        private static Map<Integer, CoreDatatype.XSD> datatypes() {
            int date = TemporalAccessorLiteral.key(ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH);
            int time = TemporalAccessorLiteral.key(ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE);
            int nano = TemporalAccessorLiteral.key(ChronoField.NANO_OF_SECOND);
            int zone = TemporalAccessorLiteral.key(ChronoField.OFFSET_SECONDS);
            HashMap<Integer, CoreDatatype.XSD> datatypes = new HashMap<Integer, CoreDatatype.XSD>();
            datatypes.put(date + time, CoreDatatype.XSD.DATETIME);
            datatypes.put(date + time + nano, CoreDatatype.XSD.DATETIME);
            datatypes.put(date + time + zone, CoreDatatype.XSD.DATETIME);
            datatypes.put(date + time + nano + zone, CoreDatatype.XSD.DATETIME);
            datatypes.put(time, CoreDatatype.XSD.TIME);
            datatypes.put(time + nano, CoreDatatype.XSD.TIME);
            datatypes.put(time + zone, CoreDatatype.XSD.TIME);
            datatypes.put(time + nano + zone, CoreDatatype.XSD.TIME);
            datatypes.put(date, CoreDatatype.XSD.DATE);
            datatypes.put(date + zone, CoreDatatype.XSD.DATE);
            datatypes.put(TemporalAccessorLiteral.key(ChronoField.YEAR, ChronoField.MONTH_OF_YEAR), CoreDatatype.XSD.GYEARMONTH);
            datatypes.put(TemporalAccessorLiteral.key(ChronoField.YEAR), CoreDatatype.XSD.GYEAR);
            datatypes.put(TemporalAccessorLiteral.key(ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH), CoreDatatype.XSD.GMONTHDAY);
            datatypes.put(TemporalAccessorLiteral.key(ChronoField.DAY_OF_MONTH), CoreDatatype.XSD.GDAY);
            datatypes.put(TemporalAccessorLiteral.key(ChronoField.MONTH_OF_YEAR), CoreDatatype.XSD.GMONTH);
            return datatypes;
        }

        private static Map<CoreDatatype.XSD, DateTimeFormatter> formatters() {
            EnumMap<CoreDatatype.XSD, DateTimeFormatter> formatters = new EnumMap<CoreDatatype.XSD, DateTimeFormatter>(CoreDatatype.XSD.class);
            formatters.put(CoreDatatype.XSD.DATETIME, DATETIME_FORMATTER);
            formatters.put(CoreDatatype.XSD.TIME, OFFSET_TIME_FORMATTER);
            formatters.put(CoreDatatype.XSD.DATE, OFFSET_DATE_FORMATTER);
            formatters.put(CoreDatatype.XSD.GYEARMONTH, LOCAL_DATE_FORMATTER);
            formatters.put(CoreDatatype.XSD.GYEAR, LOCAL_DATE_FORMATTER);
            formatters.put(CoreDatatype.XSD.GMONTHDAY, DASH_FORMATTER);
            formatters.put(CoreDatatype.XSD.GDAY, DASH_FORMATTER);
            formatters.put(CoreDatatype.XSD.GMONTH, DASH_FORMATTER);
            return formatters;
        }

        private static DateTimeFormatter formatter(String label) {
            if (label.startsWith("--")) {
                return DASH_FORMATTER;
            }
            if (label.length() >= 8 && label.charAt(2) == ':') {
                return OFFSET_TIME_FORMATTER;
            }
            return DATETIME_FORMATTER;
        }

        private static int key(TemporalAccessor value) {
            return TemporalAccessorLiteral.key(value::isSupported, FIELDS);
        }

        private static int key(ChronoField ... fields) {
            return TemporalAccessorLiteral.key((ChronoField field) -> true, fields);
        }

        private static int key(Predicate<ChronoField> include, ChronoField ... fields) {
            int index = 0;
            for (ChronoField field : fields) {
                if (!include.test(field)) continue;
                index += 1 << field.ordinal() + 1;
            }
            return index;
        }

        TemporalAccessorLiteral(TemporalAccessor value) {
            this.value = value;
            this.datatype = DATATYPES.get(TemporalAccessorLiteral.key(value));
            if (this.datatype == null) {
                throw new IllegalArgumentException(String.format("value <%s> cannot be represented by an XML Schema date/time datatype", value));
            }
            this.label = FORMATTERS.get(this.datatype).format(value);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype.getIri();
        }

        @Override
        public TemporalAccessor temporalAccessorValue() {
            return this.value;
        }

        @Override
        public CoreDatatype getCoreDatatype() {
            return this.datatype;
        }
    }

    static class DecimalLiteral
    extends NumberLiteral {
        private static final long serialVersionUID = -4382147098035463886L;

        DecimalLiteral(BigDecimal value) {
            super(value, value.toPlainString(), CoreDatatype.XSD.DECIMAL);
        }

        @Override
        public BigInteger integerValue() {
            return ((BigDecimal)this.value).toBigInteger();
        }

        @Override
        public BigDecimal decimalValue() {
            return (BigDecimal)this.value;
        }
    }

    static class IntegerLiteral
    extends NumberLiteral {
        private static final long serialVersionUID = -4274941248972496665L;

        IntegerLiteral(BigInteger value) {
            super(value, value.toString(), CoreDatatype.XSD.INTEGER);
        }

        @Override
        public BigInteger integerValue() {
            return (BigInteger)this.value;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal((BigInteger)this.value);
        }
    }

    static class NumberLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -3201912818064851702L;
        private static final String POSITIVE_INFINITY = "INF";
        private static final String NEGATIVE_INFINITY = "-INF";
        private static final String NAN = "NaN";
        protected Number value;
        private final String label;
        private final CoreDatatype.XSD datatype;

        static float parseFloat(String label) {
            return label.equals(POSITIVE_INFINITY) ? Float.POSITIVE_INFINITY : (label.equals(NEGATIVE_INFINITY) ? Float.NEGATIVE_INFINITY : (label.equals(NAN) ? Float.NaN : Float.parseFloat(label)));
        }

        static double parseDouble(String label) {
            return label.equals(POSITIVE_INFINITY) ? Double.POSITIVE_INFINITY : (label.equals(NEGATIVE_INFINITY) ? Double.NEGATIVE_INFINITY : (label.equals(NAN) ? Double.NaN : Double.parseDouble(label)));
        }

        private static String toString(float value) {
            return value == Float.POSITIVE_INFINITY ? POSITIVE_INFINITY : (value == Float.NEGATIVE_INFINITY ? NEGATIVE_INFINITY : (Float.isNaN(value) ? NAN : Float.toString(value)));
        }

        private static String toString(double value) {
            return value == Double.POSITIVE_INFINITY ? POSITIVE_INFINITY : (value == Double.NEGATIVE_INFINITY ? NEGATIVE_INFINITY : (Double.isNaN(value) ? NAN : Double.toString(value)));
        }

        NumberLiteral(byte value) {
            this(value, Byte.toString(value), CoreDatatype.XSD.BYTE);
        }

        NumberLiteral(short value) {
            this(value, Short.toString(value), CoreDatatype.XSD.SHORT);
        }

        NumberLiteral(int value) {
            this(value, Integer.toString(value), CoreDatatype.XSD.INT);
        }

        NumberLiteral(long value) {
            this(value, Long.toString(value), CoreDatatype.XSD.LONG);
        }

        NumberLiteral(float value) {
            this(Float.valueOf(value), NumberLiteral.toString(value), CoreDatatype.XSD.FLOAT);
        }

        NumberLiteral(double value) {
            this(value, NumberLiteral.toString(value), CoreDatatype.XSD.DOUBLE);
        }

        NumberLiteral(Number value, String label, CoreDatatype.XSD datatype) {
            this.value = value;
            this.label = label;
            this.datatype = datatype;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype.getIri();
        }

        @Override
        public byte byteValue() {
            return this.value.byteValue();
        }

        @Override
        public short shortValue() {
            return this.value.shortValue();
        }

        @Override
        public int intValue() {
            return this.value.intValue();
        }

        @Override
        public long longValue() {
            return this.value.longValue();
        }

        @Override
        public float floatValue() {
            return this.value.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.value.doubleValue();
        }

        @Override
        public CoreDatatype getCoreDatatype() {
            return this.datatype;
        }
    }

    static class BooleanLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -1162147873619834622L;
        private final boolean value;

        static Boolean parseBoolean(String label) {
            return Optional.of(label).map(String::trim).map(normalized -> normalized.equals("true") || normalized.equals("1") ? Boolean.TRUE : (normalized.equals("false") || normalized.equals("0") ? Boolean.FALSE : null)).orElse(null);
        }

        BooleanLiteral(boolean value) {
            this.value = value;
        }

        @Override
        public String getLabel() {
            return this.value ? "true" : "false";
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return CoreDatatype.XSD.BOOLEAN.getIri();
        }

        @Override
        public CoreDatatype.XSD getCoreDatatype() {
            return CoreDatatype.XSD.BOOLEAN;
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }
    }

    static class TaggedLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -19640527584237291L;
        private final String label;
        private final String language;

        TaggedLiteral(String label, String language) {
            this.label = label;
            this.language = language;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.of(this.language);
        }

        @Override
        public IRI getDatatype() {
            return CoreDatatype.RDF.LANGSTRING.getIri();
        }

        @Override
        public CoreDatatype.RDF getCoreDatatype() {
            return CoreDatatype.RDF.LANGSTRING;
        }
    }

    static class TypedLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -19640527584237291L;
        private final String label;
        private final CoreDatatype coreDatatype;
        private final IRI datatype;

        TypedLiteral(String label) {
            this.label = label;
            this.coreDatatype = CoreDatatype.XSD.STRING;
            this.datatype = CoreDatatype.XSD.STRING.getIri();
        }

        TypedLiteral(String label, IRI datatype) {
            this.label = label;
            if (datatype == null) {
                this.datatype = CoreDatatype.XSD.STRING.getIri();
                this.coreDatatype = CoreDatatype.XSD.STRING;
            } else {
                this.datatype = datatype;
                this.coreDatatype = CoreDatatype.from(datatype);
            }
        }

        TypedLiteral(String label, CoreDatatype datatype) {
            this.label = label;
            this.coreDatatype = Objects.requireNonNull(datatype);
            this.datatype = datatype.getIri();
        }

        TypedLiteral(String label, IRI datatype, CoreDatatype coreDatatype) {
            assert (datatype != null);
            assert (coreDatatype != null);
            assert (coreDatatype == CoreDatatype.NONE || datatype == coreDatatype.getIri());
            this.label = label;
            this.datatype = datatype;
            this.coreDatatype = coreDatatype;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype;
        }

        @Override
        public CoreDatatype getCoreDatatype() {
            return this.coreDatatype;
        }
    }
}

