/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public abstract class AbstractStatement
implements Statement {
    private static final long serialVersionUID = 2087591563645988076L;

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Statement && this.getObject().equals(((Statement)o).getObject()) && this.getSubject().equals(((Statement)o).getSubject()) && this.getPredicate().equals(((Statement)o).getPredicate()) && Objects.equals(this.getContext(), ((Statement)o).getContext());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject(), this.getContext());
    }

    public String toString() {
        return "(" + this.getSubject() + ", " + this.getPredicate() + ", " + this.getObject() + (this.getContext() == null ? "" : ", " + this.getContext()) + ")";
    }

    static class GenericStatement
    extends AbstractStatement {
        private static final long serialVersionUID = -4116676621136121342L;
        private Resource subject;
        private IRI predicate;
        private Value object;
        private Resource context;

        GenericStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        @Override
        public Resource getSubject() {
            return this.subject;
        }

        @Override
        public IRI getPredicate() {
            return this.predicate;
        }

        @Override
        public Value getObject() {
            return this.object;
        }

        @Override
        public Resource getContext() {
            return this.context;
        }
    }
}

