/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.common.transaction.TransactionSettingRegistry;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class TransactionStartController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String externalUrl;

    public TransactionStartController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"POST"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if (!"POST".equals(reqMethod)) {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        this.logger.info("POST transaction start");
        ModelAndView result = this.startTransaction(repository, request, response);
        this.logger.info("transaction started");
        return result;
    }

    @Deprecated
    ArrayList<TransactionSetting> getIsolationLevel(HttpServletRequest request) {
        ArrayList<TransactionSetting> transactionSettings = new ArrayList<TransactionSetting>();
        String isolationLevelString = request.getParameter("isolation-level");
        if (isolationLevelString != null) {
            String isolationLevelConverted = isolationLevelString.replace("http://www.openrdf.org/schema/sesame#", "");
            for (IsolationLevels standardLevel : IsolationLevels.values()) {
                if (!standardLevel.getValue().equals(isolationLevelConverted)) continue;
                transactionSettings.add((TransactionSetting)IsolationLevels.valueOf((String)isolationLevelConverted));
                break;
            }
            if (transactionSettings.isEmpty()) {
                throw new IllegalArgumentException("Unknown isolation-level setting " + isolationLevelString);
            }
        }
        return transactionSettings;
    }

    ArrayList<TransactionSetting> getTransactionSettings(HttpServletRequest request) {
        ArrayList<TransactionSetting> transactionSettings = new ArrayList<TransactionSetting>();
        request.getParameterMap().forEach((k, v) -> {
            if (k.startsWith("transaction-setting__")) {
                String settingsName = k.replace("transaction-setting__", "");
                if (settingsName.equals(IsolationLevels.NONE.getName())) {
                    transactionSettings.add((TransactionSetting)IsolationLevels.valueOf((String)v[0]));
                } else {
                    TransactionSettingRegistry.getInstance().get((Object)settingsName).flatMap(factory -> factory.getTransactionSetting(v[0])).ifPresent(transactionSettings::add);
                }
            }
        });
        return transactionSettings;
    }

    Transaction createTransaction(Repository repository) throws ExecutionException, InterruptedException {
        return new Transaction(repository);
    }

    private ModelAndView startTransaction(Repository repository, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, ServerHTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        ArrayList<TransactionSetting> transactionSettings = this.getIsolationLevel(request);
        transactionSettings.addAll(this.getTransactionSettings(request));
        Transaction txn = null;
        boolean allGood = false;
        try {
            txn = this.createTransaction(repository);
            if (transactionSettings.isEmpty()) {
                txn.begin(new TransactionSetting[0]);
            } else {
                txn.begin(transactionSettings.toArray(new TransactionSetting[0]));
            }
            UUID txnId = txn.getID();
            model.put("sc", Integer.valueOf(201));
            StringBuffer txnURL = this.getUrlBasePath(request);
            txnURL.append("/" + txnId.toString());
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("Location", txnURL.toString());
            model.put("headers", customHeaders);
            ModelAndView result = new ModelAndView((View)SimpleResponseView.getInstance(), model);
            ActiveTransactionRegistry.INSTANCE.register(txn);
            allGood = true;
            ModelAndView modelAndView = result;
            return modelAndView;
        }
        catch (InterruptedException | ExecutionException | RepositoryException e) {
            throw new ServerHTTPException("Transaction start error: " + e.getMessage(), e);
        }
        finally {
            if (!allGood) {
                try {
                    txn.close();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new ServerHTTPException("Transaction start error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private StringBuffer getUrlBasePath(HttpServletRequest request) {
        if (this.externalUrl == null) {
            return request.getRequestURL();
        }
        StringBuffer url = new StringBuffer();
        if (this.externalUrl.endsWith("/")) {
            url.append(this.externalUrl, 0, this.externalUrl.length() - 1);
        } else {
            url.append(this.externalUrl);
        }
        url.append(request.getRequestURI());
        return url;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }
}

