/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.webapp.navigation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.webapp.navigation.AbstractNavigationNode;
import org.eclipse.rdf4j.common.webapp.navigation.View;

public class Group
extends AbstractNavigationNode {
    protected Map<String, Group> groups = new LinkedHashMap<String, Group>();
    protected Map<String, View> views = new LinkedHashMap<String, View>();
    protected Map<String, View> viewNames = new LinkedHashMap<String, View>();

    public Group(String id) {
        super(id);
    }

    public void addGroup(Group group) {
        group.setParent(this);
        this.groups.put(group.getId(), group);
    }

    public Group getGroup(String id) {
        return this.groups.get(id);
    }

    public List<Group> getGroups() {
        return new ArrayList<Group>(this.groups.values());
    }

    public void addView(View view) {
        view.setParent(this);
        this.views.put(view.getId(), view);
        this.viewNames.put(view.getId() + view.getViewSuffix(), view);
    }

    public View getView(String viewId) {
        return this.views.get(viewId);
    }

    public View getViewByName(String viewName) {
        return this.viewNames.get(viewName);
    }

    protected View findViewInternal(String viewName) {
        View result = null;
        int indexOfSeparator = viewName.indexOf(this.getPathSeparator());
        if (indexOfSeparator > 0) {
            String groupId = viewName.substring(0, indexOfSeparator);
            Group subGroup = this.getGroup(groupId);
            result = subGroup.findViewInternal(viewName.substring(indexOfSeparator + 1));
        } else {
            result = this.getViewByName(viewName);
        }
        return result;
    }

    public List<View> getViews() {
        return new ArrayList<View>(this.views.values());
    }

    public Object clone() {
        Group result = new Group(this.getId());
        this.copyCommonAttributes(result);
        this.copyGroupsAndViews(result);
        return result;
    }

    protected void copyGroupsAndViews(Group group) {
        for (Group subGroup : this.getGroups()) {
            Group clonedGroup = (Group)subGroup.clone();
            group.addGroup(clonedGroup);
        }
        for (View view : this.getViews()) {
            View clonedView = (View)view.clone();
            group.addView(clonedView);
        }
    }
}

