/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.GraphQueryResultView;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.http.server.repository.transaction.Transaction;
import org.eclipse.rdf4j.http.server.repository.transaction.TransactionExportStatementsView;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class TransactionController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public TransactionController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"POST", "PUT", "DELETE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        String reqMethod = request.getMethod();
        UUID transactionId = this.getTransactionID(request);
        this.logger.debug("transaction id: {}", (Object)transactionId);
        this.logger.debug("request content type: {}", (Object)request.getContentType());
        Transaction transaction = ActiveTransactionRegistry.INSTANCE.getTransaction(transactionId);
        if (transaction == null) {
            this.logger.warn("could not find transaction for transaction id {}", (Object)transactionId);
            throw new ClientHTTPException(400, "unable to find registerd transaction for transaction id '" + transactionId + "'");
        }
        String actionParam = request.getParameter("action");
        Protocol.Action action = actionParam != null ? Protocol.Action.valueOf((String)actionParam) : Protocol.Action.ROLLBACK;
        switch (action) {
            case QUERY: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn query request", (Object)reqMethod);
                result = this.processQuery(transaction, request, response);
                this.logger.info("{} txn query request finished", (Object)reqMethod);
                return result;
            }
            case GET: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn get/export statements request", (Object)reqMethod);
                result = this.getExportStatementsResult(transaction, request, response);
                this.logger.info("{} txn get/export statements request finished", (Object)reqMethod);
                return result;
            }
            case SIZE: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn size request", (Object)reqMethod);
                result = this.getSize(transaction, request, response);
                this.logger.info("{} txn size request finished", (Object)reqMethod);
                return result;
            }
        }
        if ("DELETE".equals(reqMethod) || action.equals((Object)Protocol.Action.ROLLBACK) && ("PUT".equals(reqMethod) || "POST".equals(reqMethod))) {
            this.logger.info("transaction rollback");
            try {
                transaction.rollback();
            }
            finally {
                ActiveTransactionRegistry.INSTANCE.deregister(transaction);
            }
            result = new ModelAndView((View)EmptySuccessView.getInstance());
            this.logger.info("transaction rollback request finished.");
            return result;
        }
        if (!"PUT".equals(reqMethod)) {
            if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        this.logger.info("{} txn operation", (Object)reqMethod);
        result = this.processModificationOperation(transaction, action, request, response);
        this.logger.info("PUT txn operation request finished.");
        return result;
    }

    private UUID getTransactionID(HttpServletRequest request) throws ClientHTTPException {
        String pathInfoStr = request.getPathInfo();
        UUID txnID = null;
        if (pathInfoStr != null && !pathInfoStr.equals("/")) {
            String[] pathInfo = pathInfoStr.substring(1).split("/");
            if (pathInfo.length == 3) {
                try {
                    txnID = UUID.fromString(pathInfo[2]);
                    this.logger.debug("txnID is '{}'", (Object)txnID);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "not a valid transaction id: " + pathInfo[2]);
                }
            } else {
                this.logger.warn("could not determine transaction id from path info {} ", (Object)pathInfoStr);
            }
        }
        return txnID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView processModificationOperation(Transaction transaction, Protocol.Action action, HttpServletRequest request, HttpServletResponse response) throws IOException, HTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, Integer> model = new HashMap<String, Integer>();
        String baseURI = request.getParameter("baseURI");
        if (baseURI == null) {
            baseURI = "";
        }
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", (ValueFactory)SimpleValueFactory.getInstance());
        boolean preserveNodeIds = ProtocolUtil.parseBooleanParam(request, "preserveNodeId", false);
        try {
            RDFFormat format = null;
            switch (action) {
                case ADD: {
                    format = (RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(Rio.unsupportedFormat((String)request.getContentType()));
                    transaction.add((InputStream)request.getInputStream(), baseURI, format, preserveNodeIds, contexts);
                    break;
                }
                case DELETE: {
                    format = (RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(Rio.unsupportedFormat((String)request.getContentType()));
                    transaction.delete(format, (InputStream)request.getInputStream(), baseURI);
                    break;
                }
                case UPDATE: {
                    return this.getSparqlUpdateResult(transaction, request, response);
                }
                case COMMIT: {
                    try {
                        transaction.commit();
                        break;
                    }
                    finally {
                        ActiveTransactionRegistry.INSTANCE.deregister(transaction);
                    }
                }
                default: {
                    this.logger.warn("transaction modification action '{}' not recognized", (Object)action);
                    throw new ClientHTTPException("modification action not recognized: " + action);
                }
            }
            model.put("sc", 200);
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        catch (Exception e) {
            if (e instanceof ClientHTTPException) {
                throw (ClientHTTPException)e;
            }
            throw new ServerHTTPException(500, "Transaction handling error: " + e.getMessage(), e);
        }
    }

    private ModelAndView getSize(Transaction transaction, HttpServletRequest request, HttpServletResponse response) throws HTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, String> model = new HashMap<String, String>();
        boolean headersOnly = "HEAD".equals(request.getMethod());
        if (!headersOnly) {
            Repository repository = RepositoryInterceptor.getRepository(request);
            ValueFactory vf = repository.getValueFactory();
            Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
            long size = -1L;
            try {
                size = transaction.getSize(contexts);
            }
            catch (InterruptedException | ExecutionException | RepositoryException e) {
                throw new ServerHTTPException("Repository error: " + e.getMessage(), e);
            }
            model.put("content", String.valueOf(size));
        }
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }

    private ModelAndView getExportStatementsResult(Transaction transaction, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        Resource subj = ProtocolUtil.parseResourceParam(request, "subj", (ValueFactory)vf);
        IRI pred = ProtocolUtil.parseURIParam(request, "pred", (ValueFactory)vf);
        Value obj = ProtocolUtil.parseValueParam(request, "obj", (ValueFactory)vf);
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", (ValueFactory)vf);
        boolean useInferencing = ProtocolUtil.parseBooleanParam(request, "infer", true);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subj);
        model.put("predicate", pred);
        model.put("object", obj);
        model.put("contexts", contexts);
        model.put("useInferencing", useInferencing);
        model.put("factory", rdfWriterFactory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        model.put("transaction", transaction);
        return new ModelAndView((View)TransactionExportStatementsView.getInstance(), model);
    }

    private ModelAndView processQuery(Transaction txn, HttpServletRequest request, HttpServletResponse response) throws IOException, HTTPException {
        QueryResultView view;
        TupleQueryResultWriterRegistry registry;
        Object queryResult;
        block9: {
            String queryStr = null;
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("application/sparql-query")) {
                String encoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8";
                queryStr = IOUtils.toString((InputStream)request.getInputStream(), (String)encoding);
            } else {
                queryStr = request.getParameter("query");
            }
            try {
                Query query = this.getQuery(txn, queryStr, request, response);
                if (query instanceof TupleQuery) {
                    TupleQuery tQuery = (TupleQuery)query;
                    queryResult = txn.evaluate(tQuery);
                    registry = TupleQueryResultWriterRegistry.getInstance();
                    view = TupleQueryResultView.getInstance();
                    break block9;
                }
                if (query instanceof GraphQuery) {
                    GraphQuery gQuery = (GraphQuery)query;
                    queryResult = txn.evaluate(gQuery);
                    registry = RDFWriterRegistry.getInstance();
                    view = GraphQueryResultView.getInstance();
                    break block9;
                }
                if (query instanceof BooleanQuery) {
                    BooleanQuery bQuery = (BooleanQuery)query;
                    queryResult = txn.evaluate(bQuery);
                    registry = BooleanQueryResultWriterRegistry.getInstance();
                    view = BooleanQueryResultView.getInstance();
                    break block9;
                }
                throw new ClientHTTPException(400, "Unsupported query type: " + query.getClass().getName());
            }
            catch (InterruptedException | ExecutionException | QueryInterruptedException e) {
                this.logger.info("Query interrupted", e);
                throw new ServerHTTPException(503, "Query execution interrupted");
            }
            catch (QueryEvaluationException e) {
                this.logger.info("Query evaluation error", (Throwable)e);
                if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                    throw (HTTPException)e.getCause();
                }
                throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
            }
        }
        Object factory = ProtocolUtil.getAcceptableService(request, response, registry);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filenameHint", "query-result");
        model.put("queryResult", queryResult);
        model.put("factory", factory);
        model.put("headersOnly", false);
        return new ModelAndView((View)view, model);
    }

    private Query getQuery(Transaction txn, String queryStr, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, InterruptedException, ExecutionException {
        Query result = null;
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf((String)queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String timeout = request.getParameter("timeout");
        int maxQueryTime = 0;
        if (timeout != null) {
            try {
                maxQueryTime = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ClientHTTPException(400, "Invalid timeout value: " + timeout);
            }
        }
        String[] defaultGraphURIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("named-graph-uri");
        SimpleDataset dataset = null;
        if (defaultGraphURIs != null || namedGraphURIs != null) {
            IRI uri;
            dataset = new SimpleDataset();
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = null;
                        if (!"null".equals(defaultGraphURI)) {
                            uri = SimpleValueFactory.getInstance().createIRI(defaultGraphURI);
                        }
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = null;
                        if (!"null".equals(namedGraphURI)) {
                            uri = SimpleValueFactory.getInstance().createIRI(namedGraphURI);
                        }
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = txn.prepareQuery(queryLn, queryStr, baseURI);
            result.setIncludeInferred(includeInferred);
            if (maxQueryTime > 0) {
                result.setMaxExecutionTime(maxQueryTime);
            }
            if (dataset != null) {
                result.setDataset((Dataset)dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, (ValueFactory)SimpleValueFactory.getInstance());
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error", (Throwable)e);
            response.sendError(500);
        }
        return result;
    }

    private ModelAndView getSparqlUpdateResult(Transaction transaction, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        IRI uri;
        String sparqlUpdateString = null;
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains("application/sparql-update")) {
            try {
                String encoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8";
                sparqlUpdateString = IOUtils.toString((InputStream)request.getInputStream(), (String)encoding);
            }
            catch (IOException e) {
                this.logger.warn("error reading sparql update string from request body", (Throwable)e);
                throw new ClientHTTPException(400, "could not read SPARQL update string from body: " + e.getMessage());
            }
        } else {
            sparqlUpdateString = request.getParameter("update");
        }
        this.logger.debug("SPARQL update string: {}", (Object)sparqlUpdateString);
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf((String)queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String[] defaultRemoveGraphURIs = request.getParameterValues("remove-graph-uri");
        String[] defaultInsertGraphURIs = request.getParameterValues("insert-graph-uri");
        String[] defaultGraphURIs = request.getParameterValues("using-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("using-named-graph-uri");
        SimpleDataset dataset = new SimpleDataset();
        if (defaultRemoveGraphURIs != null) {
            String[] stringArray = defaultRemoveGraphURIs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String graphURI = stringArray[i];
                try {
                    uri = null;
                    if (!"null".equals(graphURI)) {
                        uri = SimpleValueFactory.getInstance().createIRI(graphURI);
                    }
                    dataset.addDefaultRemoveGraph(uri);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default remove graph: " + graphURI);
                }
            }
        }
        if (defaultInsertGraphURIs != null && defaultInsertGraphURIs.length > 0) {
            String string = defaultInsertGraphURIs[0];
            try {
                IRI uri2 = null;
                if (!"null".equals(string)) {
                    uri2 = SimpleValueFactory.getInstance().createIRI(string);
                }
                dataset.setDefaultInsertGraph(uri2);
            }
            catch (IllegalArgumentException e) {
                throw new ClientHTTPException(400, "Illegal URI for default insert graph: " + string);
            }
        }
        if (defaultGraphURIs != null) {
            for (String defaultGraphURI : defaultGraphURIs) {
                try {
                    uri = null;
                    if (!"null".equals(defaultGraphURI)) {
                        uri = SimpleValueFactory.getInstance().createIRI(defaultGraphURI);
                    }
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                }
            }
        }
        if (namedGraphURIs != null) {
            for (String namedGraphURI : namedGraphURIs) {
                try {
                    uri = null;
                    if (!"null".equals(namedGraphURI)) {
                        uri = SimpleValueFactory.getInstance().createIRI(namedGraphURI);
                    }
                    dataset.addNamedGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                }
            }
        }
        try {
            Enumeration enumeration = request.getParameterNames();
            HashMap<String, Value> bindings = new HashMap<String, Value>();
            while (enumeration.hasMoreElements()) {
                String parameterName = (String)enumeration.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, (ValueFactory)SimpleValueFactory.getInstance());
                bindings.put(bindingName, bindingValue);
            }
            transaction.executeUpdate(queryLn, sparqlUpdateString, baseURI, includeInferred, (Dataset)dataset, bindings);
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (InterruptedException | ExecutionException | UpdateExecutionException throwable) {
            if (throwable.getCause() != null && throwable.getCause() instanceof HTTPException) {
                throw (HTTPException)throwable.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + throwable.getMessage(), throwable);
        }
        catch (RepositoryException repositoryException) {
            if (repositoryException.getCause() != null && repositoryException.getCause() instanceof HTTPException) {
                throw (HTTPException)repositoryException.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + repositoryException.getMessage(), (Throwable)repositoryException);
        }
        catch (MalformedQueryException malformedQueryException) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, malformedQueryException.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
    }
}

