/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ActiveTransactionRegistry {
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(ActiveTransactionRegistry.class);
    public static final String CACHE_TIMEOUT_PROPERTY = "sesame.server.txn.registry.timeout";
    public static final int DEFAULT_TIMEOUT = 60;
    private final Cache<UUID, CacheEntry> activeConnections;

    private ActiveTransactionRegistry() {
        int timeout = 60;
        String configuredValue = System.getProperty(CACHE_TIMEOUT_PROPERTY);
        if (configuredValue != null) {
            try {
                timeout = Integer.parseInt(configuredValue);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Expected integer value for property {}. Timeout will default to {} seconds. ", (Object)CACHE_TIMEOUT_PROPERTY, (Object)60);
            }
        }
        this.activeConnections = this.initializeCache(timeout, TimeUnit.SECONDS);
    }

    private final Cache<UUID, CacheEntry> initializeCache(int timeout, TimeUnit unit) {
        return CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<UUID, CacheEntry>(){

            public void onRemoval(RemovalNotification<UUID, CacheEntry> notification) {
                if (RemovalCause.EXPIRED.equals((Object)notification.getCause())) {
                    ActiveTransactionRegistry.this.logger.warn("transaction registry item {} removed after expiry", notification.getKey());
                    CacheEntry entry = (CacheEntry)notification.getValue();
                    try {
                        entry.getConnection().close();
                    }
                    catch (RepositoryException repositoryException) {}
                } else {
                    ActiveTransactionRegistry.this.logger.debug("transaction {} removed from registry. cause: {}", notification.getKey(), (Object)notification.getCause());
                }
            }
        }).expireAfterAccess((long)timeout, unit).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UUID transactionId, RepositoryConnection conn) throws RepositoryException {
        Cache<UUID, CacheEntry> cache = this.activeConnections;
        synchronized (cache) {
            if (this.activeConnections.getIfPresent((Object)transactionId) != null) {
                this.logger.error("transaction already registered: {}", (Object)transactionId);
                throw new RepositoryException("transaction with id " + transactionId.toString() + " already registered.");
            }
            this.activeConnections.put((Object)transactionId, (Object)new CacheEntry(conn));
            this.logger.debug("registered transaction {} ", (Object)transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(UUID transactionId) throws RepositoryException {
        Cache<UUID, CacheEntry> cache = this.activeConnections;
        synchronized (cache) {
            CacheEntry entry = (CacheEntry)this.activeConnections.getIfPresent((Object)transactionId);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transactionId.toString() + " not registered.");
            }
            this.activeConnections.invalidate((Object)transactionId);
            Lock txnLock = entry.getLock();
            txnLock.unlock();
            this.logger.debug("deregistered transaction {}", (Object)transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection getTransactionConnection(UUID transactionId) throws RepositoryException, InterruptedException {
        Lock txnLock = null;
        Cache<UUID, CacheEntry> cache = this.activeConnections;
        synchronized (cache) {
            CacheEntry entry = (CacheEntry)this.activeConnections.getIfPresent((Object)transactionId);
            if (entry == null) {
                throw new RepositoryException("transaction with id " + transactionId.toString() + " not registered.");
            }
            txnLock = entry.getLock();
        }
        txnLock.lockInterruptibly();
        CacheEntry entry = (CacheEntry)this.activeConnections.getIfPresent((Object)transactionId);
        if (entry == null) {
            throw new RepositoryException("transaction with id " + transactionId + " is no longer registered!");
        }
        return entry.getConnection();
    }

    public void returnTransactionConnection(UUID transactionId) {
        CacheEntry entry = (CacheEntry)this.activeConnections.getIfPresent((Object)transactionId);
        if (entry != null) {
            Lock txnLock = entry.getLock();
            txnLock.unlock();
        }
    }

    static class CacheEntry {
        private final RepositoryConnection connection;
        private final Lock lock = new ReentrantLock();

        public CacheEntry(RepositoryConnection connection) {
            this.connection = connection;
        }

        public RepositoryConnection getConnection() {
            return this.connection;
        }

        public Lock getLock() {
            return this.lock;
        }
    }
}

