/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.ServerInterceptor;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInterceptor
extends ServerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String REPOSITORY_ID_KEY = "repositoryID";
    private static final String REPOSITORY_KEY = "repository";
    private static final String REPOSITORY_CONNECTION_KEY = "repositoryConnection";
    private RepositoryManager repositoryManager;
    private String repositoryID;
    private RepositoryConnection repositoryCon;

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse respons, Object handler) throws Exception {
        String[] pathInfo;
        String pathInfoStr = request.getPathInfo();
        this.logger.debug("path info: {}", (Object)pathInfoStr);
        this.repositoryID = null;
        if (pathInfoStr != null && !pathInfoStr.equals("/") && (pathInfo = pathInfoStr.substring(1).split("/")).length > 0) {
            this.repositoryID = pathInfo[0];
            this.logger.debug("repositoryID is '{}'", (Object)this.repositoryID);
        }
        ProtocolUtil.logRequestParameters(request);
        return super.preHandle(request, respons, handler);
    }

    @Override
    protected String getThreadName() {
        String threadName = "repositories";
        if (this.repositoryID != null) {
            threadName = threadName + "/" + this.repositoryID;
        }
        return threadName;
    }

    @Override
    protected void setRequestAttributes(HttpServletRequest request) throws ClientHTTPException, ServerHTTPException {
        if (this.repositoryID != null) {
            try {
                Repository repository = this.repositoryManager.getRepository(this.repositoryID);
                if (repository == null) {
                    throw new ClientHTTPException(404, "Unknown repository: " + this.repositoryID);
                }
                this.repositoryCon = repository.getConnection();
                this.repositoryCon.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
                this.repositoryCon.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
                if (!this.repositoryCon.isAutoCommit()) {
                    this.repositoryCon.setAutoCommit(true);
                }
                request.setAttribute(REPOSITORY_ID_KEY, (Object)this.repositoryID);
                request.setAttribute(REPOSITORY_KEY, (Object)repository);
                request.setAttribute(REPOSITORY_CONNECTION_KEY, (Object)this.repositoryCon);
            }
            catch (RepositoryConfigException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void cleanUpResources() throws ServerHTTPException {
        if (this.repositoryCon != null) {
            try {
                this.repositoryCon.close();
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getRepositoryID(HttpServletRequest request) {
        return (String)request.getAttribute(REPOSITORY_ID_KEY);
    }

    public static Repository getRepository(HttpServletRequest request) {
        return (Repository)request.getAttribute(REPOSITORY_KEY);
    }

    public static RepositoryConnection getRepositoryConnection(HttpServletRequest request) {
        return (RepositoryConnection)request.getAttribute(REPOSITORY_CONNECTION_KEY);
    }
}

