/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.GraphQueryResultView;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.http.server.repository.statements.ExportStatementsView;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class TransactionController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public TransactionController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"POST", "PUT", "DELETE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        String reqMethod = request.getMethod();
        UUID transactionId = this.getTransactionID(request);
        this.logger.debug("transaction id: {}", (Object)transactionId);
        this.logger.debug("request content type: {}", (Object)request.getContentType());
        RepositoryConnection connection = ActiveTransactionRegistry.INSTANCE.getTransactionConnection(transactionId);
        if (connection == null) {
            this.logger.warn("could not find connection for transaction id {}", (Object)transactionId);
            throw new ClientHTTPException(400, "unable to find registerd connection for transaction id '" + transactionId + "'");
        }
        String actionParam = request.getParameter("action");
        Protocol.Action action = actionParam != null ? Protocol.Action.valueOf((String)actionParam) : Protocol.Action.ROLLBACK;
        switch (action) {
            case QUERY: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn query request", (Object)reqMethod);
                result = this.processQuery(connection, transactionId, request, response);
                this.logger.info("{} txn query request finished", (Object)reqMethod);
                return result;
            }
            case GET: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn get/export statements request", (Object)reqMethod);
                result = this.getExportStatementsResult(connection, transactionId, request, response);
                this.logger.info("{} txn get/export statements request finished", (Object)reqMethod);
                return result;
            }
            case SIZE: {
                if (!"PUT".equals(reqMethod)) {
                    if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
                }
                this.logger.info("{} txn size request", (Object)reqMethod);
                result = this.getSize(connection, transactionId, request, response);
                this.logger.info("{} txn size request finished", (Object)reqMethod);
                return result;
            }
        }
        try {
            if ("DELETE".equals(reqMethod) || action.equals((Object)Protocol.Action.ROLLBACK) && ("PUT".equals(reqMethod) || "POST".equals(reqMethod))) {
                this.logger.info("transaction rollback");
                try {
                    connection.rollback();
                }
                finally {
                    ActiveTransactionRegistry.INSTANCE.deregister(transactionId);
                    connection.close();
                }
                result = new ModelAndView((View)EmptySuccessView.getInstance());
                this.logger.info("transaction rollback request finished.");
                return result;
            }
            if (!"PUT".equals(reqMethod)) {
                if (!"POST".equals(reqMethod)) throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
            }
            this.logger.info("{} txn operation", (Object)reqMethod);
            result = this.processModificationOperation(connection, action, request, response);
            this.logger.info("PUT txn operation request finished.");
            return result;
        }
        finally {
            ActiveTransactionRegistry.INSTANCE.returnTransactionConnection(transactionId);
        }
    }

    private UUID getTransactionID(HttpServletRequest request) throws ClientHTTPException {
        String pathInfoStr = request.getPathInfo();
        UUID txnID = null;
        if (pathInfoStr != null && !pathInfoStr.equals("/")) {
            String[] pathInfo = pathInfoStr.substring(1).split("/");
            if (pathInfo.length == 3) {
                try {
                    txnID = UUID.fromString(pathInfo[2]);
                    this.logger.debug("txnID is '{}'", (Object)txnID);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "not a valid transaction id: " + pathInfo[2]);
                }
            } else {
                this.logger.warn("could not determine transaction id from path info {} ", (Object)pathInfoStr);
            }
        }
        return txnID;
    }

    private ModelAndView processModificationOperation(RepositoryConnection conn, Protocol.Action action, HttpServletRequest request, HttpServletResponse response) throws IOException, HTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, Integer> model = new HashMap<String, Integer>();
        String baseURI = request.getParameter("baseURI");
        if (baseURI == null) {
            baseURI = "";
        }
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", conn.getValueFactory());
        boolean preserveNodeIds = ProtocolUtil.parseBooleanParam(request, "preserveNodeId", false);
        try {
            switch (action) {
                case ADD: {
                    RDFFormat format = (RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(Rio.unsupportedFormat((String)request.getContentType()));
                    if (preserveNodeIds) {
                        RDFParser parser = Rio.createParser((RDFFormat)format);
                        parser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                        RDFInserter inserter = new RDFInserter(conn);
                        inserter.setPreserveBNodeIDs(true);
                        if (contexts.length > 0) {
                            inserter.enforceContext(contexts);
                        }
                        parser.setRDFHandler((RDFHandler)inserter);
                        parser.parse((InputStream)request.getInputStream(), baseURI);
                        break;
                    }
                    conn.add((InputStream)request.getInputStream(), baseURI, format, contexts);
                    break;
                }
                case DELETE: {
                    RDFParser parser = Rio.createParser((RDFFormat)((RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(Rio.unsupportedFormat((String)request.getContentType()))), (ValueFactory)conn.getValueFactory());
                    parser.setRDFHandler((RDFHandler)new WildcardRDFRemover(conn));
                    parser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                    parser.parse((InputStream)request.getInputStream(), baseURI);
                    break;
                }
                case UPDATE: {
                    return this.getSparqlUpdateResult(conn, request, response);
                }
                case COMMIT: {
                    conn.commit();
                    conn.close();
                    ActiveTransactionRegistry.INSTANCE.deregister(this.getTransactionID(request));
                    break;
                }
                default: {
                    this.logger.warn("transaction modification action '{}' not recognized", (Object)action);
                    throw new ClientHTTPException("modification action not recognized: " + action);
                }
            }
            model.put("sc", 200);
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        catch (Exception e) {
            if (e instanceof ClientHTTPException) {
                throw (ClientHTTPException)e;
            }
            throw new ServerHTTPException(500, "Transaction handling error: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView getSize(RepositoryConnection conn, UUID txnId, HttpServletRequest request, HttpServletResponse response) throws HTTPException {
        try {
            ProtocolUtil.logRequestParameters(request);
            HashMap<String, String> model = new HashMap<String, String>();
            boolean headersOnly = "HEAD".equals(request.getMethod());
            if (!headersOnly) {
                Repository repository = RepositoryInterceptor.getRepository(request);
                ValueFactory vf = repository.getValueFactory();
                Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
                long size = -1L;
                try {
                    size = conn.size(contexts);
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
                }
                model.put("content", String.valueOf(size));
            }
            ModelAndView modelAndView = new ModelAndView((View)SimpleResponseView.getInstance(), model);
            return modelAndView;
        }
        finally {
            ActiveTransactionRegistry.INSTANCE.returnTransactionConnection(txnId);
        }
    }

    private ModelAndView getExportStatementsResult(RepositoryConnection conn, UUID txnId, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = conn.getValueFactory();
        Resource subj = ProtocolUtil.parseResourceParam(request, "subj", vf);
        IRI pred = ProtocolUtil.parseURIParam(request, "pred", vf);
        Value obj = ProtocolUtil.parseValueParam(request, "obj", vf);
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        boolean useInferencing = ProtocolUtil.parseBooleanParam(request, "infer", true);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("subject", subj);
        model.put("predicate", pred);
        model.put("object", obj);
        model.put("contexts", contexts);
        model.put("useInferencing", useInferencing);
        model.put("factory", rdfWriterFactory);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        model.put("connection", conn);
        model.put("transactionID", txnId);
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    private ModelAndView processQuery(RepositoryConnection conn, UUID txnId, HttpServletRequest request, HttpServletResponse response) throws IOException, HTTPException {
        QueryResultView view;
        TupleQueryResultWriterRegistry registry;
        Object queryResult;
        block9: {
            String queryStr = null;
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("application/sparql-query")) {
                String encoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8";
                queryStr = IOUtils.toString((InputStream)request.getInputStream(), (String)encoding);
            } else {
                queryStr = request.getParameter("query");
            }
            Query query = this.getQuery(conn, queryStr, request, response);
            try {
                if (query instanceof TupleQuery) {
                    TupleQuery tQuery = (TupleQuery)query;
                    queryResult = tQuery.evaluate();
                    registry = TupleQueryResultWriterRegistry.getInstance();
                    view = TupleQueryResultView.getInstance();
                    break block9;
                }
                if (query instanceof GraphQuery) {
                    GraphQuery gQuery = (GraphQuery)query;
                    queryResult = gQuery.evaluate();
                    registry = RDFWriterRegistry.getInstance();
                    view = GraphQueryResultView.getInstance();
                    break block9;
                }
                if (query instanceof BooleanQuery) {
                    BooleanQuery bQuery = (BooleanQuery)query;
                    queryResult = bQuery.evaluate();
                    registry = BooleanQueryResultWriterRegistry.getInstance();
                    view = BooleanQueryResultView.getInstance();
                    break block9;
                }
                throw new ClientHTTPException(400, "Unsupported query type: " + query.getClass().getName());
            }
            catch (QueryInterruptedException e) {
                this.logger.info("Query interrupted", (Throwable)e);
                ActiveTransactionRegistry.INSTANCE.returnTransactionConnection(txnId);
                throw new ServerHTTPException(503, "Query evaluation took too long");
            }
            catch (QueryEvaluationException e) {
                this.logger.info("Query evaluation error", (Throwable)e);
                ActiveTransactionRegistry.INSTANCE.returnTransactionConnection(txnId);
                if (e.getCause() != null && e.getCause() instanceof HTTPException) {
                    throw (HTTPException)e.getCause();
                }
                throw new ServerHTTPException("Query evaluation error: " + e.getMessage());
            }
        }
        Object factory = ProtocolUtil.getAcceptableService(request, response, registry);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filenameHint", "query-result");
        model.put("queryResult", queryResult);
        model.put("factory", factory);
        model.put("headersOnly", false);
        model.put("transactionID", txnId);
        return new ModelAndView((View)view, model);
    }

    private Query getQuery(RepositoryConnection repositoryCon, String queryStr, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException {
        Query result = null;
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf((String)queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String timeout = request.getParameter("timeout");
        int maxQueryTime = 0;
        if (timeout != null) {
            try {
                maxQueryTime = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                throw new ClientHTTPException(400, "Invalid timeout value: " + timeout);
            }
        }
        String[] defaultGraphURIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("named-graph-uri");
        SimpleDataset dataset = null;
        if (defaultGraphURIs != null || namedGraphURIs != null) {
            IRI uri;
            dataset = new SimpleDataset();
            if (defaultGraphURIs != null) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = null;
                        if (!"null".equals(defaultGraphURI)) {
                            uri = repositoryCon.getValueFactory().createIRI(defaultGraphURI);
                        }
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs != null) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = null;
                        if (!"null".equals(namedGraphURI)) {
                            uri = repositoryCon.getValueFactory().createIRI(namedGraphURI);
                        }
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = repositoryCon.prepareQuery(queryLn, queryStr, baseURI);
            result.setIncludeInferred(includeInferred);
            if (maxQueryTime > 0) {
                result.setMaxQueryTime(maxQueryTime);
            }
            if (dataset != null) {
                result.setDataset((Dataset)dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repositoryCon.getValueFactory());
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error", (Throwable)e);
            response.sendError(500);
        }
        return result;
    }

    private ModelAndView getSparqlUpdateResult(RepositoryConnection conn, HttpServletRequest request, HttpServletResponse response) throws ServerHTTPException, ClientHTTPException, HTTPException {
        IRI uri;
        String sparqlUpdateString = null;
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains("application/sparql-update")) {
            try {
                String encoding = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8";
                sparqlUpdateString = IOUtils.toString((InputStream)request.getInputStream(), (String)encoding);
            }
            catch (IOException e) {
                this.logger.warn("error reading sparql update string from request body", (Throwable)e);
                throw new ClientHTTPException(400, "could not read SPARQL update string from body: " + e.getMessage());
            }
        } else {
            sparqlUpdateString = request.getParameter("update");
        }
        this.logger.debug("SPARQL update string: {}", (Object)sparqlUpdateString);
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        String queryLnStr = request.getParameter("queryLn");
        this.logger.debug("query language param = {}", (Object)queryLnStr);
        if (queryLnStr != null && (queryLn = QueryLanguage.valueOf((String)queryLnStr)) == null) {
            throw new ClientHTTPException(400, "Unknown query language: " + queryLnStr);
        }
        String baseURI = request.getParameter("baseURI");
        boolean includeInferred = ProtocolUtil.parseBooleanParam(request, "infer", true);
        String[] defaultRemoveGraphURIs = request.getParameterValues("remove-graph-uri");
        String[] defaultInsertGraphURIs = request.getParameterValues("insert-graph-uri");
        String[] defaultGraphURIs = request.getParameterValues("using-graph-uri");
        String[] namedGraphURIs = request.getParameterValues("using-named-graph-uri");
        SimpleDataset dataset = new SimpleDataset();
        if (defaultRemoveGraphURIs != null) {
            String[] stringArray = defaultRemoveGraphURIs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String graphURI = stringArray[i];
                try {
                    uri = null;
                    if (!"null".equals(graphURI)) {
                        uri = conn.getValueFactory().createIRI(graphURI);
                    }
                    dataset.addDefaultRemoveGraph(uri);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default remove graph: " + graphURI);
                }
            }
        }
        if (defaultInsertGraphURIs != null && defaultInsertGraphURIs.length > 0) {
            String string = defaultInsertGraphURIs[0];
            try {
                IRI uri2 = null;
                if (!"null".equals(string)) {
                    uri2 = conn.getValueFactory().createIRI(string);
                }
                dataset.setDefaultInsertGraph(uri2);
            }
            catch (IllegalArgumentException e) {
                throw new ClientHTTPException(400, "Illegal URI for default insert graph: " + string);
            }
        }
        if (defaultGraphURIs != null) {
            for (String defaultGraphURI : defaultGraphURIs) {
                try {
                    uri = null;
                    if (!"null".equals(defaultGraphURI)) {
                        uri = conn.getValueFactory().createIRI(defaultGraphURI);
                    }
                    dataset.addDefaultGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for default graph: " + defaultGraphURI);
                }
            }
        }
        if (namedGraphURIs != null) {
            for (String namedGraphURI : namedGraphURIs) {
                try {
                    uri = null;
                    if (!"null".equals(namedGraphURI)) {
                        uri = conn.getValueFactory().createIRI(namedGraphURI);
                    }
                    dataset.addNamedGraph(uri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal URI for named graph: " + namedGraphURI);
                }
            }
        }
        try {
            Update update = conn.prepareUpdate(queryLn, sparqlUpdateString, baseURI);
            update.setIncludeInferred(includeInferred);
            if (dataset != null) {
                update.setDataset((Dataset)dataset);
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, conn.getValueFactory());
                update.setBinding(bindingName, bindingValue);
            }
            update.execute();
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (UpdateExecutionException updateExecutionException) {
            if (updateExecutionException.getCause() != null && updateExecutionException.getCause() instanceof HTTPException) {
                throw (HTTPException)updateExecutionException.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + updateExecutionException.getMessage(), (Throwable)updateExecutionException);
        }
        catch (RepositoryException repositoryException) {
            if (repositoryException.getCause() != null && repositoryException.getCause() instanceof HTTPException) {
                throw (HTTPException)repositoryException.getCause();
            }
            throw new ServerHTTPException("Repository update error: " + repositoryException.getMessage(), (Throwable)repositoryException);
        }
        catch (MalformedQueryException malformedQueryException) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, malformedQueryException.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
    }

    private static class WildcardRDFRemover
    extends AbstractRDFHandler {
        private final RepositoryConnection conn;

        public WildcardRDFRemover(RepositoryConnection conn) {
            this.conn = conn;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            Resource subject = SESAME.WILDCARD.equals((Object)st.getSubject()) ? null : st.getSubject();
            IRI predicate = SESAME.WILDCARD.equals((Object)st.getPredicate()) ? null : st.getPredicate();
            Value object = SESAME.WILDCARD.equals((Object)st.getObject()) ? null : st.getObject();
            boolean clearAllTriples = subject == null && predicate == null && object == null;
            try {
                Resource context = st.getContext();
                if (context != null) {
                    if (clearAllTriples) {
                        this.conn.clear(new Resource[]{context});
                    } else {
                        this.conn.remove(subject, predicate, object, new Resource[]{context});
                    }
                } else if (clearAllTriples) {
                    this.conn.clear(new Resource[0]);
                } else {
                    this.conn.remove(subject, predicate, object, new Resource[0]);
                }
            }
            catch (RepositoryException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }
}

