/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.transaction.ActiveTransactionRegistry;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class TransactionStartController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public TransactionStartController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"POST"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if (!"POST".equals(reqMethod)) {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        this.logger.info("POST transaction start");
        ModelAndView result = this.startTransaction(repository, request, response);
        this.logger.info("transaction started");
        return result;
    }

    private ModelAndView startTransaction(Repository repository, HttpServletRequest request, HttpServletResponse response) throws IOException, ClientHTTPException, ServerHTTPException {
        ProtocolUtil.logRequestParameters(request);
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        IsolationLevels isolationLevel = null;
        String isolationLevelString = request.getParameter("isolation-level");
        if (isolationLevelString != null) {
            IRI level = SimpleValueFactory.getInstance().createIRI(isolationLevelString);
            for (IsolationLevels standardLevel : IsolationLevels.values()) {
                if (!standardLevel.getURI().equals((Object)level)) continue;
                isolationLevel = standardLevel;
                break;
            }
        }
        try {
            RepositoryConnection conn = repository.getConnection();
            ParserConfig config = conn.getParserConfig();
            config.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            config.addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            conn.begin(isolationLevel);
            UUID txnId = UUID.randomUUID();
            ActiveTransactionRegistry.INSTANCE.register(txnId, conn);
            model.put("sc", Integer.valueOf(201));
            StringBuffer txnURL = request.getRequestURL();
            txnURL.append("/" + txnId.toString());
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("Location", txnURL.toString());
            model.put("headers", customHeaders);
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Transaction start error: " + e.getMessage(), (Throwable)e);
        }
    }
}

