/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.protocol;

import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public abstract class Protocol {
    public static final String CACHE_TIMEOUT_PROPERTY = "rdf4j.server.txn.registry.timeout";
    public static final int DEFAULT_TIMEOUT = 60;
    public static final String VERSION = "10";
    public static final String SUBJECT_PARAM_NAME = "subj";
    public static final String PREDICATE_PARAM_NAME = "pred";
    public static final String OBJECT_PARAM_NAME = "obj";
    public static final String INCLUDE_INFERRED_PARAM_NAME = "infer";
    public static final String CONTEXT_PARAM_NAME = "context";
    public static final String NULL_PARAM_VALUE = "null";
    public static final String GRAPH_PARAM_NAME = "graph";
    public static final String UPDATE_PARAM_NAME = "update";
    public static final String BASEURI_PARAM_NAME = "baseURI";
    public static final String QUERY_PARAM_NAME = "query";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String OFFSET_PARAM_NAME = "offset";
    public static final String QUERY_LANGUAGE_PARAM_NAME = "queryLn";
    public static final String TIMEOUT_PARAM_NAME = "timeout";
    public static final String REMOVE_GRAPH_PARAM_NAME = "remove-graph-uri";
    public static final String INSERT_GRAPH_PARAM_NAME = "insert-graph-uri";
    public static final String USING_GRAPH_PARAM_NAME = "using-graph-uri";
    public static final String USING_NAMED_GRAPH_PARAM_NAME = "using-named-graph-uri";
    public static final String DEFAULT_GRAPH_PARAM_NAME = "default-graph-uri";
    public static final String NAMED_GRAPH_PARAM_NAME = "named-graph-uri";
    public static final String ACCEPT_PARAM_NAME = "Accept";
    public static final String ISOLATION_LEVEL_PARAM_NAME = "isolation-level";
    public static final String ACTION_PARAM_NAME = "action";
    public static final String DISTINCT_PARAM_NAME = "distinct";
    public static final String PROTOCOL = "protocol";
    public static final String CONFIG = "config";
    public static final String REPOSITORIES = "repositories";
    public static final String STATEMENTS = "statements";
    public static final String TRANSACTIONS = "transactions";
    public static final String CONTEXTS = "contexts";
    public static final String NAMESPACES = "namespaces";
    public static final String BINDING_PREFIX = "$";
    public static final String SIZE = "size";
    public static final String TXN_MIME_TYPE = "application/x-rdftransaction";
    public static final String FORM_MIME_TYPE = "application/x-www-form-urlencoded";
    public static final String SPARQL_QUERY_MIME_TYPE = "application/sparql-query";
    public static final String SPARQL_UPDATE_MIME_TYPE = "application/sparql-update";
    public static final String PRESERVE_BNODE_ID_PARAM_NAME = "preserveNodeId";

    private static String getServerDir(String serverLocation) {
        if (serverLocation.endsWith("/")) {
            return serverLocation;
        }
        return serverLocation + "/";
    }

    public static final String getProtocolLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + PROTOCOL;
    }

    public static final String getConfigLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + CONFIG;
    }

    public static final String getRepositoriesLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + REPOSITORIES;
    }

    public static final String getRepositoryLocation(String serverLocation, String repositoryID) {
        return Protocol.getRepositoriesLocation(serverLocation) + "/" + repositoryID;
    }

    public static final String getRepositoryConfigLocation(String repositoryLocation) {
        return repositoryLocation + "/" + CONFIG;
    }

    public static final String getStatementsLocation(String repositoryLocation) {
        return repositoryLocation + "/" + STATEMENTS;
    }

    public static final String getTransactionsLocation(String repositoryLocation) {
        return repositoryLocation + "/" + TRANSACTIONS;
    }

    public static final String getServerLocation(String repositoryLocation) {
        String serverLocation = repositoryLocation.substring(0, repositoryLocation.lastIndexOf(47));
        serverLocation = serverLocation.substring(0, serverLocation.lastIndexOf(47));
        return serverLocation;
    }

    public static final String getRepositoryID(String repositoryLocation) {
        String repositoryID = repositoryLocation.substring(repositoryLocation.lastIndexOf(47) + 1);
        return repositoryID;
    }

    public static final String getContextsLocation(String repositoryLocation) {
        return repositoryLocation + "/" + CONTEXTS;
    }

    public static final String getNamespacesLocation(String repositoryLocation) {
        return repositoryLocation + "/" + NAMESPACES;
    }

    public static final String getNamespacePrefixLocation(String repositoryLocation, String prefix) {
        return Protocol.getNamespacesLocation(repositoryLocation) + "/" + prefix;
    }

    public static final String getSizeLocation(String repositoryLocation) {
        return repositoryLocation + "/" + SIZE;
    }

    public static String encodeValue(Value value) {
        return NTriplesUtil.toNTriplesString((Value)value);
    }

    public static Value decodeValue(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseValue((String)encodedValue, (ValueFactory)valueFactory);
        }
        return null;
    }

    public static Resource decodeResource(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseResource((String)encodedValue, (ValueFactory)valueFactory);
        }
        return null;
    }

    public static IRI decodeURI(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseURI((String)encodedValue, (ValueFactory)valueFactory);
        }
        return null;
    }

    public static String encodeContext(Resource context) {
        if (context == null) {
            return NULL_PARAM_VALUE;
        }
        return Protocol.encodeValue((Value)context);
    }

    public static Resource decodeContext(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue == null) {
            return null;
        }
        if (NULL_PARAM_VALUE.equals(encodedValue)) {
            return null;
        }
        Resource context = Protocol.decodeResource(encodedValue, valueFactory);
        if (context instanceof Triple) {
            throw new IllegalArgumentException("Invalid context value: " + encodedValue);
        }
        return context;
    }

    public static String[] encodeContexts(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        String[] result = new String[contexts.length];
        for (int index = 0; index < contexts.length; ++index) {
            result[index] = Protocol.encodeContext(contexts[index]);
        }
        return result;
    }

    public static Resource[] decodeContexts(String[] encodedValues, ValueFactory valueFactory) {
        Resource[] result;
        if (encodedValues == null) {
            result = new Resource[]{};
        } else {
            result = new Resource[encodedValues.length];
            for (int index = 0; index < encodedValues.length; ++index) {
                result[index] = Protocol.decodeContext(encodedValues[index], valueFactory);
            }
        }
        return result;
    }

    @Deprecated
    public static enum TIMEOUT {
        CACHE;

        public static final String CACHE_PROPERTY = "rdf4j.server.txn.registry.timeout";
        public static final int DEFAULT = 60;
    }

    public static enum Action {
        ADD,
        DELETE,
        GET,
        SIZE,
        QUERY,
        UPDATE,
        PING,
        COMMIT,
        ROLLBACK;

    }
}

