/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.protocol.error;

import java.util.HashMap;
import java.util.Map;

public class ErrorType {
    private static final Map<String, ErrorType> registry = new HashMap<String, ErrorType>();
    public static final ErrorType MALFORMED_QUERY = ErrorType.register("MALFORMED QUERY");
    public static final ErrorType MALFORMED_DATA = ErrorType.register("MALFORMED DATA");
    public static final ErrorType UNSUPPORTED_QUERY_LANGUAGE = ErrorType.register("UNSUPPORTED QUERY LANGUAGE");
    public static final ErrorType UNSUPPORTED_FILE_FORMAT = ErrorType.register("UNSUPPORTED FILE FORMAT");
    private String label;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ErrorType register(String label) {
        Map<String, ErrorType> map = registry;
        synchronized (map) {
            ErrorType errorType = registry.get(label);
            if (errorType == null) {
                errorType = new ErrorType(label);
                registry.put(label, errorType);
            }
            return errorType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorType forLabel(String label) {
        Map<String, ErrorType> map = registry;
        synchronized (map) {
            return registry.get(label);
        }
    }

    private ErrorType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object other) {
        if (other instanceof ErrorType) {
            return ((ErrorType)other).getLabel().equals(this.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        return this.label;
    }
}

