/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;

public class SharedHttpClientSessionManager
implements HttpClientSessionManager,
HttpClientDependent {
    private volatile HttpClient httpClient;
    private volatile CloseableHttpClient dependentClient;
    private final ExecutorService executor;
    private volatile HttpClientBuilder httpClientBuilder;

    public SharedHttpClientSessionManager() {
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("rdf4j-sesameclientimpl-%d").build());
    }

    public SharedHttpClientSessionManager(CloseableHttpClient dependentClient, ExecutorService dependentExecutorService) {
        this.dependentClient = Objects.requireNonNull(dependentClient, "HTTP client was null");
        this.httpClient = this.dependentClient;
        this.executor = Objects.requireNonNull(dependentExecutorService, "Executor service was null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        HttpClient result = this.httpClient;
        if (result == null) {
            SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
            synchronized (sharedHttpClientSessionManager) {
                result = this.httpClient;
                if (result == null) {
                    this.dependentClient = this.createHttpClient();
                    this.httpClient = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
        synchronized (sharedHttpClientSessionManager) {
            this.httpClient = Objects.requireNonNull(httpClient, "HTTP Client cannot be null");
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder nextHttpClientBuilder = this.httpClientBuilder;
        if (nextHttpClientBuilder != null) {
            return nextHttpClientBuilder.build();
        }
        return HttpClients.createSystem();
    }

    @Override
    public SPARQLProtocolSession createSPARQLProtocolSession(String queryEndpointUrl, String updateEndpointUrl) {
        SPARQLProtocolSession session = new SPARQLProtocolSession(this.getHttpClient(), this.executor);
        session.setQueryURL(queryEndpointUrl);
        session.setUpdateURL(updateEndpointUrl);
        return session;
    }

    @Override
    public RDF4JProtocolSession createRDF4JProtocolSession(String serverURL) {
        RDF4JProtocolSession session = new RDF4JProtocolSession(this.getHttpClient(), this.executor);
        session.setServerURL(serverURL);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
        finally {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    @Deprecated
    public void initialize() {
    }
}

