/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.examples.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class Example16SPARQLConstructQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        SailRepository db = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection conn = db.getConnection();){
            String filename = "example-data-artists.ttl";
            try (InputStream input = Example16SPARQLConstructQuery.class.getResourceAsStream("/" + filename);){
                conn.add(input, "", RDFFormat.TURTLE, new Resource[0]);
            }
            Object queryString = "PREFIX ex: <http://example.org/> \n";
            queryString = (String)queryString + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
            queryString = (String)queryString + "CONSTRUCT \n";
            queryString = (String)queryString + "WHERE { \n";
            queryString = (String)queryString + "    ?s a ex:Artist; \n";
            queryString = (String)queryString + "       foaf:firstName ?n .";
            queryString = (String)queryString + "}";
            GraphQuery query = conn.prepareGraphQuery((String)queryString);
            RDFWriter turtleWriter = Rio.createWriter((RDFFormat)RDFFormat.TURTLE, (OutputStream)System.out);
            query.evaluate((RDFHandler)turtleWriter);
            try (GraphQueryResult result = query.evaluate();){
                while (result.hasNext()) {
                    Statement st = (Statement)result.next();
                    System.out.println(st);
                }
            }
        }
        finally {
            db.shutDown();
        }
    }
}

