/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.examples.repository;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class Example15SimpleSPARQLQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        SailRepository db = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection conn = db.getConnection();){
            String filename = "example-data-artists.ttl";
            try (InputStream input = Example15SimpleSPARQLQuery.class.getResourceAsStream("/" + filename);){
                conn.add(input, "", RDFFormat.TURTLE, new Resource[0]);
            }
            Object queryString = "PREFIX ex: <http://example.org/> \n";
            queryString = (String)queryString + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
            queryString = (String)queryString + "SELECT ?s ?n \n";
            queryString = (String)queryString + "WHERE { \n";
            queryString = (String)queryString + "    ?s a ex:Artist; \n";
            queryString = (String)queryString + "       foaf:firstName ?n .";
            queryString = (String)queryString + "}";
            TupleQuery query = conn.prepareTupleQuery((String)queryString);
            try (TupleQueryResult result = query.evaluate();){
                for (BindingSet solution : result) {
                    System.out.println("?s = " + String.valueOf(solution.getValue("s")));
                    System.out.println("?n = " + String.valueOf(solution.getValue("n")));
                }
            }
        }
        finally {
            db.shutDown();
        }
    }
}

