/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.examples.model;

import java.time.LocalDate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.ModelBuilder;

public class Example03LiteralDatatypes {
    public static void main(String[] args) {
        ModelBuilder builder = new ModelBuilder();
        Model model = builder.setNamespace("ex", "http://example.org/").subject("ex:PotatoEaters").add("ex:creationDate", (Object)LocalDate.parse("1885-04-01")).add("ex:peopleDepicted", (Object)5).build();
        for (Statement st : model) {
            IRI property = st.getPredicate();
            Value value = st.getObject();
            if (!(value instanceof Literal)) continue;
            Literal literal = (Literal)value;
            System.out.println("datatype: " + String.valueOf(literal.getDatatype()));
            if (property.getLocalName().equals("peopleDepicted")) {
                int peopleDepicted = literal.intValue();
                System.out.println(peopleDepicted + " people are depicted in this painting");
            } else if (property.getLocalName().equals("creationDate")) {
                LocalDate date = LocalDate.from(literal.temporalAccessorValue());
                System.out.println("The painting was created on " + String.valueOf(date));
            }
            System.out.println("Lexical value: '" + literal.getLabel() + "'");
        }
    }
}

