/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.examples.function;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class ExistingPalindromeFunction
implements Function {
    public static final String NAMESPACE = "http://example.org/custom-function/";

    public String getURI() {
        return "http://example.org/custom-function/existingPalindrome";
    }

    public Value evaluate(TripleSource tripleSource, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("palindrome function requiresexactly 1 argument, got " + args.length);
        }
        Value arg = args[0];
        if (!(arg instanceof Literal)) {
            throw new ValueExprEvaluationException("invalid argument (literal expected): " + String.valueOf(arg));
        }
        String label = ((Literal)arg).getLabel();
        Object inverted = "";
        for (int i = label.length() - 1; i >= 0; --i) {
            inverted = (String)inverted + label.charAt(i);
        }
        boolean palindrome = ((String)inverted).equalsIgnoreCase(label);
        boolean existing = !QueryResults.asList((CloseableIteration)tripleSource.getStatements(null, RDFS.LABEL, (Value)((Literal)arg), new Resource[0])).isEmpty();
        return tripleSource.getValueFactory().createLiteral(palindrome && existing);
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        throw new UnsupportedOperationException();
    }
}

