/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class SmartImportRootWizardPage
extends WizardPage {
    static final String IMPORTED_SOURCES = String.valueOf(SmartImportRootWizardPage.class.getName()) + ".knownSources";
    private File selection;
    private boolean detectNestedProjects = true;
    private boolean configureProjects = true;
    private Set<IWorkingSet> workingSets;
    private ControlDecoration rootDirectoryTextDecorator;
    private WorkingSetConfigurationBlock workingSetsBlock;
    private Combo rootDirectoryText;
    private CheckboxTreeViewer tree;
    private Set<File> alreadyExistingProjects;
    private Set<File> notAlreadyExistingProjects;
    private Label selectionSummary;
    protected Map<File, List<ProjectConfigurator>> potentialProjects = Collections.emptyMap();

    public SmartImportRootWizardPage(SmartImportWizard wizard, File initialSelection, Set<IWorkingSet> initialWorkingSets) {
        super(SmartImportRootWizardPage.class.getName());
        this.selection = initialSelection;
        this.workingSets = initialWorkingSets;
        if (this.workingSets == null) {
            this.workingSets = new HashSet<IWorkingSet>();
        }
        this.setWizard((IWizard)wizard);
    }

    public void setWizard(IWizard easymportWizard) {
        Assert.isTrue((boolean)(easymportWizard instanceof SmartImportWizard));
        super.setWizard(easymportWizard);
    }

    public SmartImportWizard getWizard() {
        return (SmartImportWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        this.setTitle(DataTransferMessages.SmartImportWizardPage_importProjectsInFolderTitle);
        this.setDescription(DataTransferMessages.SmartImportWizardPage_importProjectsInFolderDescription);
        this.initializeDialogUnits((Control)parent);
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(4, false));
        this.createInputSelectionOptions(res);
        Composite proposalParent = new Composite(res, 0);
        proposalParent.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        proposalParent.setLayout((Layout)new FillLayout());
        this.createProposalsGroup(proposalParent);
        this.createConfigurationOptions(res);
        Group workingSetsGroup = new Group(res, 0);
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        layoutData.verticalIndent = 20;
        workingSetsGroup.setLayoutData((Object)layoutData);
        workingSetsGroup.setLayout((Layout)new GridLayout(1, false));
        workingSetsGroup.setText(DataTransferMessages.SmartImportWizardPage_workingSets);
        this.workingSetsBlock = new WorkingSetConfigurationBlock(this.getDialogSettings(), new String[]{"org.eclipse.ui.resourceWorkingSetPage"});
        if (this.workingSets != null) {
            this.workingSetsBlock.setWorkingSets(this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]));
        }
        this.workingSetsBlock.createContent((Composite)workingSetsGroup);
        if (this.selection != null) {
            this.rootDirectoryText.setText(this.selection.getAbsolutePath());
            this.validatePage();
        }
        this.setControl((Control)res);
    }

    private void createInputSelectionOptions(Composite res) {
        Label rootDirectoryLabel = new Label(res, 0);
        rootDirectoryLabel.setText(DataTransferMessages.SmartImportWizardPage_selectRootDirectory);
        this.rootDirectoryText = new Combo(res, 2048);
        String[] knownSources = this.getWizard().getDialogSettings().getArray(IMPORTED_SOURCES);
        if (knownSources != null) {
            this.rootDirectoryText.setItems(knownSources);
        }
        GridData rootDirectoryTextLayoutData = new GridData(4, 0x1000000, true, false);
        this.rootDirectoryText.setLayoutData((Object)rootDirectoryTextLayoutData);
        this.rootDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SmartImportRootWizardPage.this.selection = new File(((Combo)e.widget).getText());
                if (SmartImportWizard.isValidArchive(SmartImportRootWizardPage.this.selection)) {
                    if (SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection).isDirectory()) {
                        if (MessageDialog.openConfirm((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_overwriteArchiveDirectory_title, (String)NLS.bind((String)DataTransferMessages.SmartImportWizardPage_overwriteArchiveDirectory_message, (Object)SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection)))) {
                            this.expandSelectedArchive();
                        }
                    } else {
                        this.expandSelectedArchive();
                    }
                }
                SmartImportRootWizardPage.this.refreshProposals();
            }

            private void expandSelectedArchive() {
                try {
                    SmartImportRootWizardPage.this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SmartImportRootWizardPage.this.getWizard().expandArchive(SmartImportRootWizardPage.this.selection, monitor);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    MessageDialog.openWarning((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_incompleteExpand_title, (String)NLS.bind((String)DataTransferMessages.SmartImportWizardPage_incompleteExpand_title, (Object)SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection)));
                }
            }
        });
        this.rootDirectoryTextDecorator = new ControlDecoration((Control)this.rootDirectoryText, 16512);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        rootDirectoryTextLayoutData.horizontalIndent += errorImage.getBounds().width;
        this.rootDirectoryTextDecorator.setImage(errorImage);
        this.rootDirectoryTextDecorator.setDescriptionText(DataTransferMessages.SmartImportWizardPage_incorrectRootDirectory);
        this.rootDirectoryTextDecorator.hide();
        Button directoryButton = new Button(res, 8);
        directoryButton.setText(DataTransferMessages.SmartImportWizardPage_browse);
        this.setButtonLayoutData(directoryButton);
        directoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory;
                DirectoryDialog dialog = new DirectoryDialog(SmartImportRootWizardPage.this.getShell());
                dialog.setText(DataTransferMessages.SmartImportWizardPage_browseForFolder);
                dialog.setMessage(DataTransferMessages.SmartImportWizardPage_selectFolderOrArchiveToImport);
                if (SmartImportRootWizardPage.this.rootDirectoryText.getText() != null) {
                    File current = new File(SmartImportRootWizardPage.this.rootDirectoryText.getText());
                    if (current.isDirectory()) {
                        dialog.setFilterPath(current.getAbsolutePath());
                    } else if (current.isFile()) {
                        dialog.setFilterPath(current.getParentFile().getAbsolutePath());
                    }
                }
                if (dialog.getFilterPath() == null) {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                }
                if ((directory = dialog.open()) != null) {
                    SmartImportRootWizardPage.this.rootDirectoryText.setText(directory);
                }
            }
        });
        Button browseArchiveButton = new Button(res, 8);
        browseArchiveButton.setText(DataTransferMessages.SmartImportWizardPage_selectArchiveButton);
        this.setButtonLayoutData(browseArchiveButton);
        browseArchiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String archive;
                FileDialog dialog = new FileDialog(SmartImportRootWizardPage.this.getShell());
                dialog.setText(DataTransferMessages.SmartImportWizardPage_selectArchiveTitle);
                dialog.setFilterExtensions(new String[]{"*.zip;*.tar;*.tar.gz"});
                dialog.setFilterNames(new String[]{DataTransferMessages.SmartImportWizardPage_allSupportedArchives});
                if (SmartImportRootWizardPage.this.rootDirectoryText.getText() != null) {
                    File current = new File(SmartImportRootWizardPage.this.rootDirectoryText.getText());
                    if (current.isDirectory()) {
                        dialog.setFilterPath(current.getAbsolutePath());
                    } else if (current.isFile()) {
                        dialog.setFilterPath(current.getParentFile().getAbsolutePath());
                        dialog.setFileName(current.getName());
                    }
                }
                if (dialog.getFilterPath() == null) {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                }
                if ((archive = dialog.open()) != null) {
                    SmartImportRootWizardPage.this.rootDirectoryText.setText(archive);
                }
            }
        });
    }

    private void createConfigurationOptions(Composite res) {
        Link showDetectorsLink = new Link(res, 0);
        showDetectorsLink.setText(DataTransferMessages.SmartImportWizardPage_showAvailableDetectors);
        showDetectorsLink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        showDetectorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder message = new StringBuilder();
                message.append(DataTransferMessages.SmartImportWizardPage_availableDetectors_description);
                message.append('\n');
                message.append('\n');
                ArrayList<String> extensionsLabels = new ArrayList<String>(ProjectConfiguratorExtensionManager.getAllExtensionLabels());
                Collections.sort(extensionsLabels);
                for (String extensionLabel : extensionsLabels) {
                    message.append("* ");
                    message.append(extensionLabel);
                    message.append('\n');
                }
                MessageDialog.openInformation((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_availableDetectors_title, (String)message.toString());
            }
        });
        final Button detectNestedProjectsCheckbox = new Button(res, 32);
        detectNestedProjectsCheckbox.setText(DataTransferMessages.SmartImportWizardPage_detectNestedProjects);
        detectNestedProjectsCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        detectNestedProjectsCheckbox.setSelection(this.detectNestedProjects);
        detectNestedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.detectNestedProjects = detectNestedProjectsCheckbox.getSelection();
                SmartImportRootWizardPage.this.refreshProposals();
            }
        });
        final Button configureProjectsCheckbox = new Button(res, 32);
        configureProjectsCheckbox.setText(DataTransferMessages.SmartImportWizardPage_configureProjects);
        configureProjectsCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        configureProjectsCheckbox.setSelection(this.configureProjects);
        configureProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.configureProjects = configureProjectsCheckbox.getSelection();
                SmartImportRootWizardPage.this.refreshProposals();
            }
        });
    }

    private void createProposalsGroup(Composite parent) {
        Composite res = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(res);
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filterTree = new FilteredTree(res, 2080, patternFilter, true){

            public CheckboxTreeViewer doCreateTreeViewer(Composite treeParent, int style) {
                return new CheckboxTreeViewer(treeParent, style);
            }
        };
        this.tree = (CheckboxTreeViewer)filterTree.getViewer();
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.heightHint = 90;
        this.tree.getControl().setLayoutData((Object)treeGridData);
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Map potentialProjects = (Map)inputElement;
                return potentialProjects.keySet().toArray(new File[potentialProjects.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.tree.setComparator(new ViewerComparator(){

            public int compare(Viewer v, Object o1, Object o2) {
                return ((File)o1).getAbsolutePath().compareTo(((File)o2).getAbsolutePath());
            }
        });
        this.tree.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return SmartImportRootWizardPage.this.getWizard().getImportJob() == null || SmartImportRootWizardPage.this.getWizard().getImportJob().getDirectoriesToImport() == null || SmartImportRootWizardPage.this.getWizard().getImportJob().getDirectoriesToImport().contains(element);
            }
        });
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SmartImportRootWizardPage.this.alreadyExistingProjects.contains(event.getElement())) {
                    SmartImportRootWizardPage.this.tree.setChecked(event.getElement(), false);
                } else {
                    SmartImportRootWizardPage.this.proposalsSelectionChanged();
                }
            }
        });
        this.tree.getTree().setHeaderVisible(true);
        TreeViewerColumn pathColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        pathColumn.setLabelProvider((CellLabelProvider)new FolderForProjectsLabelProvider());
        this.tree.getTree().getColumn(0).setText(DataTransferMessages.SmartImportProposals_folder);
        this.tree.getTree().getColumn(0).setWidth(400);
        TreeViewerColumn projectTypeColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        projectTypeColumn.setLabelProvider((CellLabelProvider)new ProjectConfiguratorLabelProvider());
        this.tree.getTree().getColumn(1).setText(DataTransferMessages.SmartImportProposals_importAs);
        this.tree.getTree().getColumn(1).setWidth(250);
        Composite selectionButtonsGroup = new Composite(res, 0);
        GridLayoutFactory.fillDefaults().applyTo(selectionButtonsGroup);
        selectionButtonsGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        Button selectAllButton = new Button(selectionButtonsGroup, 8);
        this.setButtonLayoutData(selectAllButton);
        selectAllButton.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.tree.setCheckedElements(SmartImportRootWizardPage.this.notAlreadyExistingProjects.toArray());
                SmartImportRootWizardPage.this.proposalsSelectionChanged();
            }
        });
        Button deselectAllButton = new Button(selectionButtonsGroup, 8);
        this.setButtonLayoutData(deselectAllButton);
        deselectAllButton.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.tree.setCheckedElements(new Object[0]);
                SmartImportRootWizardPage.this.proposalsSelectionChanged();
            }
        });
        this.selectionSummary = new Label(selectionButtonsGroup, 0);
        this.selectionSummary.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
        this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)0, (Object)0));
        Button hideProjectsAlreadyInWorkspace = new Button(selectionButtonsGroup, 32);
        hideProjectsAlreadyInWorkspace.setText(DataTransferMessages.SmartImportProposals_hideExistingProjects);
        hideProjectsAlreadyInWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){
            final ViewerFilter existingProjectsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !SmartImportRootWizardPage.this.alreadyExistingProjects.contains(element);
                }
            };

            public void widgetSelected(SelectionEvent e) {
                ViewerFilter[] currentFilters = SmartImportRootWizardPage.this.tree.getFilters();
                ViewerFilter[] newFilters = null;
                if (((Button)e.widget).getSelection()) {
                    newFilters = new ViewerFilter[currentFilters.length + 1];
                    System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                    newFilters[newFilters.length - 1] = this.existingProjectsFilter;
                } else {
                    ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(currentFilters.length > 0 ? currentFilters.length - 1 : 0);
                    ViewerFilter[] viewerFilterArray = currentFilters;
                    int n = currentFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter filter = viewerFilterArray[n2];
                        if (filter != this.existingProjectsFilter) {
                            filters.add(filter);
                        }
                        ++n2;
                    }
                    newFilters = filters.toArray(new ViewerFilter[filters.size()]);
                }
                SmartImportRootWizardPage.this.tree.setFilters(newFilters);
            }
        });
        this.tree.setInput(Collections.emptyMap());
    }

    protected void validatePage() {
        if (!this.isPageComplete()) {
            this.rootDirectoryTextDecorator.show();
            this.setErrorMessage(this.rootDirectoryTextDecorator.getDescriptionText());
        } else {
            this.rootDirectoryTextDecorator.hide();
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.sourceIsValid() && this.getWizard().getImportJob() != null && this.tree.getCheckedElements().length > 0;
    }

    private boolean sourceIsValid() {
        return this.selection != null && (this.selection.isDirectory() || SmartImportWizard.isValidArchive(this.selection));
    }

    public File getSelectedRoot() {
        return this.selection;
    }

    public void setInitialImportRoot(File directoryOrArchive) {
        this.selection = directoryOrArchive;
        this.rootDirectoryText.setText(directoryOrArchive.getAbsolutePath());
    }

    public Set<IWorkingSet> getSelectedWorkingSets() {
        this.workingSets.clear();
        Runnable workingSetsRetriever = new Runnable(){

            @Override
            public void run() {
                IWorkingSet[] iWorkingSetArray = SmartImportRootWizardPage.this.workingSetsBlock.getSelectedWorkingSets();
                int n = iWorkingSetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkingSet workingSet = iWorkingSetArray[n2];
                    SmartImportRootWizardPage.this.workingSets.add(workingSet);
                    ++n2;
                }
            }
        };
        if (Display.getCurrent() == null) {
            this.getContainer().getShell().getDisplay().syncExec(workingSetsRetriever);
        } else {
            workingSetsRetriever.run();
        }
        return this.workingSets;
    }

    private void proposalsSelectionChanged() {
        if (this.getWizard().getImportJob() != null) {
            Map input = (Map)this.tree.getInput();
            if (input.size() == 1 && ((Collection)input.values().iterator().next()).isEmpty()) {
                this.getWizard().getImportJob().setDirectoriesToImport(null);
                this.getWizard().getImportJob().setExcludedDirectories(null);
                this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)0, (Object)this.tree.getCheckedElements().length));
            } else {
                Object[] selected = this.tree.getCheckedElements();
                HashSet<File> excludedDirectories = new HashSet<File>(((Map)this.tree.getInput()).keySet());
                HashSet<File> selectedProjects = new HashSet<File>();
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    File directory = (File)item;
                    excludedDirectories.remove(directory);
                    selectedProjects.add(directory);
                    ++n2;
                }
                this.getWizard().getImportJob().setDirectoriesToImport(selectedProjects);
                this.getWizard().getImportJob().setExcludedDirectories(excludedDirectories);
                this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)selectedProjects.size(), (Object)this.potentialProjects.size()));
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isDetectNestedProject() {
        return this.detectNestedProjects;
    }

    public boolean isConfigureProjects() {
        return this.configureProjects;
    }

    private void refreshProposals() {
        try {
            if (this.sourceIsValid()) {
                Point initialSelection = this.rootDirectoryText.getSelection();
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SmartImportRootWizardPage.this.potentialProjects = SmartImportRootWizardPage.this.getWizard().getImportJob().getImportProposals(monitor);
                        if (!SmartImportRootWizardPage.this.potentialProjects.containsKey(SmartImportRootWizardPage.this.getWizard().getImportJob().getRoot())) {
                            SmartImportRootWizardPage.this.potentialProjects.put(SmartImportRootWizardPage.this.getWizard().getImportJob().getRoot(), Collections.emptyList());
                        }
                        SmartImportRootWizardPage.this.notAlreadyExistingProjects = new HashSet<File>(SmartImportRootWizardPage.this.potentialProjects.keySet());
                        SmartImportRootWizardPage.this.alreadyExistingProjects = new HashSet();
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            IPath location = project.getLocation();
                            if (location != null) {
                                SmartImportRootWizardPage.this.notAlreadyExistingProjects.remove(location.toFile());
                                SmartImportRootWizardPage.this.alreadyExistingProjects.add(location.toFile());
                            }
                            ++n2;
                        }
                    }
                });
                this.rootDirectoryText.setSelection(initialSelection);
            } else {
                this.potentialProjects = Collections.emptyMap();
                this.notAlreadyExistingProjects = Collections.emptySet();
                this.alreadyExistingProjects = Collections.emptySet();
            }
            this.tree.setInput(this.potentialProjects);
            this.tree.setCheckedElements(this.notAlreadyExistingProjects.toArray());
        }
        catch (InvocationTargetException ite) {
            this.selection = null;
            Status status = new Status(4, "org.eclipse.ui.ide", DataTransferMessages.SmartImportWizardPage_scanProjectsFailed, ite.getCause());
            StatusManager.getManager().handle((IStatus)status, 3);
        }
        catch (InterruptedException interruptedException) {}
        this.proposalsSelectionChanged();
        this.validatePage();
    }

    private class FolderForProjectsLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private FolderForProjectsLabelProvider() {
        }

        public String getText(Object o) {
            Path relative;
            Path rootPath;
            File file = (File)o;
            Path filePath = file.toPath();
            if (filePath.startsWith(rootPath = SmartImportRootWizardPage.this.getWizard().getImportJob().getRoot().toPath()) && rootPath.getParent() != null && (relative = rootPath.getParent().relativize(filePath)).getNameCount() > 0) {
                return relative.toString();
            }
            return filePath.toString();
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (SmartImportRootWizardPage.this.alreadyExistingProjects.contains(o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }

    private class ProjectConfiguratorLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private ProjectConfiguratorLabelProvider() {
        }

        public String getText(Object o) {
            File file = (File)o;
            if (SmartImportRootWizardPage.this.alreadyExistingProjects.contains(file)) {
                return DataTransferMessages.SmartImportProposals_alreadyImportedAsProject_title;
            }
            List<ProjectConfigurator> configurators = SmartImportRootWizardPage.this.potentialProjects.get(file);
            if (configurators.isEmpty()) {
                return "";
            }
            return ProjectConfiguratorExtensionManager.getLabel(configurators.get(0));
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (SmartImportRootWizardPage.this.alreadyExistingProjects.contains(o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }
}

