/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.memory;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.memory.MemoryFileSystem;
import org.eclipse.core.internal.filesystem.memory.MemoryTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class MemoryFileStore
extends FileStore {
    private static final MemoryTree TREE = MemoryTree.TREE;
    private final IPath path;

    public MemoryFileStore(IPath path) {
        this.path = path.setDevice(null);
    }

    public String[] childNames(int options, IProgressMonitor monitor) {
        String[] names = TREE.childNames(this.path);
        return names == null ? EMPTY_STRING_ARRAY : names;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        TREE.delete(this.path);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        return TREE.fetchInfo(this.path);
    }

    public IFileStore getChild(String name) {
        return new MemoryFileStore(this.path.append(name));
    }

    public String getName() {
        String name = this.path.lastSegment();
        return name == null ? "" : name;
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() == 0) {
            return null;
        }
        return new MemoryFileStore(this.path.removeLastSegments(1));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        TREE.mkdir(this.path, (options & 4) == 0);
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return TREE.openInputStream(this.path);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return TREE.openOutputStream(this.path, options);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        TREE.putInfo(this.path, info, options);
    }

    public URI toURI() {
        return MemoryFileSystem.toURI(this.path);
    }
}

