/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.memory.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class MemoryTree {
    static final int[] ALL_ATTRIBUTES = new int[]{8, 4, 16, 2};
    public static final MemoryTree TREE = new MemoryTree();
    static final byte[] EMPTY_CONTENTS = new byte[0];
    private static final String ROOT_NAME = "<root>";
    private Node root = new DirNode(null, "<root>");

    private MemoryTree() {
    }

    public String[] childNames(IPath path) {
        Node node = this.findNode(path);
        if (node == null || node.isFile()) {
            return null;
        }
        return ((DirNode)node).childNames();
    }

    public void delete(IPath path) {
        if (path.segmentCount() == 0) {
            return;
        }
        Node parent = this.findNode(path.removeLastSegments(1));
        if (parent == null || parent.isFile()) {
            return;
        }
        ((DirNode)parent).remove(path.lastSegment());
    }

    public void deleteAll() {
        this.root = new DirNode(null, ROOT_NAME);
    }

    public synchronized IFileInfo fetchInfo(IPath path) {
        Node node = this.findNode(path);
        if (node == null) {
            return new FileInfo(path.lastSegment());
        }
        return node.getInfo(true);
    }

    private Node findNode(IPath path) {
        Node current = this.root;
        int i = 0;
        int imax = path.segmentCount();
        while (i < imax) {
            if (current == null || current.isFile()) {
                return null;
            }
            current = ((DirNode)current).getChild(path.segment(i));
            ++i;
        }
        return current;
    }

    public Node mkdir(IPath path, boolean deep) throws CoreException {
        Node dir = this.findNode(path);
        if (dir != null) {
            if (dir.isFile()) {
                Policy.error("A file exists with this name: " + String.valueOf(path));
            }
            return dir;
        }
        IPath parentPath = path.removeLastSegments(1);
        Node parent = this.findNode(parentPath);
        if (parent != null) {
            if (parent.isFile()) {
                Policy.error("Parent is a file: " + String.valueOf(path));
            }
        } else {
            if (!deep) {
                Policy.error("Parent does not exist: " + String.valueOf(parentPath));
            }
            parent = this.mkdir(parentPath, deep);
        }
        return new DirNode(parent, path.lastSegment());
    }

    public InputStream openInputStream(IPath path) throws CoreException {
        Node node = this.findNode(path);
        if (node == null) {
            Policy.error("File not found: " + String.valueOf(path));
        }
        if (!node.isFile()) {
            Policy.error("Cannot open stream on directory: " + String.valueOf(path));
        }
        return ((FileNode)node).openInputStream();
    }

    public OutputStream openOutputStream(IPath path, int options) throws CoreException {
        Node node = this.findNode(path);
        if (node instanceof DirNode) {
            Policy.error("Could not create file: " + String.valueOf(path));
        }
        if (node instanceof FileNode) {
            return ((FileNode)node).openOutputStream(options);
        }
        Node parent = this.findNode(path.removeLastSegments(1));
        if (!(parent instanceof DirNode)) {
            Policy.error("Could not create file: " + String.valueOf(path));
        }
        node = new FileNode(parent, path.lastSegment());
        return ((FileNode)node).openOutputStream(options);
    }

    public void putInfo(IPath path, IFileInfo info, int options) throws CoreException {
        Node node = this.findNode(path);
        if (node == null) {
            Policy.error("File not found: " + String.valueOf(path));
        }
        node.putInfo(info, options);
    }

    static class DirNode
    extends Node {
        private final ArrayList<Node> children = new ArrayList();

        DirNode(Node parent, String name) {
            super(parent, name);
        }

        void add(Node child) {
            this.children.add(child);
        }

        public String[] childNames() {
            String[] names = new String[this.children.size()];
            int i = 0;
            int imax = this.children.size();
            while (i < imax) {
                Node child = this.children.get(i);
                names[i] = child.getInfo(false).getName();
                ++i;
            }
            return names;
        }

        Node getChild(String name) {
            int i = 0;
            int imax = this.children.size();
            while (i < imax) {
                Node child = this.children.get(i);
                if (child.getInfo(false).getName().equals(name)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        @Override
        protected void initializeInfo(FileInfo fileInfo) {
            super.initializeInfo(fileInfo);
            fileInfo.setDirectory(true);
        }

        @Override
        boolean isFile() {
            return false;
        }

        void remove(String name) {
            Node child = this.getChild(name);
            if (child != null) {
                this.children.remove((Object)child);
            }
        }

        @Override
        public String toString() {
            return super.toString() + " " + String.valueOf(this.children);
        }
    }

    static class FileNode
    extends Node {
        byte[] contents = EMPTY_CONTENTS;

        FileNode(Node parent, String name) {
            super(parent, name);
        }

        @Override
        boolean isFile() {
            return true;
        }

        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.contents);
        }

        public OutputStream openOutputStream(final int options) {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    this.setContents(this.toByteArray(), options);
                }
            };
        }

        protected void setContents(byte[] bytes, int options) {
            if ((options & 1) != 0) {
                byte[] oldContents = this.contents;
                byte[] newContents = new byte[oldContents.length + bytes.length];
                System.arraycopy(oldContents, 0, newContents, 0, oldContents.length);
                System.arraycopy(bytes, 0, newContents, oldContents.length, bytes.length);
                this.contents = newContents;
            } else {
                this.contents = bytes;
            }
            this.info.setLastModified(System.currentTimeMillis());
            ((FileInfo)this.info).setLength((long)bytes.length);
        }
    }

    static abstract class Node
    extends PlatformObject {
        protected IFileInfo info;

        Node(Node parent, String name) {
            if (parent != null) {
                ((DirNode)parent).add(this);
            }
            FileInfo fileInfo = new FileInfo(name);
            this.initializeInfo(fileInfo);
            this.info = fileInfo;
        }

        IFileInfo getInfo(boolean copy) {
            return copy ? ((FileInfo)this.info).clone() : this.info;
        }

        protected void initializeInfo(FileInfo fileInfo) {
            fileInfo.setExists(true);
            fileInfo.setLastModified(System.currentTimeMillis());
        }

        abstract boolean isFile();

        void putInfo(IFileInfo newInfo, int options) {
            if ((options & 0x400) != 0) {
                int i = 0;
                while (i < ALL_ATTRIBUTES.length) {
                    this.info.setAttribute(ALL_ATTRIBUTES[i], newInfo.getAttribute(ALL_ATTRIBUTES[i]));
                    ++i;
                }
            }
            if ((options & 0x800) != 0) {
                this.info.setLastModified(newInfo.getLastModified());
            }
        }

        public String toString() {
            return this.info.getName();
        }
    }
}

