/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ZipFileStore
extends FileStore {
    private IPath path;
    private IFileStore rootStore;

    public ZipFileStore(IFileStore rootStore, IPath path) {
        this.rootStore = rootStore;
        this.path = path.makeRelative();
    }

    private ZipEntry[] childEntries(IProgressMonitor monitor) throws CoreException {
        HashMap<String, ZipEntry> entries = new HashMap<String, ZipEntry>();
        String myName = this.path.toString();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipInputStream in = new ZipInputStream(this.rootStore.openInputStream(0, monitor));){
                ZipEntry current;
                while ((current = in.getNextEntry()) != null) {
                    String dirName;
                    String currentPath = current.getName();
                    if (this.isParent(myName, currentPath)) {
                        entries.put(currentPath, current);
                        continue;
                    }
                    if (!this.isAncestor(myName, currentPath)) continue;
                    int myNameLength = myName.length() + 1;
                    int nameEnd = currentPath.indexOf(47, myNameLength);
                    String string = dirName = nameEnd == -1 ? currentPath : currentPath.substring(0, nameEnd + 1);
                    if (entries.containsKey(dirName)) continue;
                    entries.put(dirName, new ZipEntry(dirName));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Could not read file: " + this.rootStore.toString()), (Throwable)e));
        }
        return entries.values().toArray(new ZipEntry[entries.size()]);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        ZipEntry[] entries = this.childEntries(monitor);
        int entryCount = entries.length;
        IFileInfo[] infos = new IFileInfo[entryCount];
        int i = 0;
        while (i < entryCount) {
            infos[i] = this.convertZipEntryToFileInfo(entries[i]);
            ++i;
        }
        return infos;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        ZipEntry[] entries = this.childEntries(monitor);
        int entryCount = entries.length;
        String[] names = new String[entryCount];
        int i = 0;
        while (i < entryCount) {
            names[i] = this.computeName(entries[i]);
            ++i;
        }
        return names;
    }

    private String computeName(ZipEntry entry) {
        int end;
        String name = entry.getName();
        if (name.charAt(end = name.length() - 1) == '/') {
            --end;
        }
        return name.substring(name.lastIndexOf(47, end) + 1, end + 1);
    }

    private IFileInfo convertZipEntryToFileInfo(ZipEntry entry) {
        FileInfo info = new FileInfo(this.computeName(entry));
        info.setLastModified(entry.getTime());
        info.setExists(true);
        info.setDirectory(entry.isDirectory());
        info.setLength(entry.getSize());
        return info;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream in = new ZipInputStream(this.rootStore.openInputStream(0, monitor));){
                ZipEntry current;
                String myPath = this.path.toString();
                while ((current = in.getNextEntry()) != null) {
                    String currentPath = current.getName();
                    if (myPath.equals(currentPath)) {
                        return this.convertZipEntryToFileInfo(current);
                    }
                    if (!this.isAncestor(myPath, currentPath)) continue;
                    return this.createDirectoryInfo(this.getName());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Could not read file: " + this.rootStore.toString()), (Throwable)e));
        }
        return new FileInfo(this.getName());
    }

    private IFileInfo createDirectoryInfo(String name) {
        FileInfo result = new FileInfo(name);
        result.setExists(true);
        result.setDirectory(true);
        return result;
    }

    private ZipEntry findEntry(String name, ZipInputStream in) throws IOException {
        ZipEntry current;
        while ((current = in.getNextEntry()) != null) {
            if (!current.getName().equals(name)) continue;
            return current;
        }
        return null;
    }

    public IFileStore getChild(String name) {
        return new ZipFileStore(this.rootStore, this.path.append(name));
    }

    public String getName() {
        String name = this.path.lastSegment();
        return name == null ? "" : name;
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() > 0) {
            return new ZipFileStore(this.rootStore, this.path.removeLastSegments(1));
        }
        return null;
    }

    private boolean isAncestor(String ancestor, String child) {
        int ancestorLength = ancestor.length();
        if (ancestorLength == 0) {
            return true;
        }
        return child.startsWith(ancestor) && child.length() > ancestorLength && child.charAt(ancestorLength) == '/';
    }

    private boolean isParent(String parent, String child) {
        int chop = parent.length() + 1;
        return child.startsWith(parent) && child.length() > chop && child.substring(chop).indexOf(47) == -1;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream in = new ZipInputStream(this.rootStore.openInputStream(0, monitor));){
                ZipEntry entry = this.findEntry(this.path.toString(), in);
                if (entry == null) {
                    throw new CoreException(Status.error((String)("File not found: " + this.rootStore.toString())));
                }
                if (entry.isDirectory()) {
                    throw new CoreException(Status.error((String)("Resource is not a file: " + this.rootStore.toString())));
                }
                return in;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Could not read file: " + this.rootStore.toString()), (Throwable)e));
        }
    }

    public URI toURI() {
        try {
            return new URI("zip", null, this.path.makeAbsolute().toString(), this.rootStore.toURI().toString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

