/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.filesystem;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CollapseZipHandler
extends AbstractHandler {
    private void collapseZip(IFolder folder, Shell shell) {
        try {
            URI zipURI = new URI(folder.getLocationURI().getQuery());
            IFileStore parentStore = EFS.getStore((URI)folder.getParent().getLocationURI());
            URI childURI = parentStore.getChild(folder.getName()).toURI();
            if (URIUtil.equals((URI)zipURI, (URI)childURI)) {
                folder.delete(0, null);
                folder.getParent().refreshLocal(2, null);
            } else {
                IFile file = folder.getParent().getFile((IPath)new Path(folder.getName()));
                file.createLink(zipURI, 256, null);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error opening zip file");
            e.printStackTrace();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IFolder)) {
            return null;
        }
        this.collapseZip((IFolder)element, shell);
        return null;
    }
}

