/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.zip;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class ZipFileSystemContributor
extends FileSystemContributor {
    public URI getURI(String pathString) {
        try {
            if (pathString.startsWith("zip")) {
                return new URI(pathString);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        int length = pathString.length();
        StringBuffer pathBuf = new StringBuffer(length + 1);
        pathBuf.append("file:");
        if (length > 0 && pathString.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (pathString.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(pathString);
        try {
            return new URI("zip", null, "/", pathBuf.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI browseFileSystem(String initialPath, Shell shell) {
        FileDialog dialog = new FileDialog(shell);
        if (initialPath.length() > 0) {
            dialog.setFilterPath(initialPath);
        }
        dialog.setFilterExtensions(new String[]{"*.zip"});
        String selectedFile = dialog.open();
        if (selectedFile == null) {
            return null;
        }
        return this.getURI(selectedFile);
    }
}

