/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.ui.console.ConsolePlugin;

public class ConsoleDocumentAdapter
implements IDocumentAdapter,
IDocumentListener {
    private static final boolean ASSERT = false;
    private static final int GROW = 500;
    private final List<TextChangeListener> textChangeListeners = new ArrayList<TextChangeListener>();
    private int fixedConsoleWidth;
    private IDocument document;
    private String[] docLegalLineDelimiters;
    private int widgetLines;
    private int[] widgetLineOffsets = new int[1];
    private int predictedCharCount;
    private int predictedLines;

    public ConsoleDocumentAdapter(int width) {
        this.setWidth(width);
    }

    public void setDocument(IDocument doc) {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        this.document = doc;
        this.docLegalLineDelimiters = null;
        this.updateWidgetOffsets(0);
        if (doc != null) {
            doc.addDocumentListener((IDocumentListener)this);
            this.docLegalLineDelimiters = doc.getLegalLineDelimiters();
        }
    }

    public synchronized void addTextChangeListener(TextChangeListener listener) {
        Assert.isLegal((listener != null ? 1 : 0) != 0, (String)"listener null");
        if (!this.textChangeListeners.contains(listener)) {
            this.textChangeListeners.add(listener);
        }
    }

    public synchronized void removeTextChangeListener(TextChangeListener listener) {
        Assert.isLegal((listener != null ? 1 : 0) != 0, (String)"listener null");
        this.textChangeListeners.remove(listener);
    }

    public int getCharCount() {
        return this.document.getLength();
    }

    public String getLine(int lineIndex) {
        try {
            IRegion lineRegion = this.getLineInformation(lineIndex);
            return this.document.get(lineRegion.getOffset(), lineRegion.getLength());
        }
        catch (BadLocationException e) {
            this.log(e);
            return "";
        }
    }

    private IRegion getLineInformation(int widgetLineIndex) throws BadLocationException {
        if (!this.isFixedWidth()) {
            return this.document.getLineInformation(widgetLineIndex);
        }
        int widgetLineOffset = this.getLineOffset(widgetLineIndex);
        IRegion docLine = this.document.getLineInformationOfOffset(widgetLineOffset);
        int widgetLineLength = docLine.getLength();
        widgetLineLength -= widgetLineOffset - docLine.getOffset();
        widgetLineLength = Math.min(widgetLineLength, this.fixedConsoleWidth);
        return new Region(widgetLineOffset, widgetLineLength);
    }

    public int getLineAtOffset(int offset) {
        try {
            return this.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            this.log(e);
            return offset < 0 ? 0 : this.widgetLines - 1;
        }
    }

    private int getLineOfOffset(int offset) throws BadLocationException {
        if (!this.isFixedWidth()) {
            return this.document.getLineOfOffset(offset);
        }
        if (offset < 0 || offset > this.getCharCount()) {
            throw new BadLocationException(String.valueOf(offset) + " is not a valid offset.");
        }
        int widgetLine = Arrays.binarySearch(this.widgetLineOffsets, 0, this.widgetLines, offset);
        if (widgetLine < 0) {
            widgetLine = -widgetLine - 2;
        }
        return widgetLine;
    }

    public int getLineCount() {
        return this.widgetLines;
    }

    public String getLineDelimiter() {
        return System.lineSeparator();
    }

    public int getOffsetAtLine(int lineIndex) {
        try {
            return this.getLineOffset(lineIndex);
        }
        catch (BadLocationException e) {
            this.log(e);
            return -1;
        }
    }

    private int getLineOffset(int widgetLineIndex) throws BadLocationException {
        if (!this.isFixedWidth()) {
            return this.document.getLineOffset(widgetLineIndex);
        }
        if (widgetLineIndex < 0 || widgetLineIndex >= this.widgetLines) {
            throw new BadLocationException(String.valueOf(widgetLineIndex) + " is not a valid line index.");
        }
        return this.widgetLineOffsets[widgetLineIndex];
    }

    public String getTextRange(int start, int length) {
        try {
            return this.document.get(start, length);
        }
        catch (BadLocationException e) {
            this.log(e);
            return null;
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        try {
            this.document.replace(start, replaceLength, text);
        }
        catch (BadLocationException e) {
            this.log(e);
        }
    }

    public synchronized void setText(String text) {
        this.document.set(text == null ? "" : text);
        TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener listener : this.textChangeListeners) {
            listener.textSet(changeEvent);
        }
    }

    public synchronized void documentAboutToBeChanged(DocumentEvent event) {
        TextChangingEvent changingEvent;
        if (!this.isFixedWidth()) {
            changingEvent = new TextChangingEvent((StyledTextContent)this);
            changingEvent.start = event.getOffset();
            changingEvent.newText = event.getText() == null ? "" : event.getText();
            changingEvent.replaceCharCount = event.getLength();
            changingEvent.newCharCount = changingEvent.newText.length();
            try {
                changingEvent.replaceLineCount = this.document.getNumberOfLines(event.getOffset(), event.getLength()) - 1;
            }
            catch (BadLocationException e) {
                this.log(e);
            }
            changingEvent.newLineCount = this.document.computeNumberOfLines(changingEvent.newText);
        } else {
            try {
                changingEvent = this.generateTextChangingEvent(event);
            }
            catch (BadLocationException e) {
                this.log(e);
                changingEvent = new TextChangingEvent((StyledTextContent)this);
            }
        }
        for (TextChangeListener listener : this.textChangeListeners) {
            listener.textChanging(changingEvent);
        }
    }

    private TextChangingEvent generateTextChangingEvent(DocumentEvent event) throws BadLocationException {
        String newText = event.getText() == null ? "" : event.getText();
        int newTextLength = newText.length();
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
        int replaceLineCount = 0;
        int newLineCount = 0;
        if (newTextLength >= 0 || eventLength > 0) {
            int lastInsertLength;
            int firstDocLineIndex = this.document.getLineOfOffset(eventOffset);
            int firstDocLineOffset = this.document.getLineOffset(firstDocLineIndex);
            if (eventOffset != firstDocLineOffset && (eventOffset - firstDocLineOffset) % this.fixedConsoleWidth == 0) {
                ++eventLength;
                newText = String.valueOf(this.document.get(--eventOffset, 1)) + newText;
                ++newTextLength;
            }
            int eventEnd = eventOffset + eventLength;
            int firstWidgetLineIndex = this.getLineOfOffset(eventOffset);
            int firstWidgetLineOffset = this.getLineOffset(firstWidgetLineIndex);
            int lastDocLineLengthDiff = -eventLength;
            int newTextOffset = 0;
            int[] result = TextUtilities.indexOf((String[])this.docLegalLineDelimiters, (String)newText, (int)newTextOffset);
            if (result[1] < 0) {
                lastInsertLength = eventOffset - firstWidgetLineOffset + newTextLength;
                lastDocLineLengthDiff += newTextLength;
            } else {
                int lastTextPartLength;
                int firstInsertLength = result[0];
                newLineCount = this.linesIfWrapped(eventOffset - firstWidgetLineOffset + firstInsertLength);
                while ((result = TextUtilities.indexOf((String[])this.docLegalLineDelimiters, (String)newText, (int)(newTextOffset = result[0] + this.docLegalLineDelimiters[result[1]].length())))[1] >= 0) {
                    int insertedLineLength = result[0] - newTextOffset;
                    newLineCount += this.linesIfWrapped(insertedLineLength);
                }
                lastInsertLength = lastTextPartLength = newTextLength - newTextOffset;
                lastDocLineLengthDiff += lastTextPartLength;
                lastDocLineLengthDiff -= eventOffset - firstWidgetLineOffset;
            }
            int lastDocLineIndex = this.document.getLineOfOffset(eventEnd);
            IRegion lastDocLine = this.document.getLineInformation(lastDocLineIndex);
            int affectedContentAfterRange = 0;
            if (lastDocLineLengthDiff != 0) {
                affectedContentAfterRange = lastDocLine.getOffset() + lastDocLine.getLength() - eventEnd;
            }
            newLineCount += this.linesIfWrapped(lastInsertLength + affectedContentAfterRange) - 1;
            int lastAffectedOffset = eventEnd + affectedContentAfterRange;
            int lastAffectedWidgetLineIndex = this.getLineOfOffset(lastAffectedOffset);
            int lastAffectedWidgetLineOffset = this.getLineOffset(lastAffectedWidgetLineIndex);
            if (lastAffectedWidgetLineOffset == lastAffectedOffset && lastDocLine.getOffset() != lastAffectedOffset) {
                --lastAffectedWidgetLineIndex;
            }
            replaceLineCount = lastAffectedWidgetLineIndex - firstWidgetLineIndex;
        }
        TextChangingEvent changingEvent = new TextChangingEvent((StyledTextContent)this);
        changingEvent.start = eventOffset;
        changingEvent.newText = newText;
        changingEvent.replaceCharCount = eventLength;
        changingEvent.newCharCount = newTextLength;
        changingEvent.replaceLineCount = replaceLineCount;
        changingEvent.newLineCount = newLineCount;
        return changingEvent;
    }

    private int linesIfWrapped(int lineLength) {
        if (this.fixedConsoleWidth <= 0 || lineLength <= 0) {
            return 1;
        }
        return (lineLength - 1) / this.fixedConsoleWidth + 1;
    }

    public synchronized void documentChanged(DocumentEvent event) {
        this.updateWidgetOffsets(event.getOffset());
        TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener listener : this.textChangeListeners) {
            listener.textChanged(changeEvent);
        }
    }

    private void updateWidgetOffsets(int fromOffset) {
        if (this.document == null) {
            this.widgetLines = 0;
            return;
        }
        int docLines = this.document.getNumberOfLines();
        if (!this.isFixedWidth()) {
            this.widgetLines = docLines;
        } else {
            try {
                int widgetLineIndex;
                int offset = Math.max(fromOffset, 0);
                int docLineIndex = Math.max(this.document.getLineOfOffset(offset), 0);
                int docLineOffset = this.document.getLineOffset(docLineIndex);
                if (docLineOffset > 0) {
                    widgetLineIndex = this.getLineOfOffset(docLineOffset);
                } else {
                    widgetLineIndex = 0;
                    this.setLookupEntry(widgetLineIndex, 0);
                }
                while (docLineIndex < docLines) {
                    int lineLength = this.document.getLineInformation(docLineIndex).getLength();
                    while (lineLength > this.fixedConsoleWidth) {
                        this.setLookupEntry(++widgetLineIndex, this.widgetLineOffsets[widgetLineIndex - 1] + this.fixedConsoleWidth);
                        lineLength -= this.fixedConsoleWidth;
                    }
                    String docLineDelimiter = this.document.getLineDelimiter(docLineIndex);
                    if (docLineDelimiter != null) {
                        this.setLookupEntry(++widgetLineIndex, this.widgetLineOffsets[widgetLineIndex - 1] + lineLength + docLineDelimiter.length());
                    }
                    ++docLineIndex;
                }
                this.widgetLines = widgetLineIndex + 1;
            }
            catch (BadLocationException e) {
                this.log(e);
            }
        }
    }

    private void setLookupEntry(int widgetLineIndex, int value) {
        this.ensureOffsetsCapacity(widgetLineIndex + 1);
        this.widgetLineOffsets[widgetLineIndex] = value;
    }

    private void ensureOffsetsCapacity(int requiredSize) {
        int oldSize;
        int n = oldSize = this.widgetLineOffsets != null ? this.widgetLineOffsets.length : 0;
        if (oldSize < requiredSize) {
            int[] oldWidgetOffsets = this.widgetLineOffsets;
            this.widgetLineOffsets = new int[requiredSize + 500];
            if (oldSize > 0) {
                System.arraycopy(oldWidgetOffsets, 0, this.widgetLineOffsets, 0, oldSize);
            }
        }
    }

    public boolean isFixedWidth() {
        return this.fixedConsoleWidth > 0;
    }

    public int getWidth() {
        return this.fixedConsoleWidth;
    }

    public void setWidth(int width) {
        if (width != this.fixedConsoleWidth) {
            this.fixedConsoleWidth = width;
            this.updateWidgetOffsets(0);
            TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
            for (TextChangeListener listener : this.textChangeListeners) {
                listener.textSet(changeEvent);
            }
        }
    }

    private void log(Throwable error) {
        ConsolePlugin.log(ConsolePlugin.newErrorStatus("fixed width: " + this.isFixedWidth(), error));
    }

    private void updatePrediction(TextChangingEvent event) {
        this.predictedCharCount = this.getCharCount() + event.newCharCount - event.replaceCharCount;
        this.predictedLines = this.getLineCount() + event.newLineCount - event.replaceLineCount;
    }

    private void verifyPrediction() {
        int charCount = this.getCharCount();
        Assert.isTrue((this.predictedCharCount == charCount ? 1 : 0) != 0, (String)String.format(Locale.ROOT, "Wrong char count. Expected<%d>, Actual<%d>", this.predictedCharCount, charCount));
        int lineCount = this.getLineCount();
        Assert.isTrue((this.predictedLines == lineCount ? 1 : 0) != 0, (String)String.format(Locale.ROOT, "Wrong line count. Expected<%d>, Actual<%d>", this.predictedLines, lineCount));
    }
}

