/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlListViewer
extends StructuredViewer {
    Composite control;
    private final ScrolledComposite scrolled;
    private final Composite noEntryArea;
    protected boolean hasFocus;

    public ControlListViewer(Composite parent, int style) {
        this.scrolled = new ScrolledComposite(parent, style | 0x200);
        int height = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        this.scrolled.getVerticalBar().setIncrement(height * 2);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.control = new Composite((Composite)this.scrolled, 0){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    ControlListViewer.this.updateSize((Control)ControlListViewer.this.control);
                }
            }
        };
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.control.setLayout((Layout)layout);
        this.control.setBackground(parent.getDisplay().getSystemColor(25));
        this.control.setBackgroundMode(2);
        this.control.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ControlListViewer.this.updateVisibleItems();
            }

            public void controlResized(ControlEvent e) {
                ControlListViewer.this.updateVisibleItems();
            }
        });
        this.scrolled.setContent((Control)this.control);
        this.hookControl((Control)this.control);
        this.noEntryArea = new Composite((Composite)this.scrolled, 0);
        this.doCreateNoEntryArea(this.noEntryArea);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ControlListViewer.this.updateSize(ControlListViewer.this.scrolled.getContent());
            }
        });
        this.control.addTraverseListener(new TraverseListener(){
            private boolean handleEvent = true;

            public void keyTraversed(TraverseEvent event) {
                if (!this.handleEvent) {
                    return;
                }
                switch (event.detail) {
                    case 32: {
                        Control[] children = ControlListViewer.this.control.getChildren();
                        if (children.length <= 0) break;
                        boolean selected = false;
                        int i = 0;
                        while (i < children.length) {
                            ControlListItem item = (ControlListItem)children[i];
                            if (item.isSelected()) {
                                selected = true;
                                if (i <= 0) break;
                                ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[i - 1].getData()), true);
                                break;
                            }
                            ++i;
                        }
                        if (selected) break;
                        ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[children.length - 1].getData()), true);
                        break;
                    }
                    case 64: {
                        Control[] children = ControlListViewer.this.control.getChildren();
                        if (children.length <= 0) break;
                        boolean selected = false;
                        int i = 0;
                        while (i < children.length) {
                            ControlListItem item = (ControlListItem)children[i];
                            if (item.isSelected()) {
                                selected = true;
                                if (i >= children.length - 1) break;
                                ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[i + 1].getData()), true);
                                break;
                            }
                            ++i;
                        }
                        if (selected) break;
                        ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[0].getData()), true);
                        break;
                    }
                    default: {
                        this.handleEvent = false;
                        event.doit = true;
                        Composite control = ControlListViewer.this.control;
                        Shell shell = control.getShell();
                        while (control != null) {
                            if (control.traverse(event.detail) || !event.doit || control == shell) break;
                            control = control.getParent();
                        }
                        this.handleEvent = true;
                    }
                }
            }
        });
    }

    protected void doCreateNoEntryArea(Composite parent) {
    }

    public void add(Object[] elements) {
        Control element;
        Control[] existingChildren;
        ViewerComparator sorter = this.getComparator();
        HashSet<Object> newItems = new HashSet<Object>(elements.length);
        Object[] objectArray = existingChildren = this.control.getChildren();
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element.getData() != null) {
                newItems.add(element.getData());
            }
            ++n2;
        }
        objectArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element != null) {
                newItems.add(element);
            }
            ++n2;
        }
        Object[] infos = new Object[newItems.size()];
        newItems.toArray(infos);
        if (sorter != null) {
            sorter.sort((Viewer)this, infos);
        }
        Control[] controlArray = existingChildren;
        int n3 = existingChildren.length;
        n = 0;
        while (n < n3) {
            Control element2 = controlArray[n];
            ((ControlListItem)element2).dispose();
            ++n;
        }
        int i = 0;
        while (i < infos.length) {
            ControlListItem<?> item = this.createNewItem(infos[i]);
            item.updateColors(i);
            ++i;
        }
        this.control.layout(true);
        this.doUpdateContent();
    }

    private void updateSize(Control c) {
        if (c == null) {
            return;
        }
        Point size = c.computeSize(this.scrolled.getClientArea().width - 20, -1, true);
        c.setSize(size);
        this.scrolled.setMinSize(size);
    }

    protected void doUpdateContent() {
        if (this.control.getChildren().length > 0) {
            this.updateSize((Control)this.control);
            this.scrolled.setContent((Control)this.control);
        } else {
            this.updateSize((Control)this.noEntryArea);
            this.scrolled.setContent((Control)this.noEntryArea);
        }
    }

    private ControlListItem<?> createNewItem(Object element) {
        final ControlListItem<?> item = this.doCreateItem(this.control, element);
        item.setIndexListener(new ControlListItem.IndexListener(){

            public void selectNext() {
                Control[] children = ControlListViewer.this.control.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (item == children[i]) {
                        if (i >= children.length - 1) break;
                        ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[i + 1].getData()));
                        break;
                    }
                    ++i;
                }
            }

            public void selectPrevious() {
                Control[] children = ControlListViewer.this.control.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (item == children[i]) {
                        if (i <= 0) break;
                        ControlListViewer.this.setSelection((ISelection)new StructuredSelection(children[i - 1].getData()));
                        break;
                    }
                    ++i;
                }
            }

            public void select() {
                ControlListViewer.this.setSelection((ISelection)new StructuredSelection(item.getData()));
                ControlListViewer.this.setFocus();
            }

            public void open() {
                ControlListViewer.this.handleOpen();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo(item);
        item.refresh();
        return item;
    }

    protected abstract ControlListItem<?> doCreateItem(Composite var1, Object var2);

    protected ControlListItem<?> doFindInputItem(Object element) {
        return null;
    }

    protected ControlListItem<?> doFindItem(Object element) {
        Control[] children;
        Control[] controlArray = children = this.control.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed() && child.getData() != null && child.getData().equals(element)) {
                return (ControlListItem)child;
            }
            ++n2;
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.usingElementMap()) {
            this.unmapElement(item);
        }
        item.dispose();
        this.add(new Object[]{element});
    }

    public ScrolledComposite getControl() {
        return this.scrolled;
    }

    protected List<?> getSelectionFromWidget() {
        Control[] children = this.control.getChildren();
        ArrayList selection = new ArrayList(children.length);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            ControlListItem item = (ControlListItem)child;
            if (item.isSelected() && item.getData() != null) {
                selection.add(item.getData());
            }
            ++n2;
        }
        return selection;
    }

    protected void handleOpen() {
        ScrolledComposite c = this.getControl();
        if (c != null && !c.isDisposed()) {
            ISelection selection = this.getSelection();
            this.fireOpen(new OpenEvent((Viewer)this, selection));
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refreshAll();
        this.doUpdateContent();
    }

    protected void internalRefresh(Object element) {
        if (element == null) {
            return;
        }
        if (element.equals(this.getRoot())) {
            this.refreshAll();
            return;
        }
        Widget widget = this.findItem(element);
        if (widget == null) {
            this.add(new Object[]{element});
            return;
        }
        ((ControlListItem)widget).refresh();
        this.updateSize((Control)this.control);
    }

    public void remove(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ControlListItem<?> item = this.doFindItem(element);
            if (item != null) {
                this.unmapElement(element);
                item.dispose();
            }
            ++n2;
        }
        Control[] existingChildren = this.control.getChildren();
        int i = 0;
        while (i < existingChildren.length) {
            ControlListItem item = (ControlListItem)existingChildren[i];
            item.updateColors(i);
            ++i;
        }
        this.control.layout(true);
        this.doUpdateContent();
    }

    public void reveal(Object element) {
        ControlListItem<?> control = this.doFindItem(element);
        if (control != null) {
            this.revealControl((Control)control);
        }
    }

    private void revealControl(Control control) {
        Rectangle clientArea = this.scrolled.getClientArea();
        Point origin = this.scrolled.getOrigin();
        Point location = control.getLocation();
        Point size = control.getSize();
        if (location.y + size.y > origin.y + clientArea.height) {
            this.scrolled.setOrigin(origin.x, location.y + size.y - clientArea.height);
        }
        if (location.y < origin.y) {
            this.scrolled.setOrigin(origin.x, location.y);
        }
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list != null) {
            Control[] children;
            HashSet elements = new HashSet(list);
            Control[] controlArray = children = this.control.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                ControlListItem child = (ControlListItem)c;
                boolean selected = elements.contains(child.getData());
                if (selected != child.isSelected()) {
                    child.setSelected(selected);
                }
                if (reveal && selected) {
                    this.revealControl((Control)child);
                    reveal = false;
                }
                ++n2;
            }
        } else {
            Control[] children;
            Control[] controlArray = children = this.control.getChildren();
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                Control c = controlArray[n3];
                ControlListItem child = (ControlListItem)c;
                if (child.isSelected()) {
                    child.setSelected(false);
                }
                ++n3;
            }
        }
    }

    public void setFocus() {
        Control[] children = this.control.getChildren();
        if (children.length > 0) {
            this.control.forceFocus();
        } else {
            this.noEntryArea.setFocus();
        }
    }

    private void refreshAll() {
        Control[] existingChildren;
        Object[] infos = this.getSortedChildren(this.getRoot());
        Control[] controlArray = existingChildren = this.control.getChildren();
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.dispose();
            ++n2;
        }
        int i = 0;
        while (i < infos.length) {
            ControlListItem<?> item = this.createNewItem(infos[i]);
            item.updateColors(i);
            ++i;
        }
        this.control.layout(true);
        this.doUpdateContent();
    }

    private void updateVisibleItems() {
        Control[] children = this.control.getChildren();
        int top = this.scrolled.getOrigin().y;
        int bottom = top + this.scrolled.getParent().getBounds().height;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            ControlListItem item = (ControlListItem)element;
            item.setDisplayed(top, bottom);
            ++n2;
        }
    }
}

