/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.DocUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.E4ToolItemMenu;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EAttributeEditingSupport;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EAttributeTableViewerColumn;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IGotoObject;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IViewEObjects;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.ModelResourceContentProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.TableViewerUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.EmptyFilterOption;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.TitleAreaFilterDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.TitleAreaFilterDialogWithEmptyOptions;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ListTab
implements IViewEObjects {
    static final String ELIPSIS = "...";
    ConcurrentHashMap<String, List<EObject>> mapId_Object = new ConcurrentHashMap();
    @Inject
    private IEclipseContext context;
    @Inject
    private IModelResource modelResource;
    private TableViewer tvResults;
    @Inject
    private IGotoObject gotoObjectHandler;
    @Inject
    private IResourcePool resourcePool;
    @Inject
    @Translation
    protected Messages Messages;
    @Inject
    MApplication app;
    BundleImageCache imageCache;
    private CTabItem tabItem;
    private ModelResourceContentProvider provider;
    private IDocumentListener documentListener;
    private Collection<?> highlightedItems;
    protected Image imgMarkedItem;
    LinkedHashMap<String, EAttributeTableViewerColumn> defaultColumns = new LinkedHashMap();
    LinkedHashMap<String, EAttributeTableViewerColumn> optionalColumns = new LinkedHashMap();
    LinkedHashMap<String, TableColumn> requiredColumns = new LinkedHashMap();
    private TableViewerColumn colItem;
    private TableViewerColumn colGo;
    private TableViewerColumn colGoXmi;
    private TableViewerColumn colMarked;
    private ToolItem filterByItem;
    private ToolItem filterByAttribute;
    private String filterByAttrName;
    private String filterByItemName;
    private EmptyFilterOption filterByAttrEmptyOption;

    @PreDestroy
    public void preDestroy() {
        this.tvResults.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ((EMFDocumentResourceMediator)this.context.get(EMFDocumentResourceMediator.class)).getDocument().removeDocumentListener(this.documentListener);
    }

    public void saveSettings() {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.e4.tools.emf.ui");
        try {
            Element filter;
            Document doc = DocUtil.createDocument("list-tab");
            Element cols = DocUtil.createChild(doc.getDocumentElement(), "columns");
            ArrayList<TableColumn> allCols = TableViewerUtil.getColumnsInDisplayOrder(this.tvResults);
            for (TableColumn col : allCols) {
                String id = this.requiredColumns.containsValue(col) ? this.getKey(this.requiredColumns, col) : col.getText();
                this.saveColumn(cols, id, col);
            }
            Element filters = DocUtil.createChild(doc.getDocumentElement(), "filters");
            if (E.notEmpty(this.filterByAttrName)) {
                filter = DocUtil.createChild(filters, "filter");
                DocUtil.createChild(filter, "type").setTextContent("attribute");
                DocUtil.createChild(filter, "condition").setTextContent(this.filterByAttrName);
                DocUtil.createChild(filter, "emptyOption").setTextContent(this.filterByAttrEmptyOption.name());
            }
            if (E.notEmpty(this.filterByItemName)) {
                filter = DocUtil.createChild(filters, "filter");
                DocUtil.createChild(filter, "type").setTextContent("item");
                DocUtil.createChild(filter, "condition").setTextContent(this.filterByItemName);
            }
            pref.put("list-tab-xml", ListTab.docToString(doc));
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private String getKey(Map<String, ?> map, Object value) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void saveColumn(Element eleCols, String columnName, TableColumn objCol) {
        Element col = DocUtil.createChild(eleCols, "column");
        DocUtil.createChild(col, "attribute").setTextContent(columnName);
        Integer width = objCol.getWidth();
        DocUtil.createChild(col, "width").setTextContent(width.toString());
    }

    private void loadSettings() {
        block20: {
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.e4.tools.emf.ui");
            boolean restoreColumns = pref.getBoolean("list-tab-remember-columns", false);
            boolean restoreFilters = pref.getBoolean("list-tab-remember-filters", false);
            if (!restoreColumns && !restoreFilters) {
                return;
            }
            String xml = pref.get("list-tab-xml", "");
            if (E.notEmpty(xml)) {
                try {
                    Element ele;
                    int i;
                    NodeList list;
                    Document doc = XmlProcessorFactory.parseWithErrorOnDOCTYPE((InputSource)new InputSource(new StringReader(xml)));
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    if (restoreColumns) {
                        list = (NodeList)xpath.evaluate("//columns/column", doc, XPathConstants.NODESET);
                        i = 0;
                        while (i < list.getLength()) {
                            ele = (Element)list.item(i);
                            String colName = xpath.evaluate("attribute/text()", ele);
                            if (!colName.isEmpty()) {
                                TableColumn col = this.requiredColumns.get(colName);
                                if (col == null) {
                                    col = this.addColumn(colName).getTableViewerColumn().getColumn();
                                }
                                int currentIndex = TableViewerUtil.getVisibleColumnIndex(this.tvResults, col);
                                int[] order = this.tvResults.getTable().getColumnOrder();
                                int idx = 0;
                                while (idx < order.length) {
                                    if (order[idx] > currentIndex) {
                                        int n = idx;
                                        order[n] = order[n] - 1;
                                    } else if (order[idx] == currentIndex) {
                                        order[idx] = order.length - 1;
                                    }
                                    ++idx;
                                }
                                this.tvResults.getTable().setColumnOrder(order);
                                String sWidth = xpath.evaluate("width/text()", ele);
                                try {
                                    col.setWidth(Integer.parseInt(sWidth));
                                }
                                catch (Exception exception) {}
                            }
                            ++i;
                        }
                    }
                    if (!restoreFilters) break block20;
                    list = (NodeList)xpath.evaluate("//filters/filter", doc, XPathConstants.NODESET);
                    i = 0;
                    while (i < list.getLength()) {
                        ele = (Element)list.item(i);
                        String type = xpath.evaluate("type/text()", ele);
                        String condition = xpath.evaluate("condition/text()", ele);
                        String emptyOption = xpath.evaluate("emptyOption/text()", ele);
                        if ("item".equals(type)) {
                            this.filterByItem(condition);
                        } else if ("attribute".equals(type)) {
                            EmptyFilterOption emptyFilterOption;
                            try {
                                emptyFilterOption = EmptyFilterOption.valueOf(emptyOption);
                            }
                            catch (Exception exception) {
                                emptyFilterOption = EmptyFilterOption.INCLUDE;
                            }
                            this.filterByAttribute(condition, emptyFilterOption);
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String docToString(Document doc) throws TransformerException {
        TransformerFactory tf = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return output;
    }

    static String join(Collection<String> items, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    @PostConstruct
    public void postConstruct(CTabFolder tabFolder) {
        this.imageCache = new BundleImageCache((Display)this.context.get(Display.class), this.getClass().getClassLoader());
        tabFolder.addDisposeListener(e -> this.imageCache.dispose());
        try {
            this.imgMarkedItem = this.imageCache.create("org.eclipse.e4.tools.emf.ui", "/icons/full/obj16/mark_occurrences.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.documentListener = new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ListTab.this.reload();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        };
        ((EMFDocumentResourceMediator)this.context.get(EMFDocumentResourceMediator.class)).getDocument().addDocumentListener(this.documentListener);
        this.tabItem = new CTabItem(tabFolder, 0, 1);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tabItem.setControl((Control)composite);
        this.tabItem.setText(this.Messages.ListTab_0);
        this.tabItem.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.widgets.table_obj"));
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        ToolItem button = new ToolItem(toolBar, 8);
        button.setText(this.Messages.ListTab_addColumn + ELIPSIS);
        button.setImage(this.imageCache.create("/icons/full/obj16/add_column.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialogWithEmptyOptions dlg = ListTab.this.createEObjectAttributePicker(ListTab.this.Messages.ListTab_addColumn);
                dlg.setShowEmptyOptions(false);
                if (dlg.open() == 0) {
                    String attName = dlg.getFirstElement().toString();
                    EAttributeTableViewerColumn col = ListTab.this.addColumn(attName);
                    col.getTableViewerColumn().getColumn().pack();
                    ListTab.this.tvResults.refresh();
                }
            }
        });
        button = new ToolItem(toolBar, 8);
        button.setText(this.Messages.ListTab_resetColumns);
        button.setImage(this.imageCache.create("/icons/full/obj16/reset_columns.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (EAttributeTableViewerColumn col : ListTab.this.optionalColumns.values()) {
                    col.dispose();
                }
                ListTab.this.optionalColumns.clear();
            }
        });
        new ToolItem(toolBar, 2);
        this.filterByItem = new ToolItem(toolBar, 0);
        this.filterByItem.setText(this.Messages.ListTab_filterByItem + ELIPSIS);
        this.filterByItem.setImage(this.imageCache.create("/icons/full/obj16/filter_by_item.gif"));
        this.filterByItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialog dlg = ListTab.this.createElementTypePicker(ListTab.this.Messages.ListTab_filterByItem);
                if (dlg.open() == 0) {
                    ListTab.this.filterByItem(dlg.getFirstElement().toString());
                }
            }
        });
        this.filterByAttribute = new ToolItem(toolBar, 0);
        this.filterByAttribute.setText(this.Messages.ListTab_filterByAttribute + ELIPSIS);
        this.filterByAttribute.setImage(this.imageCache.create("/icons/full/obj16/filter_by_attribute.gif"));
        this.filterByAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TitleAreaFilterDialogWithEmptyOptions dlg = ListTab.this.createEObjectAttributePicker(ListTab.this.Messages.ListTab_filterByAttribute);
                if (dlg.open() == 0) {
                    ListTab.this.filterByAttribute(dlg.getFirstElement().toString(), dlg.getEmptyFilterOption());
                }
            }
        });
        ToolItem filterRemove = new ToolItem(toolBar, 0);
        filterRemove.setText(this.Messages.ListTab_removeFilter);
        filterRemove.setImage(this.imageCache.create("/icons/full/obj16/remove_filter.png"));
        filterRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListTab.this.filterByItemName = null;
                ListTab.this.filterByAttrName = null;
                ListTab.this.tvResults.setFilters(new ViewerFilter[0]);
                ListTab.this.filterByItem.setText(ListTab.this.Messages.ListTab_filterByItem + ListTab.ELIPSIS);
                ListTab.this.filterByAttribute.setText(ListTab.this.Messages.ListTab_markAttribute + ListTab.ELIPSIS);
            }
        });
        new ToolItem(toolBar, 2);
        E4ToolItemMenu tiCommands = new E4ToolItemMenu(toolBar, this.context);
        tiCommands.getToolItem().setImage(this.imageCache.create("/icons/full/obj16/command.gif"));
        tiCommands.getToolItem().setText(this.Messages.ListTab_more + ELIPSIS);
        ArrayList<String> commandIds = new ArrayList<String>();
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.mark_duplicate_attributes");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.mark_duplicate_ids");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.mark_duplicate_labels");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.repair_duplicate_ids");
        commandIds.add("~separator~");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.unmark");
        commandIds.add("~separator~");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.autosizeColumns");
        commandIds.add("org.eclipse.e4.tools.emf.ui.command.resetToDefault");
        tiCommands.addCommands(commandIds);
        this.tvResults = new TableViewer(composite, 65536);
        this.tvResults.getTable().setHeaderVisible(true);
        this.tvResults.getTable().setLinesVisible(true);
        this.provider = new ModelResourceContentProvider();
        this.tvResults.setContentProvider((IContentProvider)this.provider);
        this.tvResults.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.tvResults.getTable().getLayoutData()).horizontalSpan = 2;
        final Image imgForm = this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.application_form");
        final Image imgXmi = this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.chart_organisation");
        this.colGo = new TableViewerColumn(this.tvResults, 0);
        this.colGo.getColumn().setText(this.Messages.ListTab_col_go);
        this.requiredColumns.put("GoTree", this.colGo.getColumn());
        this.colGo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return imgForm;
            }

            public String getText(Object element) {
                return "";
            }
        });
        this.colGoXmi = new TableViewerColumn(this.tvResults, 0);
        this.colGoXmi.getColumn().setText(this.Messages.ListTab_col_go2);
        this.requiredColumns.put("GoXmi", this.colGoXmi.getColumn());
        this.colGoXmi.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return imgXmi;
            }
        });
        this.tvResults.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TableViewerUtil.isColumnClicked(ListTab.this.tvResults, e, ListTab.this.colGo)) {
                    ListTab.this.gotoObjectHandler.gotoEObject(0, (EObject)TableViewerUtil.getData(ListTab.this.tvResults, e));
                } else if (TableViewerUtil.isColumnClicked(ListTab.this.tvResults, e, ListTab.this.colGoXmi)) {
                    ListTab.this.gotoObjectHandler.gotoEObject(1, (EObject)TableViewerUtil.getData(ListTab.this.tvResults, e));
                }
            }
        });
        this.colMarked = new TableViewerColumn(this.tvResults, 0);
        this.colMarked.getColumn().setWidth(16);
        this.colMarked.getColumn().setText(this.Messages.ListTab_mark);
        this.requiredColumns.put("Marked", this.colMarked.getColumn());
        this.colMarked.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                Image ret = null;
                if (ListTab.this.isHighlighted(element)) {
                    try {
                        ret = ListTab.this.imgMarkedItem;
                    }
                    catch (Exception exception) {}
                }
                return ret;
            }

            public String getText(Object element) {
                return "";
            }
        });
        this.colItem = new TableViewerColumn(this.tvResults, 0);
        this.colItem.getColumn().setText(this.Messages.ListTab_col_item);
        this.requiredColumns.put("Item", this.colItem.getColumn());
        this.colItem.setLabelProvider((CellLabelProvider)new ColumnLabelProvider_Markable(this){

            public String getText(Object element) {
                EObject eObject = (EObject)element;
                return super.getText((Object)eObject.eClass().getName());
            }
        });
        this.app.getContext().set("org.eclipse.e4.tools.active-object-viewer", (Object)this);
        EAttributeTableViewerColumn colId = new EAttributeTableViewerColumn(this.tvResults, this.Messages.ListTab_elementId, "elementId", this.context);
        this.defaultColumns.put("elementId", colId);
        EAttributeTableViewerColumn_Markable colLabel = new EAttributeTableViewerColumn_Markable(this.tvResults, "label", "label", this.context);
        this.defaultColumns.put("label", colLabel);
        this.tvResults.getTable().addListener(40, event -> {
            event.detail &= 0xFFFFFFDF;
            if ((event.detail & 2) == 0) {
                return;
            }
            TableItem item = (TableItem)event.item;
            if (this.isHighlighted(item.getData())) {
                Table table = (Table)event.widget;
                int clientWidth = table.getClientArea().width;
                GC gc = event.gc;
                gc.setForeground(item.getDisplay().getSystemColor(3));
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.tvResults.getTable().setFocus();
        for (EAttributeTableViewerColumn eAttributeTableViewerColumn : this.defaultColumns.values()) {
            eAttributeTableViewerColumn.getTableViewerColumn().getColumn().setMoveable(true);
        }
        for (TableColumn tableColumn : this.requiredColumns.values()) {
            tableColumn.setMoveable(true);
        }
        this.makeSortable(colId.getTableViewerColumn().getColumn(), new AttributeColumnLabelSorter(colId.getTableViewerColumn().getColumn(), "elementId"));
        this.makeSortable(colLabel.getTableViewerColumn().getColumn(), new AttributeColumnLabelSorter(colLabel.getTableViewerColumn().getColumn(), "label"));
        this.makeSortable(this.colItem.getColumn(), new TableViewerUtil.ColumnLabelSorter(this.colItem.getColumn()));
        this.makeSortable(this.colMarked.getColumn(), new TableViewerUtil.AbstractInvertableTableSorter(){

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                boolean mark1 = ListTab.this.isHighlighted(e1);
                boolean mark2 = ListTab.this.isHighlighted(e2);
                if (mark1 && !mark2) {
                    return -1;
                }
                if (mark2 && !mark1) {
                    return 1;
                }
                return 0;
            }
        });
        this.reload();
        TableViewerUtil.refreshAndPack(this.tvResults);
        this.loadSettings();
    }

    private void makeSortable(TableColumn column, TableViewerUtil.AbstractInvertableTableSorter sorter) {
        new TableViewerUtil.TableSortSelectionListener(this.tvResults, column, sorter, 128, false);
    }

    public void reload() {
        this.tvResults.setInput((Object)this.modelResource);
    }

    public TableViewer getViewer() {
        return this.tvResults;
    }

    public CTabItem getTabItem() {
        return this.tabItem;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    @Override
    public void highlightEObjects(Collection<EObject> items) {
        this.highlightedItems = items;
        this.tvResults.refresh();
    }

    public List<EObject> getAllEObjects() {
        ArrayList<EObject> list = new ArrayList<EObject>();
        TreeIterator itTree = EcoreUtil.getAllContents(this.modelResource.getRoot());
        while (itTree.hasNext()) {
            Object object = itTree.next();
            EObject eObject = (EObject)object;
            EAttribute att = EmfUtil.getAttribute(eObject, "elementId");
            if (att == null) continue;
            list.add(eObject);
        }
        return list;
    }

    @Override
    public Collection<EObject> getSelectedEObjects() {
        ArrayList<EObject> selected = new ArrayList<EObject>();
        for (Object item : ((IStructuredSelection)this.tvResults.getSelection()).toList()) {
            if (!(item instanceof EObject)) continue;
            selected.add((EObject)item);
        }
        return selected;
    }

    @Override
    public void deleteEObjects(Collection<EObject> list) {
        if (!list.isEmpty()) {
            Command cmd = DeleteCommand.create((EditingDomain)this.modelResource.getEditingDomain(), list);
            if (cmd.canExecute()) {
                this.modelResource.getEditingDomain().getCommandStack().execute(cmd);
            }
            this.reload();
        }
    }

    private TitleAreaFilterDialogWithEmptyOptions createEObjectAttributePicker(final String title) {
        HashSet<String> set = new HashSet<String>();
        Collection allEObjects = this.getAllEObjects();
        for (EObject obj : allEObjects) {
            for (EAttribute attribute : obj.eClass().getEAllAttributes()) {
                set.add(attribute.getName());
            }
        }
        final ArrayList sorted = new ArrayList(set);
        sorted.sort(null);
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(element);
            }
        };
        TitleAreaFilterDialogWithEmptyOptions dlg = new TitleAreaFilterDialogWithEmptyOptions((Shell)this.context.get(Shell.class), (ILabelProvider)renderer){

            protected Control createContents(Composite parent) {
                Control ret = super.createContents(parent);
                this.setMessage(ListTab.this.Messages.ListTab_selectAnAttribute);
                try {
                    this.setTitleImage(ListTab.this.imageCache.create("org.eclipse.e4.tools.emf.ui", "/icons/full/wizban/attribute_wiz.gif"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setTitle(title);
                this.setElements(sorted.toArray(new String[0]));
                return ret;
            }
        };
        return dlg;
    }

    private TitleAreaFilterDialog createElementTypePicker(final String title) {
        HashSet<String> set = new HashSet<String>();
        Collection allEObjects = this.getAllEObjects();
        for (EObject obj : allEObjects) {
            set.add(obj.eClass().getName());
        }
        final ArrayList sorted = new ArrayList(set);
        sorted.sort(null);
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(element);
            }
        };
        TitleAreaFilterDialog dlg = new TitleAreaFilterDialog((Shell)this.context.get(Shell.class), (ILabelProvider)renderer){

            protected Control createContents(Composite parent) {
                Control ret = super.createContents(parent);
                this.setMessage(ListTab.this.Messages.ListTab_selectAType);
                this.setTitle(title);
                this.setElements(sorted.toArray(new String[0]));
                return ret;
            }
        };
        return dlg;
    }

    private EAttributeTableViewerColumn addColumn(String attName) {
        EAttributeTableViewerColumn colName = this.defaultColumns.get(attName);
        if (colName == null && (colName = this.optionalColumns.get(attName)) == null) {
            colName = new EAttributeTableViewerColumn_Markable(this.tvResults, attName, attName, this.context);
            this.optionalColumns.put(attName, colName);
            colName.getTableViewerColumn().getColumn().setMoveable(true);
            this.makeSortable(colName.getTableViewerColumn().getColumn(), new AttributeColumnLabelSorter(colName.getTableViewerColumn().getColumn(), attName));
            this.tvResults.refresh();
        }
        return colName;
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.modelResource.getEditingDomain();
    }

    public boolean isHighlighted(Object element) {
        return this.highlightedItems != null && this.highlightedItems.contains(element);
    }

    private void filterByItem(String name) {
        this.filterByItemName = name;
        this.filterByAttrName = null;
        this.filterByAttrEmptyOption = null;
        this.mapId_Object.clear();
        final ArrayList<EObject> filtered = new ArrayList<EObject>();
        for (EObject object : this.getAllEObjects()) {
            if (object.eClass().getName().equals(this.filterByItemName)) {
                filtered.add(object);
            }
            ViewerFilter viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return filtered.contains(element);
                }
            };
            this.tvResults.setFilters(new ViewerFilter[]{viewerFilter});
            this.filterByItem.setText(this.Messages.ListTab_filterByItem + "...(" + this.filterByItemName + ")");
            this.filterByAttribute.setText(this.Messages.ListTab_filterByAttribute + ELIPSIS);
        }
    }

    private void filterByAttribute(String name, final EmptyFilterOption emptyOption) {
        this.filterByAttrName = name;
        this.filterByAttrEmptyOption = emptyOption;
        this.filterByItemName = null;
        this.mapId_Object.clear();
        final ArrayList<EObject> filtered = new ArrayList<EObject>();
        for (EObject object : this.getAllEObjects()) {
            if (EmfUtil.getAttribute(object, this.filterByAttrName) == null) continue;
            filtered.add(object);
            ViewerFilter viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (EmfUtil.getAttribute((EObject)element, ListTab.this.filterByAttrName) == null) {
                        return false;
                    }
                    switch (emptyOption) {
                        case EXCLUDE: {
                            if (E.isEmpty(EmfUtil.getAttributeValue((EObject)element, ListTab.this.filterByAttrName))) {
                                return false;
                            }
                            return filtered.contains(element);
                        }
                        case ONLY: {
                            return !E.notEmpty(EmfUtil.getAttributeValue((EObject)element, ListTab.this.filterByAttrName));
                        }
                    }
                    if (E.isEmpty(EmfUtil.getAttributeValue((EObject)element, ListTab.this.filterByAttrName))) {
                        return true;
                    }
                    return filtered.contains(element);
                }
            };
            this.tvResults.setFilters(new ViewerFilter[]{viewerFilter});
            this.filterByAttribute.setText(this.Messages.ListTab_filterByAttribute + "...(" + this.filterByAttrName + ")");
            this.filterByItem.setText(this.Messages.ListTab_filterByItem + ELIPSIS);
        }
        TableViewerColumn viewerColumn = this.addColumn(this.filterByAttrName).getTableViewerColumn();
        viewerColumn.getColumn().pack();
    }

    @Override
    public void autosizeContent() {
        TableColumn[] tableColumnArray = this.tvResults.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            if (col.getWidth() < 10) {
                col.setWidth(10);
            }
            ++n2;
        }
    }

    @Override
    public void resetToDefault() {
        for (EAttributeTableViewerColumn col : this.optionalColumns.values()) {
            col.dispose();
        }
        this.optionalColumns.clear();
        TableViewerUtil.resetColumnOrder(this.tvResults);
        TableViewerUtil.packAllColumns(this.tvResults);
    }

    private static class AttributeColumnLabelSorter
    extends TableViewerUtil.ColumnLabelSorter {
        private final String attName;

        AttributeColumnLabelSorter(TableColumn col, String attName) {
            super(col);
            this.attName = attName;
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            EAttributeEditingSupport.ATT_TYPE e1Type = EAttributeEditingSupport.getAttributeType(e1, this.attName);
            EAttributeEditingSupport.ATT_TYPE e2Type = EAttributeEditingSupport.getAttributeType(e2, this.attName);
            if (e1Type == EAttributeEditingSupport.ATT_TYPE.BOOLEAN || e2Type == EAttributeEditingSupport.ATT_TYPE.BOOLEAN) {
                Boolean b1 = (Boolean)EmfUtil.getAttributeValue((EObject)e1, this.attName);
                Boolean b2 = (Boolean)EmfUtil.getAttributeValue((EObject)e2, this.attName);
                if (b1 == null && b2 != null) {
                    return -2;
                }
                if (b2 == null && b1 != null) {
                    return 2;
                }
                return b1.compareTo(b2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class ColumnLabelProvider_Markable
    extends ColumnLabelProvider {
        private ColumnLabelProvider_Markable() {
        }

        public Color getBackground(Object element) {
            Color ret = ListTab.this.isHighlighted(element) ? ListTab.this.tvResults.getTable().getDisplay().getSystemColor(7) : super.getBackground(element);
            return ret;
        }
    }

    private class EAttributeTableViewerColumn_Markable
    extends EAttributeTableViewerColumn {
        public EAttributeTableViewerColumn_Markable(TableViewer tvResults, String label, String attName, IEclipseContext context) {
            super(tvResults, label, attName, context);
        }

        @Override
        public Color getBackground(Object element) {
            if (ListTab.this.isHighlighted(element)) {
                Color ret = ListTab.this.tvResults.getTable().getDisplay().getSystemColor(7);
                return ret;
            }
            Color ret = super.getBackground(element);
            return ret;
        }
    }
}

