/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public class PDALaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        String path = file.getFullPath().toString();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("pda.launchType");
        try {
            ILaunchConfiguration[] configurations = launchManager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                String attribute = configuration.getAttribute("pda.debugModel.ATTR_PDA_PROGRAM", null);
                if (path.equals(attribute)) {
                    DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
                    return;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, file.getName());
            workingCopy.setAttribute("pda.debugModel.ATTR_PDA_PROGRAM", path);
            workingCopy.setMappedResources(new IResource[]{file});
            ILaunchConfiguration configuration = workingCopy.doSave();
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }
}

