/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.examples.core.pda.breakpoints.PDALineBreakpoint;
import org.eclipse.debug.examples.core.pda.breakpoints.PDAWatchpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDABreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null) {
            IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("pda.debugModel");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof ILineBreakpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            PDALineBreakpoint lineBreakpoint = new PDALineBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        String extension;
        ITextEditor editorPart;
        IResource resource;
        if (part instanceof ITextEditor && (resource = (IResource)(editorPart = (ITextEditor)part).getEditorInput().getAdapter(IResource.class)) != null && (extension = resource.getFileExtension()) != null && extension.equals("pda")) {
            return editorPart;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String[] variableAndFunctionName = this.getVariableAndFunctionName(part, selection);
        if (variableAndFunctionName != null && part instanceof ITextEditor && selection instanceof ITextSelection) {
            ITextEditor editorPart = (ITextEditor)part;
            int lineNumber = ((ITextSelection)selection).getStartLine();
            IResource resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class);
            String var = variableAndFunctionName[0];
            String fcn = variableAndFunctionName[1];
            this.toggleWatchpoint(resource, lineNumber, fcn, var, true, true);
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return this.getVariableAndFunctionName(part, selection) != null;
    }

    protected void toggleWatchpoint(IResource resource, int lineNumber, String fcn, String var, boolean access, boolean modification) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("pda.debugModel");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof PDAWatchpoint && resource.equals((Object)breakpoint.getMarker().getResource())) {
                PDAWatchpoint watchpoint = (PDAWatchpoint)breakpoint;
                String otherVar = watchpoint.getVariableName();
                String otherFcn = watchpoint.getFunctionName();
                if (otherVar.equals(var) && otherFcn.equals(fcn)) {
                    breakpoint.delete();
                    return;
                }
            }
            ++i;
        }
        PDAWatchpoint watchpoint = new PDAWatchpoint(resource, lineNumber + 1, fcn, var, access, modification);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)watchpoint);
    }

    protected String[] getVariableAndFunctionName(IWorkbenchPart part, ISelection selection) {
        ITextEditor editor = this.getEditor(part);
        if (editor != null && selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IDocumentProvider documentProvider = editor.getDocumentProvider();
            try {
                documentProvider.connect((Object)this);
                IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                IRegion region = document.getLineInformationOfOffset(textSelection.getOffset());
                String string = document.get(region.getOffset(), region.getLength()).trim();
                if (string.startsWith("var ")) {
                    String varName = string.substring(4).trim();
                    String fcnName = this.getFunctionName(document, varName, document.getLineOfOffset(textSelection.getOffset()));
                    String[] stringArray = new String[]{varName, fcnName};
                    return stringArray;
                }
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                documentProvider.disconnect((Object)this);
            }
        }
        return null;
    }

    private String getFunctionName(IDocument document, String varName, int line) {
        String source = document.get();
        int lineIndex = line - 1;
        while (lineIndex >= 0) {
            try {
                String label;
                IRegion information = document.getLineInformation(lineIndex);
                String lineText = document.get(information.getOffset(), information.getLength());
                if (lineText.startsWith(":") && source.contains("call " + (label = lineText.substring(1)))) {
                    return label;
                }
                --lineIndex;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return "_main_";
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (this.canToggleWatchpoints(part, selection)) {
            this.toggleWatchpoints(part, selection);
        } else {
            this.toggleLineBreakpoints(part, selection);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) || this.canToggleWatchpoints(part, selection);
    }
}

