/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.adapters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.FindElementDialog;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.TimeTriggeredProgressMonitorDialog;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTree;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTreeModelViewer;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class PDAVirtualFindAction
extends Action
implements IUpdate {
    private final TreeModelViewer fClientViewer;

    public PDAVirtualFindAction(IPresentationContext context) {
        this.setText("Find");
        this.setId(DebugUIPlugin.getUniqueIdentifier() + ".FindElementAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.find_element_context");
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fClientViewer = (TreeModelViewer)((IDebugView)context.getPart()).getViewer();
    }

    protected VirtualTreeModelViewer initVirtualViewer(TreeModelViewer clientViewer, VirtualViewerListener listener) {
        Object input = clientViewer.getInput();
        ModelDelta stateDelta = new ModelDelta(input, 0);
        clientViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x100000);
        listener.fRemainingUpdatesCount = this.calcUpdatesCount((IModelDelta)stateDelta);
        VirtualTreeModelViewer fVirtualViewer = new VirtualTreeModelViewer(clientViewer.getDisplay(), 0, this.makeVirtualPresentationContext(clientViewer.getPresentationContext()));
        fVirtualViewer.addViewerUpdateListener((IViewerUpdateListener)listener);
        fVirtualViewer.addLabelUpdateListener((ILabelUpdateListener)listener);
        fVirtualViewer.setInput(input);
        if (fVirtualViewer.canToggleColumns()) {
            fVirtualViewer.setShowColumns(clientViewer.isShowColumns());
        }
        fVirtualViewer.updateViewer((IModelDelta)stateDelta);
        return fVirtualViewer;
    }

    protected IPresentationContext makeVirtualPresentationContext(IPresentationContext clientViewerContext) {
        return new PresentationContext(clientViewerContext.getId(), clientViewerContext){
            {
                String[] clientProperties = iPresentationContext.getProperties();
                int i = 0;
                while (i < clientProperties.length) {
                    this.setProperty(clientProperties[i], iPresentationContext.getProperty(clientProperties[i]));
                    ++i;
                }
            }

            public String[] getColumns() {
                String[] clientColumns = super.getColumns();
                if (clientColumns == null || clientColumns.length == 0) {
                    return null;
                }
                int i = 0;
                while (i < clientColumns.length) {
                    if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(clientColumns[i])) {
                        return new String[]{"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME"};
                    }
                    ++i;
                }
                return new String[]{clientColumns[0]};
            }
        };
    }

    public void run() {
        VirtualViewerListener listener = new VirtualViewerListener();
        VirtualTreeModelViewer virtualViewer = this.initVirtualViewer(this.fClientViewer, listener);
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.fClientViewer.getControl().getShell(), 500);
        dialog.setCancelable(true);
        try {
            IRunnableWithProgress progressRedirecter = arg_0 -> this.lambda$0(listener, arg_0);
            dialog.run(true, true, progressRedirecter);
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log((Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        VirtualTree root = virtualViewer.getTree();
        if (!dialog.getProgressMonitor().isCanceled()) {
            ArrayList<VirtualItem> list = new ArrayList<VirtualItem>();
            this.collectAllChildren((VirtualItem)root, list);
            FindLabelProvider labelProvider = new FindLabelProvider(virtualViewer, list);
            VirtualItem result = this.performFind(list, labelProvider);
            if (result != null) {
                this.setSelectionToClient(virtualViewer, (ILabelProvider)labelProvider, result);
            }
        }
        virtualViewer.removeLabelUpdateListener((ILabelUpdateListener)listener);
        virtualViewer.removeViewerUpdateListener((IViewerUpdateListener)listener);
        virtualViewer.dispose();
    }

    private int calcUpdatesCount(IModelDelta stateDelta) {
        int[] count = new int[1];
        IModelDeltaVisitor deltaCounter = (delta, depth) -> {
            if ((delta.getFlags() & 0x100000) != 0) {
                nArray[0] = count[0] + delta.getChildCount();
                return true;
            }
            return false;
        };
        stateDelta.accept(deltaCounter);
        return count[0] * 2;
    }

    private void collectAllChildren(VirtualItem element, List<VirtualItem> collect) {
        VirtualItem[] children = element.getItems();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].needsLabelUpdate()) {
                    collect.add(children[i]);
                    this.collectAllChildren(children[i], collect);
                }
                ++i;
            }
        }
    }

    protected VirtualItem performFind(List<VirtualItem> items, FindLabelProvider labelProvider) {
        Object[] elements;
        FindElementDialog dialog = new FindElementDialog(this.fClientViewer.getControl().getShell(), (ILabelProvider)labelProvider, items.toArray());
        dialog.setTitle("PDA Variables View Find");
        dialog.setMessage("&Specify an element to select (? = any character, * = any String):");
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            return (VirtualItem)elements[0];
        }
        return null;
    }

    protected void setSelectionToClient(VirtualTreeModelViewer virtualViewer, ILabelProvider labelProvider, VirtualItem findItem) {
        virtualViewer.getTree().setSelection(new VirtualItem[]{findItem});
        ModelDelta stateDelta = new ModelDelta(virtualViewer.getInput(), 0);
        virtualViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x200000);
        this.fClientViewer.updateViewer((IModelDelta)stateDelta);
        ISelection selection = this.fClientViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || !((IStructuredSelection)selection).getFirstElement().equals(findItem.getData())) {
            DebugUIPlugin.errorDialog((Shell)this.fClientViewer.getControl().getShell(), (String)"Error", (String)("Could not select item:" + labelProvider.getText((Object)findItem)), (IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Element no longer in viewer."));
        }
    }

    public void update() {
        this.setEnabled(this.fClientViewer.getInput() != null && this.fClientViewer.getChildCount(TreePath.EMPTY) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$0(VirtualViewerListener var1_1, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        var3_3 = var1_1;
        synchronized (var3_3) {
            var1_1.fProgressMonitor = monitor;
            var1_1.fProgressMonitor.beginTask(DebugUIPlugin.removeAccelerators((String)this.getText()), var1_1.fRemainingUpdatesCount);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl12
        }
        do {
            Thread.sleep(1L);
lbl12:
            // 2 sources

        } while ((!var1_1.fLabelUpdatesComplete || !var1_1.fViewerUpdatesComplete) && !var1_1.fProgressMonitor.isCanceled());
        var3_3 = var1_1;
        synchronized (var3_3) {
            var1_1.fProgressMonitor = null;
        }
    }

    private static class FindLabelProvider
    extends LabelProvider {
        private final VirtualTreeModelViewer fVirtualViewer;
        private final Map<VirtualItem, String> fTextCache = new HashMap<VirtualItem, String>();

        public FindLabelProvider(VirtualTreeModelViewer viewer, List<VirtualItem> items) {
            this.fVirtualViewer = viewer;
            int i = 0;
            while (i < items.size()) {
                VirtualItem item = items.get(i);
                this.fTextCache.put(item, this.fVirtualViewer.getText(item, 0));
                ++i;
            }
        }

        public Image getImage(Object element) {
            return this.fVirtualViewer.getImage((VirtualItem)element, 0);
        }

        public String getText(Object element) {
            return this.fTextCache.get(element);
        }
    }

    protected static class VirtualViewerListener
    implements IViewerUpdateListener,
    ILabelUpdateListener {
        private boolean fViewerUpdatesComplete = false;
        private boolean fLabelUpdatesComplete = false;
        private IProgressMonitor fProgressMonitor;
        private int fRemainingUpdatesCount = 0;

        protected VirtualViewerListener() {
        }

        public void labelUpdateStarted(ILabelUpdate update) {
        }

        public void labelUpdateComplete(ILabelUpdate update) {
            this.incrementProgress(1);
        }

        public void labelUpdatesBegin() {
            this.fLabelUpdatesComplete = false;
        }

        public void labelUpdatesComplete() {
            this.fLabelUpdatesComplete = true;
            this.completeProgress();
        }

        public void updateStarted(IViewerUpdate update) {
        }

        public void updateComplete(IViewerUpdate update) {
            if (update instanceof IChildrenUpdate) {
                this.incrementProgress(((IChildrenUpdate)update).getLength());
            }
        }

        public void viewerUpdatesBegin() {
            this.fViewerUpdatesComplete = false;
        }

        public void viewerUpdatesComplete() {
            this.fViewerUpdatesComplete = true;
            this.completeProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeProgress() {
            IProgressMonitor pm;
            VirtualViewerListener virtualViewerListener = this;
            synchronized (virtualViewerListener) {
                pm = this.fProgressMonitor;
            }
            if (pm != null && this.fLabelUpdatesComplete && this.fViewerUpdatesComplete) {
                pm.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incrementProgress(int count) {
            IProgressMonitor pm;
            VirtualViewerListener virtualViewerListener = this;
            synchronized (virtualViewerListener) {
                pm = this.fProgressMonitor;
                this.fRemainingUpdatesCount -= count;
            }
            if (pm != null && this.fLabelUpdatesComplete && this.fViewerUpdatesComplete) {
                pm.worked(count);
            }
        }
    }
}

