/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.views;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.examples.core.pda.model.PDAStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.examples.ui.pda.views.DataStackView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractDataStackViewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (part instanceof DataStackView) {
            DataStackView view = (DataStackView)part;
            ISelection selection = DebugUITools.getDebugContextForEventChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                PDAThread thread = null;
                if (element instanceof PDAThread) {
                    thread = (PDAThread)element;
                } else if (element instanceof PDAStackFrame) {
                    thread = (PDAThread)((PDAStackFrame)element).getThread();
                }
                if (element != null) {
                    this.doExecute(view, thread, HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event));
                }
            }
        } else {
            throw new ExecutionException("Handler must be with DataStackView only");
        }
        return null;
    }

    protected abstract void doExecute(DataStackView var1, PDAThread var2, ISelection var3) throws ExecutionException;
}

