/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DebugUIPlugin
extends AbstractUIPlugin {
    private static DebugUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private static final String ICONS_PATH = "icons/full/";
    private static final String PATH_OBJECT = "icons/full/obj16/";
    private static final String PATH_ELOCALTOOL = "icons/full/elcl16/";
    private static final String PATH_DLOCALTOOL = "icons/full/dlcl16/";
    public static final String PLUGIN_ID = "org.eclipse.debug.examples.ui";
    public static final String IMG_ELCL_POP = "IMG_ELCL_POP";
    public static final String IMG_DLCL_POP = "IMG_DLCL_POP";
    public static final String IMG_ELCL_PUSH = "IMG_ELCL_PUSH";
    public static final String IMG_DLCL_PUSH = "IMG_DLCL_PUSH";
    public static final String IMG_OBJ_PDA = "IMB_OBJ_PDA";
    public static final String IMG_OBJ_MIDI = "IMB_OBJ_MIDI";
    public static final RGB KEYWORD;
    public static final RGB LABEL;
    private final Map<RGB, Color> fColors = new HashMap<RGB, Color>();

    static {
        KEYWORD = new RGB(0, 0, 255);
        LABEL = new RGB(128, 128, 0);
    }

    public DebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
        for (Map.Entry<RGB, Color> entry : this.fColors.entrySet()) {
            entry.getValue().dispose();
        }
    }

    public static DebugUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DebugUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.debug.examples.ui.pda.DebugUIPluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.declareImage(IMG_OBJ_PDA, "icons/full/obj16/pda.gif");
        this.declareImage(IMG_OBJ_MIDI, "icons/full/obj16/note.gif");
        this.declareImage(IMG_ELCL_POP, "icons/full/elcl16/pop.gif");
        this.declareImage(IMG_DLCL_POP, "icons/full/dlcl16/pop.gif");
        this.declareImage(IMG_ELCL_PUSH, "icons/full/elcl16/push.gif");
        this.declareImage(IMG_DLCL_PUSH, "icons/full/dlcl16/push.gif");
    }

    private void declareImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        this.getImageRegistry().put(key, desc);
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColors.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColors.put(rgb, color);
        }
        return color;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }
}

