/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.examples.core.pda.breakpoints.PDALineBreakpoint;
import org.eclipse.debug.examples.core.pda.breakpoints.PDAWatchpoint;
import org.eclipse.debug.examples.core.pda.model.PDADebugTarget;
import org.eclipse.debug.examples.core.pda.model.PDAStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PDAModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public String getText(Object element) {
        if (element instanceof PDADebugTarget) {
            return this.getTargetText((PDADebugTarget)element);
        }
        if (element instanceof PDAThread) {
            return this.getThreadText((PDAThread)element);
        }
        if (element instanceof PDAStackFrame) {
            return this.getStackFrameText((PDAStackFrame)element);
        }
        if (element instanceof PDAWatchpoint) {
            return this.getWatchpointText((PDAWatchpoint)element);
        }
        return null;
    }

    private String getWatchpointText(PDAWatchpoint watchpoint) {
        try {
            String label = watchpoint.getVariableName() + " (" + watchpoint.getFunctionName() + ")";
            if (watchpoint.isAccess()) {
                label = label + " [read]";
            }
            if (watchpoint.isModification()) {
                label = label + " [write]";
            }
            return label;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getTargetText(PDADebugTarget target) {
        try {
            String pgmPath = target.getLaunch().getLaunchConfiguration().getAttribute("pda.debugModel.ATTR_PDA_PROGRAM", null);
            if (pgmPath != null) {
                IPath path = IPath.fromOSString((String)pgmPath);
                String label = "";
                if (target.isTerminated()) {
                    label = "<terminated>";
                }
                return label + "PDA [" + path.lastSegment() + "]";
            }
        }
        catch (CoreException coreException) {}
        return "PDA";
    }

    private String getStackFrameText(PDAStackFrame frame) {
        try {
            return frame.getName() + " (line: " + frame.getLineNumber() + ")";
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    private String getThreadText(PDAThread thread) {
        Object label = thread.getName();
        if (thread.isStepping()) {
            label = (String)label + " (stepping)";
        } else if (thread.isSuspended()) {
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length == 0) {
                label = thread.getError() == null ? (String)label + " (suspended)" : (String)label + " (" + String.valueOf(thread.getError()) + ")";
            } else {
                IBreakpoint breakpoint = breakpoints[0];
                if (breakpoint instanceof PDALineBreakpoint) {
                    PDALineBreakpoint pdaBreakpoint = (PDALineBreakpoint)breakpoint;
                    if (pdaBreakpoint instanceof PDAWatchpoint) {
                        try {
                            PDAWatchpoint watchpoint = (PDAWatchpoint)pdaBreakpoint;
                            label = (String)label + " (watchpoint: " + watchpoint.getSuspendType() + " " + watchpoint.getVariableName() + ")";
                        }
                        catch (CoreException coreException) {}
                    } else {
                        label = pdaBreakpoint.isRunToLineBreakpoint() ? (String)label + " (run to line)" : (String)label + " (suspended at line breakpoint)";
                    }
                }
            }
        } else if (thread.isTerminated()) {
            label = "<terminated> " + (String)label;
        }
        return label;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof IFile || element instanceof ILineBreakpoint) {
            return "pda.editor";
        }
        return null;
    }
}

