/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.examples.core.pda.model.PDADebugTarget;
import org.eclipse.debug.examples.core.pda.model.PDAStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAThread;
import org.eclipse.debug.examples.ui.pda.editor.WordFinder;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class TextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String varName = null;
        try {
            varName = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (varName.startsWith("$") && varName.length() > 1) {
            varName = varName.substring(1);
        }
        PDAStackFrame frame = null;
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof PDAStackFrame) {
            frame = (PDAStackFrame)debugContext;
        } else {
            if (debugContext instanceof PDAThread) {
                PDAThread thread = (PDAThread)debugContext;
                try {
                    frame = (PDAStackFrame)thread.getTopStackFrame();
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            if (debugContext instanceof PDADebugTarget) {
                PDADebugTarget target = (PDADebugTarget)debugContext;
                try {
                    IThread[] threads = target.getThreads();
                    if (threads.length > 0) {
                        frame = (PDAStackFrame)threads[0].getTopStackFrame();
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
        }
        if (frame != null) {
            try {
                IVariable[] variables = frame.getVariables();
                int i = 0;
                while (i < variables.length) {
                    IVariable variable = variables[i];
                    if (variable.getName().equals(varName)) {
                        return varName + " = " + variable.getValue().getValueString();
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return WordFinder.findWord(textViewer.getDocument(), offset);
    }
}

