/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.breakpoints;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAStackFrame;
import org.eclipse.debug.examples.core.pda.model.PDAVariable;
import org.eclipse.debug.examples.ui.pda.breakpoints.PDABreakpointAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDAToggleWatchpointsTarget
extends PDABreakpointAdapter {
    private final boolean fAccessModeEnabled;
    private final boolean fModificationModeEnabled;

    PDAToggleWatchpointsTarget(boolean access, boolean modification) {
        this.fAccessModeEnabled = access;
        this.fModificationModeEnabled = modification;
    }

    @Override
    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (super.canToggleWatchpoints(part, selection)) {
            return true;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ss.getFirstElement() instanceof PDAVariable;
        }
        return false;
    }

    @Override
    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String[] variableAndFunctionName = this.getVariableAndFunctionName(part, selection);
        if (variableAndFunctionName != null && part instanceof ITextEditor && selection instanceof ITextSelection) {
            ITextEditor editorPart = (ITextEditor)part;
            int lineNumber = ((ITextSelection)selection).getStartLine();
            IResource resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class);
            String var = variableAndFunctionName[0];
            String fcn = variableAndFunctionName[1];
            this.toggleWatchpoint(resource, lineNumber, fcn, var, this.fAccessModeEnabled, this.fModificationModeEnabled);
        } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof PDAVariable) {
            final PDAVariable var = (PDAVariable)((IStructuredSelection)selection).getFirstElement();
            final PDAStackFrame frame = var.getStackFrame();
            final Shell shell = part.getSite().getShell();
            new Job("Toggle PDA Watchpoint"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IFile file = PDAToggleWatchpointsTarget.this.getResource(var.getStackFrame());
                        String varName = var.getName();
                        int line = PDAToggleWatchpointsTarget.this.findLine(file, varName);
                        PDAToggleWatchpointsTarget.this.toggleWatchpoint((IResource)file, line, frame.getName(), varName, PDAToggleWatchpointsTarget.this.fAccessModeEnabled, PDAToggleWatchpointsTarget.this.fModificationModeEnabled);
                    }
                    catch (CoreException e) {
                        new WorkbenchJob(shell.getDisplay(), "Toggle PDA Watchpoint"){
                            {
                                super($anonymous0, $anonymous1);
                                this.setSystem(true);
                            }

                            public IStatus runInUIThread(IProgressMonitor submonitor) {
                                ErrorDialog.openError((Shell)shell, (String)"Failed to create PDA watchpoint", (String)"Failed to create PDA watchpoint.\n", (IStatus)e.getStatus());
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private IFile getResource(PDAStackFrame frame) {
        ISourceLocator locator = frame.getLaunch().getSourceLocator();
        Object sourceElement = locator.getSourceElement((IStackFrame)frame);
        if (sourceElement instanceof IFile) {
            return (IFile)sourceElement;
        }
        return null;
    }

    private int findLine(IFile file, String var) throws CoreException {
        int lineNum = 0;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));){
                String varName;
                String line;
                while (!(line = reader.readLine().trim()).startsWith("var") || !(varName = line.substring("var".length()).trim()).equals(var)) {
                    ++lineNum;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return lineNum;
    }

    @Override
    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (this.canToggleWatchpoints(part, selection)) {
            this.toggleWatchpoints(part, selection);
        } else {
            this.toggleLineBreakpoints(part, selection);
        }
    }

    @Override
    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection) || this.canToggleWatchpoints(part, selection);
    }
}

